/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client.tools;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.schematics.client.SchematicHandler;
import com.simibubi.create.content.schematics.client.SchematicTransformation;
import com.simibubi.create.content.schematics.client.tools.ISchematicTool;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.RaycastHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.outliner.AABBOutline;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public abstract class SchematicToolBase
implements ISchematicTool {
    protected SchematicHandler schematicHandler;
    protected BlockPos selectedPos;
    protected Vec3 chasingSelectedPos;
    protected Vec3 lastChasingSelectedPos;
    protected boolean selectIgnoreBlocks;
    protected int selectionRange;
    protected boolean schematicSelected;
    protected boolean renderSelectedFace;
    protected Direction selectedFace;
    protected final List<String> mirrors = Arrays.asList("none", "leftRight", "frontBack");
    protected final List<String> rotations = Arrays.asList("none", "cw90", "cw180", "cw270");

    @Override
    public void init() {
        this.schematicHandler = CreateClient.SCHEMATIC_HANDLER;
        this.selectedPos = null;
        this.selectedFace = null;
        this.schematicSelected = false;
        this.chasingSelectedPos = Vec3.f_82478_;
        this.lastChasingSelectedPos = Vec3.f_82478_;
    }

    @Override
    public void updateSelection() {
        this.updateTargetPos();
        if (this.selectedPos == null) {
            return;
        }
        this.lastChasingSelectedPos = this.chasingSelectedPos;
        Vec3 target = Vec3.m_82528_((Vec3i)this.selectedPos);
        if (target.m_82554_(this.chasingSelectedPos) < 0.001953125) {
            this.chasingSelectedPos = target;
            return;
        }
        this.chasingSelectedPos = this.chasingSelectedPos.m_82549_(target.m_82546_(this.chasingSelectedPos).m_82490_(0.5));
    }

    public void updateTargetPos() {
        boolean snap;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (this.schematicHandler.isDeployed()) {
            Vec3 end;
            SchematicTransformation transformation = this.schematicHandler.getTransformation();
            AABB localBounds = this.schematicHandler.getBounds();
            Vec3 traceOrigin = RaycastHelper.getTraceOrigin((Player)player);
            Vec3 start = transformation.toLocalSpace(traceOrigin);
            RaycastHelper.PredicateTraceResult result = RaycastHelper.rayTraceUntil(start, end = transformation.toLocalSpace(RaycastHelper.getTraceTarget((Player)player, 70.0, traceOrigin)), pos -> localBounds.m_82390_(VecHelper.getCenterOf((Vec3i)pos)));
            this.schematicSelected = !result.missed();
            this.selectedFace = this.schematicSelected ? result.getFacing() : null;
        }
        boolean bl = snap = this.selectedPos == null;
        if (this.selectIgnoreBlocks) {
            float pt = AnimationTickHolder.getPartialTicks();
            this.selectedPos = new BlockPos(player.m_20299_(pt).m_82549_(player.m_20154_().m_82490_((double)this.selectionRange)));
            if (snap) {
                this.lastChasingSelectedPos = this.chasingSelectedPos = Vec3.m_82528_((Vec3i)this.selectedPos);
            }
            return;
        }
        this.selectedPos = null;
        BlockHitResult trace = RaycastHelper.rayTraceRange(player.f_19853_, (Player)player, 75.0);
        if (trace == null || trace.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockPos hit = new BlockPos(trace.m_82450_());
        boolean replaceable = player.f_19853_.m_8055_(hit).m_60767_().m_76336_();
        if (trace.m_82434_().m_122434_().m_122478_() && !replaceable) {
            hit = hit.m_121945_(trace.m_82434_());
        }
        this.selectedPos = hit;
        if (snap) {
            this.lastChasingSelectedPos = this.chasingSelectedPos = Vec3.m_82528_((Vec3i)this.selectedPos);
        }
    }

    @Override
    public void renderTool(PoseStack ms, SuperRenderTypeBuffer buffer) {
    }

    @Override
    public void renderOverlay(ForgeGui gui, PoseStack poseStack, float partialTicks, int width, int height) {
    }

    @Override
    public void renderOnSchematic(PoseStack ms, SuperRenderTypeBuffer buffer) {
        if (!this.schematicHandler.isDeployed()) {
            return;
        }
        ms.m_85836_();
        AABBOutline outline = this.schematicHandler.getOutline();
        if (this.renderSelectedFace) {
            outline.getParams().highlightFace(this.selectedFace).withFaceTextures(AllSpecialTextures.CHECKERED, AllKeys.ctrlDown() ? AllSpecialTextures.HIGHLIGHT_CHECKERED : AllSpecialTextures.CHECKERED);
        }
        outline.getParams().colored(6850245).withFaceTexture(AllSpecialTextures.CHECKERED).lineWidth(0.0625f);
        outline.render(ms, buffer, AnimationTickHolder.getPartialTicks());
        outline.getParams().clearTextures();
        ms.m_85849_();
    }
}

