/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.edgePoint.station;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.ITransformableTE;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.logistics.block.depot.DepotBehaviour;
import com.simibubi.create.content.logistics.block.display.DisplayLinkBlock;
import com.simibubi.create.content.logistics.trains.IBogeyBlock;
import com.simibubi.create.content.logistics.trains.ITrackBlock;
import com.simibubi.create.content.logistics.trains.TrackEdge;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.CarriageBogey;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraption;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.entity.TrainPacket;
import com.simibubi.create.content.logistics.trains.entity.TravellingPoint;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgePointType;
import com.simibubi.create.content.logistics.trains.management.edgePoint.TrackTargetingBehaviour;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationBlock;
import com.simibubi.create.content.logistics.trains.management.schedule.Schedule;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleItem;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.WorldAttached;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class StationTileEntity
extends SmartTileEntity
implements ITransformableTE {
    public TrackTargetingBehaviour<GlobalStation> edgePoint;
    public LerpedFloat flag;
    protected int failedCarriageIndex;
    protected AssemblyException lastException;
    protected DepotBehaviour depotBehaviour;
    UUID imminentTrain;
    boolean trainPresent;
    boolean trainBackwards;
    boolean trainCanDisassemble;
    boolean trainHasSchedule;
    boolean trainHasAutoSchedule;
    int flagYRot = -1;
    boolean flagFlipped;
    public Component lastDisassembledTrainName;
    public static WorldAttached<Map<BlockPos, BoundingBox>> assemblyAreas = new WorldAttached<Map>(w -> new HashMap());
    Direction assemblyDirection;
    int assemblyLength;
    int[] bogeyLocations;
    IBogeyBlock[] bogeyTypes;
    int bogeyCount;

    public StationTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(20);
        this.lastException = null;
        this.failedCarriageIndex = -1;
        this.flag = LerpedFloat.linear().startWithValue(0.0);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour<GlobalStation>(this, EdgePointType.STATION);
        behaviours.add(this.edgePoint);
        this.depotBehaviour = new DepotBehaviour(this).onlyAccepts(arg_0 -> AllItems.SCHEDULE.isIn(arg_0)).withCallback(s -> this.applyAutoSchedule());
        behaviours.add(this.depotBehaviour);
        this.depotBehaviour.addSubBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.CONTRAPTION_ACTORS, AllAdvancements.TRAIN, AllAdvancements.LONG_TRAIN, AllAdvancements.CONDUCTOR);
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        this.lastException = AssemblyException.read(tag);
        this.failedCarriageIndex = tag.m_128451_("FailedCarriageIndex");
        super.read(tag, clientPacket);
        this.invalidateRenderBoundingBox();
        if (tag.m_128441_("ForceFlag")) {
            this.trainPresent = tag.m_128471_("ForceFlag");
        }
        if (tag.m_128441_("PrevTrainName")) {
            this.lastDisassembledTrainName = Component.Serializer.m_130701_((String)tag.m_128461_("PrevTrainName"));
        }
        if (!clientPacket) {
            return;
        }
        if (!tag.m_128441_("ImminentTrain")) {
            this.imminentTrain = null;
            this.trainPresent = false;
            this.trainCanDisassemble = false;
            this.trainBackwards = false;
            return;
        }
        this.imminentTrain = tag.m_128342_("ImminentTrain");
        this.trainPresent = tag.m_128441_("TrainPresent");
        this.trainCanDisassemble = tag.m_128441_("TrainCanDisassemble");
        this.trainBackwards = tag.m_128441_("TrainBackwards");
        this.trainHasSchedule = tag.m_128441_("TrainHasSchedule");
        this.trainHasAutoSchedule = tag.m_128441_("TrainHasAutoSchedule");
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        AssemblyException.write(tag, this.lastException);
        tag.m_128405_("FailedCarriageIndex", this.failedCarriageIndex);
        if (this.lastDisassembledTrainName != null) {
            tag.m_128359_("PrevTrainName", Component.Serializer.m_130703_((Component)this.lastDisassembledTrainName));
        }
        super.write(tag, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.imminentTrain == null) {
            return;
        }
        tag.m_128362_("ImminentTrain", this.imminentTrain);
        if (this.trainPresent) {
            NBTHelper.putMarker(tag, "TrainPresent");
        }
        if (this.trainCanDisassemble) {
            NBTHelper.putMarker(tag, "TrainCanDisassemble");
        }
        if (this.trainBackwards) {
            NBTHelper.putMarker(tag, "TrainBackwards");
        }
        if (this.trainHasSchedule) {
            NBTHelper.putMarker(tag, "TrainHasSchedule");
        }
        if (this.trainHasAutoSchedule) {
            NBTHelper.putMarker(tag, "TrainHasAutoSchedule");
        }
    }

    @Nullable
    public GlobalStation getStation() {
        return this.edgePoint.getEdgePoint();
    }

    @Override
    public void lazyTick() {
        if (this.isAssembling() && !this.f_58857_.f_46443_) {
            this.refreshAssemblyInfo();
        }
        super.lazyTick();
    }

    @Override
    public void tick() {
        boolean newlyArrived;
        if (this.isAssembling() && this.f_58857_.f_46443_) {
            this.refreshAssemblyInfo();
        }
        super.tick();
        if (this.f_58857_.f_46443_) {
            float currentTarget = this.flag.getChaseTarget();
            if (currentTarget == 0.0f || this.flag.settled()) {
                boolean target;
                boolean bl = target = this.trainPresent || this.isAssembling();
                if ((float)target != currentTarget) {
                    this.flag.chase((double)target, 0.1f, LerpedFloat.Chaser.LINEAR);
                    if (target) {
                        AllSoundEvents.CONTRAPTION_ASSEMBLE.playAt(this.f_58857_, (Vec3i)this.f_58858_, 1.0f, 2.0f, true);
                    }
                }
            }
            boolean settled = this.flag.getValue() > 0.15f;
            this.flag.tickChaser();
            if (currentTarget == 0.0f && settled != this.flag.getValue() > 0.15f) {
                AllSoundEvents.CONTRAPTION_DISASSEMBLE.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.75f, 1.5f, true);
            }
            return;
        }
        GlobalStation station = this.getStation();
        if (station == null) {
            return;
        }
        Train imminentTrain = station.getImminentTrain();
        boolean trainPresent = imminentTrain != null && imminentTrain.getCurrentStation() == station;
        boolean canDisassemble = trainPresent && imminentTrain.canDisassemble();
        UUID imminentID = imminentTrain != null ? imminentTrain.id : null;
        boolean trainHasSchedule = trainPresent && imminentTrain.runtime.getSchedule() != null;
        boolean trainHasAutoSchedule = trainHasSchedule && imminentTrain.runtime.isAutoSchedule;
        boolean bl = newlyArrived = this.trainPresent != trainPresent;
        if (trainPresent && imminentTrain.runtime.displayLinkUpdateRequested) {
            DisplayLinkBlock.notifyGatherers((LevelAccessor)this.f_58857_, this.f_58858_);
            imminentTrain.runtime.displayLinkUpdateRequested = false;
        }
        if (newlyArrived) {
            this.applyAutoSchedule();
        }
        if (newlyArrived || this.trainCanDisassemble != canDisassemble || !Objects.equals(imminentID, this.imminentTrain) || this.trainHasSchedule != trainHasSchedule || this.trainHasAutoSchedule != trainHasAutoSchedule) {
            this.imminentTrain = imminentID;
            this.trainPresent = trainPresent;
            this.trainCanDisassemble = canDisassemble;
            this.trainBackwards = imminentTrain != null && imminentTrain.currentlyBackwards;
            this.trainHasSchedule = trainHasSchedule;
            this.trainHasAutoSchedule = trainHasAutoSchedule;
            this.notifyUpdate();
        }
    }

    public boolean trackClicked(Player player, InteractionHand hand, ITrackBlock track, BlockState state, BlockPos pos) {
        this.refreshAssemblyInfo();
        BoundingBox bb = assemblyAreas.get((LevelAccessor)this.f_58857_).get(this.f_58858_);
        if (bb == null || !bb.m_71051_((Vec3i)pos)) {
            return false;
        }
        BlockPos up = new BlockPos(track.getUpNormal((BlockGetter)this.f_58857_, pos, state));
        int bogeyOffset = pos.m_123333_((Vec3i)this.edgePoint.getGlobalPosition()) - 1;
        if (!this.isValidBogeyOffset(bogeyOffset)) {
            for (int i = -1; i <= 1; ++i) {
                BlockPos bogeyPos = pos.m_5484_(this.assemblyDirection, i).m_121955_((Vec3i)up);
                BlockState blockState = this.f_58857_.m_8055_(bogeyPos);
                Block block = blockState.m_60734_();
                if (!(block instanceof IBogeyBlock)) continue;
                IBogeyBlock bogey = (IBogeyBlock)block;
                this.f_58857_.m_7731_(bogeyPos, bogey.getRotatedBlockState(blockState, Direction.DOWN), 3);
                bogey.playRotateSound(this.f_58857_, bogeyPos);
                return true;
            }
            return false;
        }
        ItemStack handItem = player.m_21120_(hand);
        if (!player.m_7500_() && !AllBlocks.RAILWAY_CASING.isIn(handItem)) {
            player.m_5661_((Component)Lang.translateDirect("train_assembly.requires_casing", new Object[0]), true);
            return false;
        }
        BlockPos targetPos = pos.m_121955_((Vec3i)up);
        if (this.f_58857_.m_8055_(targetPos).m_60800_((BlockGetter)this.f_58857_, targetPos) == -1.0f) {
            return false;
        }
        this.f_58857_.m_46961_(targetPos, true);
        BlockState bogeyAnchor = ProperWaterloggedBlock.withWater((LevelAccessor)this.f_58857_, track.getBogeyAnchor((BlockGetter)this.f_58857_, pos, state), pos);
        this.f_58857_.m_7731_(targetPos, bogeyAnchor, 3);
        player.m_5661_((Component)Lang.translateDirect("train_assembly.bogey_created", new Object[0]), true);
        SoundType soundtype = bogeyAnchor.m_60734_().getSoundType(state, (LevelReader)this.f_58857_, pos, (Entity)player);
        this.f_58857_.m_5594_(null, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        if (!player.m_7500_()) {
            ItemStack itemInHand = player.m_21120_(hand);
            itemInHand.m_41774_(1);
            if (itemInHand.m_41619_()) {
                player.m_21008_(hand, ItemStack.f_41583_);
            }
        }
        return true;
    }

    public boolean isAssembling() {
        BlockState state = this.m_58900_();
        return state.m_61138_((Property)StationBlock.ASSEMBLING) && (Boolean)state.m_61143_((Property)StationBlock.ASSEMBLING) != false;
    }

    public boolean tryEnterAssemblyMode() {
        if (!this.edgePoint.hasValidTrack()) {
            return false;
        }
        BlockPos targetPosition = this.edgePoint.getGlobalPosition();
        BlockState trackState = this.edgePoint.getTrackBlockState();
        ITrackBlock track = this.edgePoint.getTrack();
        Vec3 trackAxis = track.getTrackAxes((BlockGetter)this.f_58857_, targetPosition, trackState).get(0);
        boolean axisFound = false;
        for (Direction.Axis axis : Iterate.axes) {
            if (trackAxis.m_82507_(axis) == 0.0) continue;
            if (axisFound) {
                return false;
            }
            axisFound = true;
        }
        return true;
    }

    public void refreshAssemblyInfo() {
        GlobalStation station;
        if (!this.edgePoint.hasValidTrack()) {
            return;
        }
        if (!(this.isVirtual() || (station = this.getStation()) != null && station.getPresentTrain() == null)) {
            return;
        }
        int prevLength = this.assemblyLength;
        BlockPos targetPosition = this.edgePoint.getGlobalPosition();
        BlockState trackState = this.edgePoint.getTrackBlockState();
        ITrackBlock track = this.edgePoint.getTrack();
        this.getAssemblyDirection();
        BlockPos.MutableBlockPos currentPos = targetPosition.m_122032_();
        currentPos.m_122173_(this.assemblyDirection);
        BlockPos bogeyOffset = new BlockPos(track.getUpNormal((BlockGetter)this.f_58857_, targetPosition, trackState));
        int MAX_LENGTH = (Integer)AllConfigs.SERVER.trains.maxAssemblyLength.get();
        int MAX_BOGEY_COUNT = (Integer)AllConfigs.SERVER.trains.maxBogeyCount.get();
        int bogeyIndex = 0;
        int maxBogeyCount = MAX_BOGEY_COUNT;
        if (this.bogeyLocations == null) {
            this.bogeyLocations = new int[maxBogeyCount];
        }
        if (this.bogeyTypes == null) {
            this.bogeyTypes = new IBogeyBlock[maxBogeyCount];
        }
        Arrays.fill(this.bogeyLocations, -1);
        Arrays.fill(this.bogeyTypes, null);
        for (int i = 0; i < MAX_LENGTH; ++i) {
            if (i == MAX_LENGTH - 1) {
                this.assemblyLength = i;
                break;
            }
            if (!track.trackEquals(trackState, this.f_58857_.m_8055_((BlockPos)currentPos))) {
                this.assemblyLength = Math.max(0, i - 1);
                break;
            }
            BlockState potentialBogeyState = this.f_58857_.m_8055_(bogeyOffset.m_121955_((Vec3i)currentPos));
            Block block = potentialBogeyState.m_60734_();
            if (block instanceof IBogeyBlock) {
                IBogeyBlock bogey = (IBogeyBlock)block;
                if (bogeyIndex < this.bogeyLocations.length) {
                    this.bogeyTypes[bogeyIndex] = bogey;
                    this.bogeyLocations[bogeyIndex] = i;
                    ++bogeyIndex;
                }
            }
            currentPos.m_122173_(this.assemblyDirection);
        }
        this.bogeyCount = bogeyIndex;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (prevLength == this.assemblyLength) {
            return;
        }
        if (this.isVirtual()) {
            return;
        }
        Map<BlockPos, BoundingBox> map = assemblyAreas.get((LevelAccessor)this.f_58857_);
        BlockPos startPosition = targetPosition.m_121945_(this.assemblyDirection);
        BlockPos trackEnd = startPosition.m_5484_(this.assemblyDirection, this.assemblyLength - 1);
        map.put(this.f_58858_, BoundingBox.m_162375_((Vec3i)startPosition, (Vec3i)trackEnd));
    }

    public boolean isValidBogeyOffset(int i) {
        if ((i < 3 || this.bogeyCount == 0) && i != 0) {
            return false;
        }
        for (int j : this.bogeyLocations) {
            if (j == -1) break;
            if (i < j - 2 || i > j + 2) continue;
            return false;
        }
        return true;
    }

    public Direction getAssemblyDirection() {
        if (this.assemblyDirection != null) {
            return this.assemblyDirection;
        }
        if (!this.edgePoint.hasValidTrack()) {
            return null;
        }
        BlockPos targetPosition = this.edgePoint.getGlobalPosition();
        BlockState trackState = this.edgePoint.getTrackBlockState();
        ITrackBlock track = this.edgePoint.getTrack();
        Direction.AxisDirection axisDirection = this.edgePoint.getTargetDirection();
        Vec3 axis = track.getTrackAxes((BlockGetter)this.f_58857_, targetPosition, trackState).get(0).m_82541_().m_82490_((double)axisDirection.m_122540_());
        this.assemblyDirection = Direction.m_122366_((double)axis.f_82479_, (double)axis.f_82480_, (double)axis.f_82481_);
        return this.assemblyDirection;
    }

    @Override
    public void remove() {
        assemblyAreas.get((LevelAccessor)this.f_58857_).remove(this.f_58858_);
        super.remove();
    }

    public void assemble(UUID playerUUID) {
        int pointIndex;
        int loc;
        this.refreshAssemblyInfo();
        if (this.bogeyLocations == null) {
            return;
        }
        if (this.bogeyLocations[0] != 0) {
            this.exception(new AssemblyException((Component)Lang.translateDirect("train_assembly.frontmost_bogey_at_station", new Object[0])), -1);
            return;
        }
        if (!this.edgePoint.hasValidTrack()) {
            return;
        }
        BlockPos trackPosition = this.edgePoint.getGlobalPosition();
        BlockState trackState = this.edgePoint.getTrackBlockState();
        ITrackBlock track = this.edgePoint.getTrack();
        BlockPos bogeyOffset = new BlockPos(track.getUpNormal((BlockGetter)this.f_58857_, trackPosition, trackState));
        TrackNodeLocation location = null;
        Vec3 centre = Vec3.m_82539_((Vec3i)trackPosition).m_82520_(0.0, track.getElevationAtCenter((BlockGetter)this.f_58857_, trackPosition, trackState), 0.0);
        Collection<TrackNodeLocation.DiscoveredLocation> ends = track.getConnected((BlockGetter)this.f_58857_, trackPosition, trackState, true, null);
        Vec3 targetOffset = Vec3.m_82528_((Vec3i)this.assemblyDirection.m_122436_());
        for (TrackNodeLocation.DiscoveredLocation end : ends) {
            if (!Mth.m_14082_((double)0.0, (double)targetOffset.m_82557_(end.getLocation().m_82546_(centre).m_82541_()))) continue;
            location = end;
        }
        if (location == null) {
            return;
        }
        ArrayList<Double> pointOffsets = new ArrayList<Double>();
        int iPrevious = -100;
        for (int i = 0; i < this.bogeyLocations.length && (loc = this.bogeyLocations[i]) != -1; ++i) {
            if (loc - iPrevious < 3) {
                this.exception(new AssemblyException((Component)Lang.translateDirect("train_assembly.bogeys_too_close", i, i + 1)), -1);
                return;
            }
            double bogeySize = this.bogeyTypes[i].getWheelPointSpacing();
            pointOffsets.add((double)loc + 0.5 - bogeySize / 2.0);
            pointOffsets.add((double)loc + 0.5 + bogeySize / 2.0);
            iPrevious = loc;
        }
        ArrayList<TravellingPoint> points = new ArrayList<TravellingPoint>();
        Vec3 directionVec = Vec3.m_82528_((Vec3i)this.assemblyDirection.m_122436_());
        TrackGraph graph = null;
        TrackNode secondNode = null;
        for (int j = 0; j < this.assemblyLength * 2 + 40; ++j) {
            double offset;
            TrackNode node;
            double i = (double)j / 2.0;
            if (points.size() == pointOffsets.size()) break;
            TrackNodeLocation.DiscoveredLocation currentLocation = location;
            location = new TrackNodeLocation(location.getLocation().m_82549_(directionVec.m_82490_(0.5))).in(location.dimension);
            if (graph == null) {
                graph = Create.RAILWAYS.getGraph((LevelAccessor)this.f_58857_, currentLocation);
            }
            if (graph == null || (node = graph.locateNode(currentLocation)) == null) continue;
            for (pointIndex = points.size(); pointIndex < pointOffsets.size() && !((offset = ((Double)pointOffsets.get(pointIndex)).doubleValue()) > i); ++pointIndex) {
                double positionOnEdge = i - offset;
                Map<TrackNode, TrackEdge> connectionsFromNode = graph.getConnectionsFrom(node);
                if (secondNode == null) {
                    for (Map.Entry<TrackNode, TrackEdge> entry : connectionsFromNode.entrySet()) {
                        Vec3 edgeDirection;
                        TrackEdge edge = entry.getValue();
                        TrackNode otherNode = entry.getKey();
                        if (edge.isTurn() || !Mth.m_14082_((double)(edgeDirection = edge.getDirection(true)).m_82541_().m_82526_(directionVec), (double)-1.0)) continue;
                        secondNode = otherNode;
                    }
                }
                if (secondNode == null) {
                    Create.LOGGER.warn("Cannot assemble: No valid starting node found");
                    return;
                }
                TrackEdge edge = connectionsFromNode.get(secondNode);
                if (edge == null) {
                    Create.LOGGER.warn("Cannot assemble: Missing graph edge");
                    return;
                }
                points.add(new TravellingPoint(node, secondNode, edge, positionOnEdge));
            }
            secondNode = node;
        }
        if (points.size() != pointOffsets.size()) {
            Create.LOGGER.warn("Cannot assemble: Not all Points created");
            return;
        }
        if (points.size() == 0) {
            this.exception(new AssemblyException((Component)Lang.translateDirect("train_assembly.no_bogeys", new Object[0])), -1);
            return;
        }
        ArrayList<CarriageContraption> contraptions = new ArrayList<CarriageContraption>();
        ArrayList<Carriage> carriages = new ArrayList<Carriage>();
        ArrayList<Integer> spacing = new ArrayList<Integer>();
        boolean atLeastOneForwardControls = false;
        for (int bogeyIndex = 0; bogeyIndex < this.bogeyCount; ++bogeyIndex) {
            pointIndex = bogeyIndex * 2;
            if (bogeyIndex > 0) {
                spacing.add(this.bogeyLocations[bogeyIndex] - this.bogeyLocations[bogeyIndex - 1]);
            }
            CarriageContraption contraption = new CarriageContraption(this.assemblyDirection);
            BlockPos bogeyPosOffset = trackPosition.m_121955_((Vec3i)bogeyOffset);
            try {
                int offset = this.bogeyLocations[bogeyIndex] + 1;
                boolean success = contraption.assemble(this.f_58857_, bogeyPosOffset.m_5484_(this.assemblyDirection, offset));
                atLeastOneForwardControls |= contraption.hasForwardControls();
                contraption.setSoundQueueOffset(offset);
                if (!success) {
                    this.exception(new AssemblyException((Component)Lang.translateDirect("train_assembly.nothing_attached", bogeyIndex + 1)), -1);
                    return;
                }
            }
            catch (AssemblyException e) {
                this.exception(e, contraptions.size() + 1);
                return;
            }
            IBogeyBlock typeOfFirstBogey = this.bogeyTypes[bogeyIndex];
            CarriageBogey firstBogey = new CarriageBogey(typeOfFirstBogey, (TravellingPoint)points.get(pointIndex), (TravellingPoint)points.get(pointIndex + 1));
            CarriageBogey secondBogey = null;
            BlockPos secondBogeyPos = contraption.getSecondBogeyPos();
            int bogeySpacing = 0;
            if (secondBogeyPos != null) {
                if (bogeyIndex == this.bogeyCount - 1 || !secondBogeyPos.equals((Object)bogeyPosOffset.m_5484_(this.assemblyDirection, this.bogeyLocations[bogeyIndex + 1] + 1))) {
                    this.exception(new AssemblyException((Component)Lang.translateDirect("train_assembly.not_connected_in_order", new Object[0])), contraptions.size() + 1);
                    return;
                }
                bogeySpacing = this.bogeyLocations[bogeyIndex + 1] - this.bogeyLocations[bogeyIndex];
                secondBogey = new CarriageBogey(this.bogeyTypes[bogeyIndex + 1], (TravellingPoint)points.get(pointIndex + 2), (TravellingPoint)points.get(pointIndex + 3));
                ++bogeyIndex;
            } else if (!typeOfFirstBogey.allowsSingleBogeyCarriage()) {
                this.exception(new AssemblyException((Component)Lang.translateDirect("train_assembly.single_bogey_carriage", new Object[0])), contraptions.size() + 1);
                return;
            }
            contraptions.add(contraption);
            carriages.add(new Carriage(firstBogey, secondBogey, bogeySpacing));
        }
        if (!atLeastOneForwardControls) {
            this.exception(new AssemblyException((Component)Lang.translateDirect("train_assembly.no_controls", new Object[0])), -1);
            return;
        }
        for (CarriageContraption contraption : contraptions) {
            contraption.removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
            contraption.expandBoundsAroundAxis(Direction.Axis.Y);
        }
        Train train = new Train(UUID.randomUUID(), playerUUID, graph, carriages, spacing, contraptions.stream().anyMatch(CarriageContraption::hasBackwardControls));
        if (this.lastDisassembledTrainName != null) {
            train.name = this.lastDisassembledTrainName;
            this.lastDisassembledTrainName = null;
        }
        for (int i = 0; i < contraptions.size(); ++i) {
            CarriageContraption contraption = (CarriageContraption)contraptions.get(i);
            Carriage carriage = (Carriage)carriages.get(i);
            carriage.setContraption(this.f_58857_, contraption);
            if (!contraption.containsBlockBreakers()) continue;
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
        GlobalStation station = this.getStation();
        if (station != null) {
            train.setCurrentStation(station);
            station.reserveFor(train);
        }
        train.collectInitiallyOccupiedSignalBlocks();
        Create.RAILWAYS.addTrain(train);
        AllPackets.channel.send(PacketDistributor.ALL.noArg(), (Object)new TrainPacket(train, true));
        this.clearException();
        this.award(AllAdvancements.TRAIN);
        if (contraptions.size() >= 6) {
            this.award(AllAdvancements.LONG_TRAIN);
        }
    }

    public void cancelAssembly() {
        this.assemblyLength = 0;
        assemblyAreas.get((LevelAccessor)this.f_58857_).remove(this.f_58858_);
        this.clearException();
    }

    private void clearException() {
        this.exception(null, -1);
    }

    private void exception(AssemblyException exception, int carriage) {
        this.failedCarriageIndex = carriage;
        this.lastException = exception;
        this.sendData();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        if (this.isAssembling()) {
            return INFINITE_EXTENT_AABB;
        }
        return super.getRenderBoundingBox();
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_, this.edgePoint.getGlobalPosition()).m_82400_(2.0);
    }

    public ItemStack getAutoSchedule() {
        return this.depotBehaviour.getHeldItemStack();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.depotBehaviour.getItemCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    private void applyAutoSchedule() {
        ItemStack stack = this.getAutoSchedule();
        if (!AllItems.SCHEDULE.isIn(stack)) {
            return;
        }
        Schedule schedule = ScheduleItem.getSchedule(stack);
        if (schedule == null || schedule.entries.isEmpty()) {
            return;
        }
        GlobalStation station = this.getStation();
        if (station == null) {
            return;
        }
        Train imminentTrain = station.getImminentTrain();
        if (imminentTrain == null || imminentTrain.getCurrentStation() != station) {
            return;
        }
        this.award(AllAdvancements.CONDUCTOR);
        imminentTrain.runtime.setSchedule(schedule, true);
        AllSoundEvents.CONFIRM.playOnServer(this.f_58857_, (Vec3i)this.f_58858_, 1.0f, 1.0f);
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        Vec3 v = Vec3.m_82539_((Vec3i)this.f_58858_.m_7494_());
        server.m_8767_((ParticleOptions)ParticleTypes.f_123748_, v.f_82479_, v.f_82480_, v.f_82481_, 8, 0.35, 0.05, 0.35, 1.0);
        server.m_8767_((ParticleOptions)ParticleTypes.f_123810_, v.f_82479_, v.f_82480_ + 0.25, v.f_82481_, 10, 0.05, 1.0, 0.05, (double)0.005f);
    }

    public boolean resolveFlagAngle() {
        if (this.flagYRot != -1) {
            return true;
        }
        BlockState target = this.edgePoint.getTrackBlockState();
        Block block = target.m_60734_();
        if (!(block instanceof ITrackBlock)) {
            return false;
        }
        ITrackBlock def = (ITrackBlock)block;
        Vec3 axis = null;
        BlockPos trackPos = this.edgePoint.getGlobalPosition();
        for (Vec3 vec3 : def.getTrackAxes((BlockGetter)this.f_58857_, trackPos, target)) {
            axis = vec3.m_82490_((double)this.edgePoint.getTargetDirection().m_122540_());
        }
        if (axis == null) {
            return false;
        }
        Direction nearest = Direction.m_122366_((double)axis.f_82479_, (double)0.0, (double)axis.f_82481_);
        this.flagYRot = (int)(-nearest.m_122435_() - 90.0f);
        Vec3 diff = Vec3.m_82528_((Vec3i)trackPos.m_121996_((Vec3i)this.f_58858_)).m_82542_(1.0, 0.0, 1.0);
        if (diff.m_82556_() == 0.0) {
            return true;
        }
        this.flagFlipped = diff.m_82526_(Vec3.m_82528_((Vec3i)nearest.m_122427_().m_122436_())) > 0.0;
        return true;
    }

    @Override
    public void transform(StructureTransform transform) {
        this.edgePoint.transform(transform);
    }
}

