/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.display;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.block.display.DisplayBehaviour;
import com.simibubi.create.content.logistics.block.display.source.DeathCounterDisplaySource;
import com.simibubi.create.content.logistics.block.display.source.DisplaySource;
import com.simibubi.create.content.logistics.block.display.source.EnchantPowerDisplaySource;
import com.simibubi.create.content.logistics.block.display.source.RedstonePowerDisplaySource;
import com.simibubi.create.content.logistics.block.display.source.ScoreboardDisplaySource;
import com.simibubi.create.content.logistics.block.display.target.DisplayTarget;
import com.simibubi.create.content.logistics.block.display.target.LecternDisplayTarget;
import com.simibubi.create.content.logistics.block.display.target.SignDisplayTarget;
import com.simibubi.create.foundation.utility.CreateRegistry;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class AllDisplayBehaviours {
    public static final Map<ResourceLocation, DisplayBehaviour> GATHERER_BEHAVIOURS = new HashMap<ResourceLocation, DisplayBehaviour>();
    private static final CreateRegistry<Block, List<DisplaySource>> SOURCES_BY_BLOCK = new CreateRegistry(ForgeRegistries.BLOCKS);
    private static final CreateRegistry<BlockEntityType<?>, List<DisplaySource>> SOURCES_BY_TILE = new CreateRegistry(ForgeRegistries.BLOCK_ENTITY_TYPES);
    private static final CreateRegistry<Block, DisplayTarget> TARGETS_BY_BLOCK = new CreateRegistry(ForgeRegistries.BLOCKS);
    private static final CreateRegistry<BlockEntityType<?>, DisplayTarget> TARGETS_BY_TILE = new CreateRegistry(ForgeRegistries.BLOCK_ENTITY_TYPES);

    public static DisplayBehaviour register(ResourceLocation id, DisplayBehaviour behaviour) {
        behaviour.id = id;
        GATHERER_BEHAVIOURS.put(id, behaviour);
        return behaviour;
    }

    public static void assignBlock(DisplayBehaviour behaviour, ResourceLocation block) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            List<DisplaySource> sources = SOURCES_BY_BLOCK.get((Block)block);
            if (sources == null) {
                sources = new ArrayList<DisplaySource>();
                SOURCES_BY_BLOCK.register((Block)block, sources);
            }
            sources.add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_BLOCK.register((Block)block, target);
        }
    }

    public static void assignTile(DisplayBehaviour behaviour, ResourceLocation teType) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            List<DisplaySource> sources = SOURCES_BY_TILE.get((BlockEntityType<?>)teType);
            if (sources == null) {
                sources = new ArrayList<DisplaySource>();
                SOURCES_BY_TILE.register((BlockEntityType<?>)teType, sources);
            }
            sources.add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_TILE.register((BlockEntityType<?>)teType, target);
        }
    }

    public static void assignBlock(DisplayBehaviour behaviour, Block block) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            List<DisplaySource> sources = SOURCES_BY_BLOCK.get(block);
            if (sources == null) {
                sources = new ArrayList<DisplaySource>();
                SOURCES_BY_BLOCK.register(block, sources);
            }
            sources.add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_BLOCK.register(block, target);
        }
    }

    public static void assignTile(DisplayBehaviour behaviour, BlockEntityType<?> teType) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            List<DisplaySource> sources = SOURCES_BY_TILE.get(teType);
            if (sources == null) {
                sources = new ArrayList<DisplaySource>();
                SOURCES_BY_TILE.register(teType, sources);
            }
            sources.add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_TILE.register(teType, target);
        }
    }

    public static <B extends Block> NonNullConsumer<? super B> assignDataBehaviour(DisplayBehaviour behaviour, String ... suffix) {
        return b -> {
            Object idSuffix;
            ResourceLocation registryName = RegisteredObjects.getKeyOrThrow(b);
            Object object = idSuffix = behaviour instanceof DisplaySource ? "_source" : "_target";
            if (suffix.length > 0) {
                idSuffix = (String)idSuffix + "_" + suffix[0];
            }
            AllDisplayBehaviours.assignBlock(AllDisplayBehaviours.register(new ResourceLocation(registryName.m_135827_(), registryName.m_135815_() + (String)idSuffix), behaviour), registryName);
        };
    }

    public static <B extends BlockEntityType<?>> NonNullConsumer<? super B> assignDataBehaviourTE(DisplayBehaviour behaviour, String ... suffix) {
        return b -> {
            Object idSuffix;
            ResourceLocation registryName = RegisteredObjects.getKeyOrThrow(b);
            Object object = idSuffix = behaviour instanceof DisplaySource ? "_source" : "_target";
            if (suffix.length > 0) {
                idSuffix = (String)idSuffix + "_" + suffix[0];
            }
            AllDisplayBehaviours.assignTile(AllDisplayBehaviours.register(new ResourceLocation(registryName.m_135827_(), registryName.m_135815_() + (String)idSuffix), behaviour), registryName);
        };
    }

    @Nullable
    public static DisplaySource getSource(ResourceLocation resourceLocation) {
        DisplayBehaviour available = GATHERER_BEHAVIOURS.getOrDefault(resourceLocation, null);
        if (available instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)available;
            return source;
        }
        return null;
    }

    @Nullable
    public static DisplayTarget getTarget(ResourceLocation resourceLocation) {
        DisplayBehaviour available = GATHERER_BEHAVIOURS.getOrDefault(resourceLocation, null);
        if (available instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)available;
            return target;
        }
        return null;
    }

    public static List<DisplaySource> sourcesOf(Block block) {
        List<DisplaySource> sources = SOURCES_BY_BLOCK.get(block);
        if (sources == null) {
            return Collections.emptyList();
        }
        return sources;
    }

    public static List<DisplaySource> sourcesOf(BlockState state) {
        return AllDisplayBehaviours.sourcesOf(state.m_60734_());
    }

    public static List<DisplaySource> sourcesOf(BlockEntityType<?> tileEntityType) {
        List<DisplaySource> sources = SOURCES_BY_TILE.get(tileEntityType);
        if (sources == null) {
            return Collections.emptyList();
        }
        return sources;
    }

    public static List<DisplaySource> sourcesOf(BlockEntity tileEntity) {
        return AllDisplayBehaviours.sourcesOf(tileEntity.m_58903_());
    }

    @Nullable
    public static DisplayTarget targetOf(Block block) {
        return TARGETS_BY_BLOCK.get(block);
    }

    @Nullable
    public static DisplayTarget targetOf(BlockState state) {
        return AllDisplayBehaviours.targetOf(state.m_60734_());
    }

    @Nullable
    public static DisplayTarget targetOf(BlockEntityType<?> tileEntityType) {
        return TARGETS_BY_TILE.get(tileEntityType);
    }

    @Nullable
    public static DisplayTarget targetOf(BlockEntity tileEntity) {
        return AllDisplayBehaviours.targetOf(tileEntity.m_58903_());
    }

    public static List<DisplaySource> sourcesOf(LevelAccessor level, BlockPos pos) {
        List<Object> sourcesOfTE;
        BlockState blockState = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        List<DisplaySource> sourcesOfBlock = AllDisplayBehaviours.sourcesOf(blockState);
        List<Object> list = sourcesOfTE = blockEntity == null ? Collections.emptyList() : AllDisplayBehaviours.sourcesOf(blockEntity);
        if (sourcesOfTE.isEmpty()) {
            return sourcesOfBlock;
        }
        return sourcesOfTE;
    }

    @Nullable
    public static DisplayTarget targetOf(LevelAccessor level, BlockPos pos) {
        DisplayTarget targetOfTE;
        BlockState blockState = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        DisplayTarget targetOfBlock = AllDisplayBehaviours.targetOf(blockState);
        DisplayTarget displayTarget = targetOfTE = blockEntity == null ? null : AllDisplayBehaviours.targetOf(blockEntity);
        if (targetOfTE == null) {
            return targetOfBlock;
        }
        return targetOfTE;
    }

    public static void registerDefaults() {
        AllDisplayBehaviours.assignTile(AllDisplayBehaviours.register(Create.asResource("sign_display_target"), new SignDisplayTarget()), BlockEntityType.f_58924_);
        AllDisplayBehaviours.assignTile(AllDisplayBehaviours.register(Create.asResource("lectern_display_target"), new LecternDisplayTarget()), BlockEntityType.f_58908_);
        AllDisplayBehaviours.assignBlock(AllDisplayBehaviours.register(Create.asResource("death_count_display_source"), new DeathCounterDisplaySource()), Blocks.f_50724_);
        AllDisplayBehaviours.assignTile(AllDisplayBehaviours.register(Create.asResource("scoreboard_display_source"), new ScoreboardDisplaySource()), BlockEntityType.f_58938_);
        AllDisplayBehaviours.assignTile(AllDisplayBehaviours.register(Create.asResource("enchant_power_display_source"), new EnchantPowerDisplaySource()), BlockEntityType.f_58928_);
        AllDisplayBehaviours.assignBlock(AllDisplayBehaviours.register(Create.asResource("redstone_power_display_source"), new RedstonePowerDisplaySource()), Blocks.f_50716_);
    }
}

