/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.pulley;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.BlockMovementChecks;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.content.contraptions.components.structureMovement.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.LinearActuatorTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyContraption;
import com.simibubi.create.content.logistics.block.redstone.StockpileSwitchObservable;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PulleyTileEntity
extends LinearActuatorTileEntity
implements StockpileSwitchObservable {
    protected int initialOffset;
    private float prevAnimatedOffset;

    public PulleyTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82363_(0.0, (double)(-this.offset), 0.0);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.PULLEY_MAXED);
    }

    @Override
    public void tick() {
        float prevOffset = this.offset;
        super.tick();
        if (this.isVirtual()) {
            this.prevAnimatedOffset = this.offset;
        }
        this.invalidateRenderBoundingBox();
        if (prevOffset < 200.0f && this.offset >= 200.0f) {
            this.award(AllAdvancements.PULLEY_MAXED);
        }
    }

    @Override
    protected void assemble() throws AssemblyException {
        BlockPos ropePos;
        BlockState ropeState;
        int i;
        if (!(this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof PulleyBlock)) {
            return;
        }
        if (this.speed == 0.0f) {
            return;
        }
        int maxLength = (Integer)AllConfigs.SERVER.kinetics.maxRopeLength.get();
        for (i = 1; i <= maxLength && (AllBlocks.ROPE.has(ropeState = this.f_58857_.m_8055_(ropePos = this.f_58858_.m_6625_(i))) || AllBlocks.PULLEY_MAGNET.has(ropeState)); ++i) {
        }
        this.offset = i - 1;
        if (this.offset >= (float)this.getExtensionRange() && this.getSpeed() > 0.0f) {
            return;
        }
        if (this.offset <= 0.0f && this.getSpeed() < 0.0f) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.needsContraption = false;
            BlockPos anchor = this.f_58858_.m_6625_(Mth.m_14143_((float)(this.offset + 1.0f)));
            this.initialOffset = Mth.m_14143_((float)this.offset);
            PulleyContraption contraption = new PulleyContraption(this.initialOffset);
            boolean canAssembleStructure = contraption.assemble(this.f_58857_, anchor);
            if (canAssembleStructure) {
                Direction movementDirection;
                Direction direction = movementDirection = this.getSpeed() > 0.0f ? Direction.DOWN : Direction.UP;
                if (ContraptionCollider.isCollidingWithWorld(this.f_58857_, contraption, anchor.m_121945_(movementDirection), movementDirection)) {
                    canAssembleStructure = false;
                }
            }
            if (!canAssembleStructure && this.getSpeed() > 0.0f) {
                return;
            }
            for (i = (int)this.offset; i > 0; --i) {
                BlockPos offset = this.f_58858_.m_6625_(i);
                BlockState oldState = this.f_58857_.m_8055_(offset);
                if (oldState.m_60734_() instanceof SimpleWaterloggedBlock && oldState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)oldState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                    this.f_58857_.m_7731_(offset, Blocks.f_49990_.m_49966_(), 66);
                    continue;
                }
                this.f_58857_.m_7731_(offset, Blocks.f_50016_.m_49966_(), 66);
            }
            if (!contraption.getBlocks().isEmpty()) {
                contraption.removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
                this.movedContraption = ControlledContraptionEntity.create(this.f_58857_, this, contraption);
                this.movedContraption.m_6034_(anchor.m_123341_(), anchor.m_123342_(), anchor.m_123343_());
                this.f_58857_.m_7967_((Entity)this.movedContraption);
                this.forceMove = true;
                this.needsContraption = true;
                if (contraption.containsBlockBreakers()) {
                    this.award(AllAdvancements.CONTRAPTION_ACTORS);
                }
            }
        }
        this.clientOffsetDiff = 0.0f;
        this.running = true;
        this.sendData();
    }

    @Override
    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        this.offset = this.getGridOffset(this.offset);
        if (this.movedContraption != null) {
            this.resetContraptionToOffset();
        }
        if (!this.f_58857_.f_46443_) {
            if (!this.f_58859_) {
                int i;
                if (this.offset > 0.0f) {
                    BlockPos magnetPos = this.f_58858_.m_6625_((int)this.offset);
                    FluidState ifluidstate = this.f_58857_.m_6425_(magnetPos);
                    this.f_58857_.m_46961_(magnetPos, this.f_58857_.m_8055_(magnetPos).m_60812_((BlockGetter)this.f_58857_, magnetPos).m_83281_());
                    this.f_58857_.m_7731_(magnetPos, (BlockState)AllBlocks.PULLEY_MAGNET.getDefaultState().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_)), 66);
                }
                boolean[] waterlog = new boolean[(int)this.offset];
                for (i = 1; i <= (int)this.offset - 1; ++i) {
                    BlockPos ropePos = this.f_58858_.m_6625_(i);
                    FluidState ifluidstate = this.f_58857_.m_6425_(ropePos);
                    waterlog[i] = ifluidstate.m_76152_() == Fluids.f_76193_;
                    this.f_58857_.m_46961_(ropePos, this.f_58857_.m_8055_(ropePos).m_60812_((BlockGetter)this.f_58857_, ropePos).m_83281_());
                }
                for (i = 1; i <= (int)this.offset - 1; ++i) {
                    this.f_58857_.m_7731_(this.f_58858_.m_6625_(i), (BlockState)AllBlocks.ROPE.getDefaultState().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(waterlog[i])), 66);
                }
            }
            if (this.movedContraption != null) {
                this.movedContraption.disassemble();
            }
        }
        if (this.movedContraption != null) {
            this.movedContraption.m_146870_();
        }
        this.movedContraption = null;
        this.initialOffset = 0;
        this.running = false;
        this.sendData();
    }

    @Override
    protected Vec3 toPosition(float offset) {
        if (this.movedContraption.getContraption() instanceof PulleyContraption) {
            PulleyContraption contraption = (PulleyContraption)this.movedContraption.getContraption();
            return Vec3.m_82528_((Vec3i)contraption.anchor).m_82520_(0.0, (double)((float)contraption.initialOffset - offset), 0.0);
        }
        return Vec3.f_82478_;
    }

    @Override
    protected void visitNewPosition() {
        super.visitNewPosition();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.movedContraption != null) {
            return;
        }
        if (this.getSpeed() <= 0.0f) {
            return;
        }
        BlockPos posBelow = this.f_58858_.m_6625_((int)(this.offset + this.getMovementSpeed()) + 1);
        BlockState state = this.f_58857_.m_8055_(posBelow);
        if (!BlockMovementChecks.isMovementNecessary(state, this.f_58857_, posBelow)) {
            return;
        }
        if (BlockMovementChecks.isBrittle(state)) {
            return;
        }
        this.disassemble();
        this.assembleNextTick = true;
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.initialOffset = compound.m_128451_("InitialOffset");
        this.needsContraption = compound.m_128471_("NeedsContraption");
        super.read(compound, clientPacket);
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("InitialOffset", this.initialOffset);
        super.write(compound, clientPacket);
    }

    @Override
    protected int getExtensionRange() {
        return Math.max(0, Math.min((Integer)AllConfigs.SERVER.kinetics.maxRopeLength.get(), this.f_58858_.m_123342_() - 1 - this.f_58857_.m_141937_()));
    }

    @Override
    protected int getInitialOffset() {
        return this.initialOffset;
    }

    @Override
    protected Vec3 toMotionVector(float speed) {
        return new Vec3(0.0, (double)(-speed), 0.0);
    }

    @Override
    protected ValueBoxTransform getMovementModeSlot() {
        return new CenteredSideValueBoxTransform((state, d) -> d == Direction.UP);
    }

    @Override
    public float getInterpolatedOffset(float partialTicks) {
        if (this.isVirtual()) {
            return Mth.m_14179_((float)partialTicks, (float)this.prevAnimatedOffset, (float)this.offset);
        }
        boolean moving = this.running && (this.movedContraption == null || !this.movedContraption.isStalled());
        return super.getInterpolatedOffset(moving ? partialTicks : 0.5f);
    }

    public void animateOffset(float forcedOffset) {
        this.offset = forcedOffset;
    }

    @Override
    public float getPercent() {
        int distance = this.f_58858_.m_123342_() - this.f_58857_.m_141937_();
        if (distance <= 0) {
            return 100.0f;
        }
        return 100.0f * this.getInterpolatedOffset(0.5f) / (float)distance;
    }
}

