/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.bindings.event.ServerEvents;
import dev.latvian.mods.kubejs.item.ingredient.IngredientWithCustomPredicate;
import dev.latvian.mods.kubejs.platform.RecipePlatformHelper;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeResultCallback;
import dev.latvian.mods.kubejs.recipe.RecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.RecipeTypeRegistryEventJS;
import dev.latvian.mods.kubejs.recipe.RecipesEventJS;
import dev.latvian.mods.kubejs.recipe.RegisterRecipeTypesEvent;
import dev.latvian.mods.kubejs.recipe.ingredientaction.CustomIngredientAction;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.data.DataPackEventJS;
import dev.latvian.mods.kubejs.script.data.VirtualKubeJSDataPack;
import dev.latvian.mods.kubejs.server.KubeJSReloadListener;
import dev.latvian.mods.kubejs.server.KubeJSServerResourcePack;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;

public class ServerScriptManager {
    public static ServerScriptManager instance;
    private final ScriptManager scriptManager = new ScriptManager(ScriptType.SERVER, KubeJSPaths.SERVER_SCRIPTS, "example_server_script.js");

    public static ScriptManager getScriptManager() {
        return ServerScriptManager.instance.scriptManager;
    }

    public ServerScriptManager() {
        try {
            if (Files.notExists(KubeJSPaths.DATA, new LinkOption[0])) {
                Files.createDirectories(KubeJSPaths.DATA, new FileAttribute[0]);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("KubeJS failed to register it's script loader!", ex);
        }
    }

    public void updateResources(ReloadableServerResources serverResources) {
        KubeJSReloadListener.resources = serverResources;
        KubeJSReloadListener.recipeContext = RecipePlatformHelper.get().createRecipeContext(serverResources);
    }

    public void reloadScriptManager(ResourceManager resourceManager) {
        this.scriptManager.reload(resourceManager);
    }

    public MultiPackResourceManager wrapResourceManager(CloseableResourceManager original) {
        List list;
        VirtualKubeJSDataPack virtualDataPackLow = new VirtualKubeJSDataPack(false);
        VirtualKubeJSDataPack virtualDataPackHigh = new VirtualKubeJSDataPack(true);
        if (original instanceof MultiPackResourceManager) {
            MultiPackResourceManager mp = (MultiPackResourceManager)original;
            list = mp.f_203795_;
        } else {
            list = original.m_7536_().toList();
        }
        LinkedList list2 = new LinkedList(list);
        list2.addFirst(virtualDataPackLow);
        list2.addLast(new KubeJSServerResourcePack());
        list2.addLast(virtualDataPackHigh);
        MultiPackResourceManager wrappedResourceManager = new MultiPackResourceManager(PackType.SERVER_DATA, list2);
        this.reloadScriptManager((ResourceManager)wrappedResourceManager);
        ServerEvents.LOW_DATA.post(new DataPackEventJS(virtualDataPackLow, wrappedResourceManager));
        ServerEvents.HIGH_DATA.post(new DataPackEventJS(virtualDataPackHigh, wrappedResourceManager));
        ConsoleJS.SERVER.info("Scripts loaded");
        HashMap<ResourceLocation, RecipeTypeJS> typeMap = new HashMap<ResourceLocation, RecipeTypeJS>();
        RegisterRecipeTypesEvent modEvent = new RegisterRecipeTypesEvent(typeMap);
        KubeJSPlugins.forEachPlugin(plugin -> plugin.registerRecipeTypes(modEvent));
        ServerEvents.RECIPE_TYPE_REGISTRY.post(new RecipeTypeRegistryEventJS(typeMap));
        if (Platform.isForge()) {
            RecipesEventJS.customIngredientMap = new HashMap<UUID, IngredientWithCustomPredicate>();
        }
        RecipesEventJS.modifyResultCallbackMap = new HashMap<UUID, ModifyRecipeResultCallback>();
        CustomIngredientAction.MAP.clear();
        RecipesEventJS.instance = new RecipesEventJS(typeMap);
        return wrappedResourceManager;
    }
}

