/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script;

import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.level.LevelReader;
import org.slf4j.LoggerFactory;

public enum ScriptType {
    STARTUP("startup", "KubeJS Startup", KubeJS::getStartupScriptManager),
    SERVER("server", "KubeJS Server", ServerScriptManager::getScriptManager),
    CLIENT("client", "KubeJS Client", KubeJS::getClientScriptManager);

    public static final ScriptType[] VALUES = ScriptType.values();
    public final String name;
    public final transient List<String> errors;
    public final transient List<String> warnings;
    public final ConsoleJS console;
    public final transient Supplier<ScriptManager> manager;
    public final transient ExecutorService executor;

    public static ScriptType of(LevelReader level) {
        return level.m_5776_() ? CLIENT : SERVER;
    }

    public static ScriptType getCurrent(Context cx) {
        return (ScriptType)((Object)cx.getProperty("Type"));
    }

    private ScriptType(String n2, String cname, Supplier<ScriptManager> m) {
        this.name = n2;
        this.errors = new ArrayList<String>();
        this.warnings = new ArrayList<String>();
        this.console = new ConsoleJS(this, LoggerFactory.getLogger((String)cname));
        this.manager = m;
        this.executor = Executors.newSingleThreadExecutor();
    }

    public Path getLogFile() {
        Path dir = Platform.getGameFolder().resolve("logs/kubejs");
        Path file = dir.resolve(this.name + ".txt");
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            if (!Files.exists(file, new LinkOption[0])) {
                Files.createFile(file, new FileAttribute[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return file;
    }

    public boolean isClient() {
        return this == CLIENT;
    }

    public boolean isServer() {
        return this == SERVER;
    }

    public boolean isStartup() {
        return this == STARTUP;
    }

    @HideFromJS
    public void unload() {
        this.errors.clear();
        this.warnings.clear();
        this.console.resetFile();
        for (EventGroup group : EventGroup.getGroups().values()) {
            for (EventHandler handler : group.getHandlers().values()) {
                handler.clear(this);
            }
        }
    }

    public Component errorsComponent(String command) {
        return Component.m_237113_((String)("KubeJS errors found [" + this.errors.size() + "]! Run '" + command + "' for more info")).kjs$click(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command)).kjs$hover((Component)Component.m_237113_((String)"Click to show")).m_130940_(ChatFormatting.DARK_RED);
    }

    public Component warningsComponent(String command) {
        return Component.m_237113_((String)("KubeJS warnings found [" + this.warnings.size() + "]! Run '" + command + "' for more info")).kjs$click(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command)).kjs$hover((Component)Component.m_237113_((String)"Click to show")).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16753920)));
    }
}

