/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.script.CustomJavaToJsWrappersEvent;
import dev.latvian.mods.kubejs.script.RegistryTypeWrapperFactory;
import dev.latvian.mods.kubejs.script.ScriptFile;
import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.script.ScriptPackInfo;
import dev.latvian.mods.kubejs.script.ScriptSource;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ClassFilter;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.ClassShutter;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaClass;
import dev.latvian.mods.rhino.NativeObject;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.mod.util.MinecraftRemapper;
import dev.latvian.mods.rhino.mod.util.RemappingHelper;
import dev.latvian.mods.rhino.util.Remapper;
import dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class ScriptManager
implements ClassShutter {
    private static final ThreadLocal<Context> CURRENT_CONTEXT = new ThreadLocal();
    public final ScriptType scriptType;
    public final Path directory;
    private final String exampleScript;
    public final Map<String, ScriptPack> packs;
    private final ClassFilter classFilter;
    public boolean firstLoad;
    public Context context;
    public Scriptable topLevelScope;
    private Map<String, Optional<NativeJavaClass>> javaClassCache;
    public boolean canListenEvents;

    @Nullable
    public static Context getCurrentContext() {
        return CURRENT_CONTEXT.get();
    }

    public ScriptManager(ScriptType t, Path p, String e) {
        this.scriptType = t;
        this.directory = p;
        this.exampleScript = e;
        this.packs = new LinkedHashMap<String, ScriptPack>();
        this.firstLoad = true;
        this.classFilter = KubeJSPlugins.createClassFilter(this.scriptType);
    }

    public void unload() {
        this.packs.clear();
        this.scriptType.unload();
        this.javaClassCache = null;
    }

    public void reload(@Nullable ResourceManager resourceManager) {
        KubeJSPlugins.forEachPlugin(KubeJSPlugin::clearCaches);
        this.unload();
        this.loadFromDirectory();
        if (resourceManager != null) {
            this.loadFromResources(resourceManager);
        }
        this.load();
    }

    private void loadFromResources(ResourceManager resourceManager) {
        HashMap<String, List> packMap = new HashMap<String, List>();
        for (ResourceLocation resourceLocation : resourceManager.m_214159_("kubejs", s -> s.m_135815_().endsWith(".js")).keySet()) {
            packMap.computeIfAbsent(resourceLocation.m_135827_(), s -> new ArrayList()).add(resourceLocation);
        }
        for (Map.Entry entry : packMap.entrySet()) {
            ScriptPack pack = new ScriptPack(this, new ScriptPackInfo((String)entry.getKey(), "kubejs/"));
            for (ResourceLocation id : (List)entry.getValue()) {
                pack.info.scripts.add(new ScriptFileInfo(pack.info, id.m_135815_().substring(7)));
            }
            for (ScriptFileInfo fileInfo : pack.info.scripts) {
                ScriptSource.FromResource scriptSource = info -> resourceManager.m_215593_(info.id);
                Throwable error = fileInfo.preload(scriptSource);
                if (fileInfo.skipLoading()) continue;
                if (error == null) {
                    pack.scripts.add(new ScriptFile(pack, fileInfo, scriptSource));
                    continue;
                }
                this.scriptType.console.error("Failed to pre-load script file " + fileInfo.location + ": " + error);
            }
            pack.scripts.sort(null);
            this.packs.put(pack.info.namespace, pack);
        }
    }

    public void loadFromDirectory() {
        if (Files.notExists(this.directory, new LinkOption[0])) {
            UtilsJS.tryIO(() -> Files.createDirectories(this.directory, new FileAttribute[0]));
            try (InputStream in = Files.newInputStream((Path)KubeJS.thisMod.findResource(new String[]{"data", "kubejs", this.exampleScript}).get(), new OpenOption[0]);
                 OutputStream out = Files.newOutputStream(this.directory.resolve("script.js"), new OpenOption[0]);){
                in.transferTo(out);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ScriptPack pack = new ScriptPack(this, new ScriptPackInfo(this.directory.getFileName().toString(), ""));
        KubeJS.loadScripts(pack, this.directory, "");
        for (ScriptFileInfo fileInfo : pack.info.scripts) {
            ScriptSource.FromPath scriptSource = info -> this.directory.resolve(info.file);
            Throwable error = fileInfo.preload(scriptSource);
            if (fileInfo.skipLoading()) continue;
            if (error == null) {
                pack.scripts.add(new ScriptFile(pack, fileInfo, scriptSource));
                continue;
            }
            KubeJS.LOGGER.error("Failed to pre-load script file " + fileInfo.location + ": " + error);
        }
        pack.scripts.sort(null);
        this.packs.put(pack.info.namespace, pack);
    }

    public boolean isClassAllowed(String name) {
        return this.classFilter.isAllowed(name);
    }

    public void load() {
        MinecraftRemapper remapper = RemappingHelper.getMinecraftRemapper();
        long startAll = System.currentTimeMillis();
        this.context = Context.enter();
        this.topLevelScope = this.context.initStandardObjects();
        CURRENT_CONTEXT.set(this.context);
        this.canListenEvents = true;
        int i = 0;
        int t = 0;
        this.context.setProperty("Type", (Object)this.scriptType);
        this.context.setProperty("Console", (Object)this.scriptType.console);
        this.context.setClassShutter((ClassShutter)this);
        this.context.setRemapper((Remapper)remapper);
        TypeWrappers typeWrappers = this.context.getTypeWrappers();
        BindingsEvent bindingsEvent = new BindingsEvent(this, this.topLevelScope);
        CustomJavaToJsWrappersEvent customJavaToJsWrappersEvent = new CustomJavaToJsWrappersEvent(this);
        for (KubeJSPlugin kubeJSPlugin : KubeJSPlugins.getAll()) {
            kubeJSPlugin.registerTypeWrappers(this.scriptType, typeWrappers);
            kubeJSPlugin.registerBindings(bindingsEvent);
            kubeJSPlugin.registerCustomJavaToJsWrappers(customJavaToJsWrappersEvent);
        }
        for (RegistryTypeWrapperFactory registryTypeWrapperFactory : RegistryTypeWrapperFactory.getAll()) {
            try {
                typeWrappers.register(registryTypeWrapperFactory.type, (TypeWrapperFactory)UtilsJS.cast(registryTypeWrapperFactory));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        for (ScriptPack scriptPack : this.packs.values()) {
            try {
                scriptPack.scope = new NativeObject(this.context);
                scriptPack.scope.setParentScope(this.topLevelScope);
                for (ScriptFile file : scriptPack.scripts) {
                    ++t;
                    long start = System.currentTimeMillis();
                    try {
                        file.load();
                        ++i;
                        this.scriptType.console.info("Loaded script " + file.info.location + " in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " s");
                    }
                    catch (Throwable ex) {
                        this.scriptType.console.handleError(ex, null, "Error loading KubeJS script: " + file.info.location + "'");
                    }
                }
            }
            catch (Throwable ex) {
                this.scriptType.console.error("Failed to read script pack " + scriptPack.info.namespace + ": ", ex);
            }
        }
        this.scriptType.console.info("Loaded " + i + "/" + t + " KubeJS " + this.scriptType.name + " scripts in " + (double)(System.currentTimeMillis() - startAll) / 1000.0 + " s");
        this.firstLoad = false;
        this.canListenEvents = false;
    }

    public NativeJavaClass loadJavaClass(String name0, boolean warn) {
        Optional<NativeJavaClass> ch;
        if (name0 == null || name0.equals("null") || name0.isEmpty()) {
            throw Context.reportRuntimeError((String)"Class name can't be empty!", (Context)this.context);
        }
        String name = RemappingHelper.getMinecraftRemapper().getUnmappedClass(name0);
        if (name.isEmpty()) {
            name = name0;
        }
        if (this.javaClassCache == null) {
            this.javaClassCache = new HashMap<String, Optional<NativeJavaClass>>();
        }
        if ((ch = this.javaClassCache.get(name)) == null) {
            this.javaClassCache.put(name, Optional.empty());
            try {
                if (!this.isClassAllowed(name)) {
                    throw Context.reportRuntimeError((String)"Failed to load Java class '%s': Class is not allowed by class filter!".formatted(name), (Context)this.context);
                }
                Class<?> c = Class.forName(name);
                NativeJavaClass njc = new NativeJavaClass(this.context, this.topLevelScope, c);
                this.javaClassCache.put(name, Optional.of(njc));
                this.scriptType.console.info("Loaded Java class '%s'".formatted(name0));
                return njc;
            }
            catch (ClassNotFoundException cnf) {
                throw Context.reportRuntimeError((String)"Failed to load Java class '%s': Class could not be found!\n%s".formatted(name, cnf.getMessage()), (Context)this.context);
            }
        }
        if (ch.isPresent()) {
            return ch.get();
        }
        throw Context.reportRuntimeError((String)"Failed to load Java class '%s'!".formatted(name), (Context)this.context);
    }

    public boolean visibleToScripts(String fullClassName, int type) {
        return type != 2 || this.isClassAllowed(fullClassName);
    }
}

