/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.filter;

import dev.latvian.mods.kubejs.core.RecipeKJS;
import dev.latvian.mods.kubejs.recipe.IngredientMatch;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.filter.AndFilter;
import dev.latvian.mods.kubejs.recipe.filter.GroupFilter;
import dev.latvian.mods.kubejs.recipe.filter.IDFilter;
import dev.latvian.mods.kubejs.recipe.filter.InputFilter;
import dev.latvian.mods.kubejs.recipe.filter.ModFilter;
import dev.latvian.mods.kubejs.recipe.filter.NotFilter;
import dev.latvian.mods.kubejs.recipe.filter.OrFilter;
import dev.latvian.mods.kubejs.recipe.filter.OutputFilter;
import dev.latvian.mods.kubejs.recipe.filter.RegexIDFilter;
import dev.latvian.mods.kubejs.recipe.filter.TypeFilter;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface RecipeFilter
extends Predicate<RecipeKJS> {
    public static final RecipeFilter ALWAYS_TRUE = r -> true;
    public static final RecipeFilter ALWAYS_FALSE = r -> false;

    @Override
    public boolean test(RecipeKJS var1);

    public static RecipeFilter of(Context cx, @Nullable Object o) {
        String s;
        if (o == null || o == ALWAYS_TRUE) {
            return ALWAYS_TRUE;
        }
        if (o == ALWAYS_FALSE) {
            return ALWAYS_FALSE;
        }
        if (o instanceof CharSequence && (s = o.toString()).equals("*")) {
            return ALWAYS_TRUE;
        }
        List<?> list = ListJS.orSelf(o);
        if (list.isEmpty()) {
            return ALWAYS_TRUE;
        }
        if (list.size() > 1) {
            OrFilter predicate = new OrFilter();
            for (Object o1 : list) {
                RecipeFilter p = RecipeFilter.of(cx, o1);
                if (p == ALWAYS_TRUE) {
                    return ALWAYS_TRUE;
                }
                if (p == ALWAYS_FALSE) continue;
                predicate.list.add(p);
            }
            return predicate.list.isEmpty() ? ALWAYS_FALSE : (predicate.list.size() == 1 ? predicate.list.get(0) : predicate);
        }
        Map<?, ?> map = MapJS.of(list.get(0));
        if (map == null || map.isEmpty()) {
            return ALWAYS_TRUE;
        }
        AndFilter predicate = new AndFilter();
        if (map.get("or") != null) {
            predicate.list.add(RecipeFilter.of(cx, map.get("or")));
        }
        if (map.get("not") != null) {
            predicate.list.add(new NotFilter(RecipeFilter.of(cx, map.get("not"))));
        }
        try {
            Object output;
            Object input;
            Object mod;
            Object group;
            Object type;
            Object id = map.get("id");
            if (id != null) {
                Pattern pattern = UtilsJS.parseRegex(id);
                predicate.list.add(pattern == null ? new IDFilter(UtilsJS.getMCID(cx, id)) : new RegexIDFilter(pattern));
            }
            if ((type = map.get("type")) != null) {
                predicate.list.add(new TypeFilter(UtilsJS.getMCID(cx, type)));
            }
            if ((group = map.get("group")) != null) {
                predicate.list.add(new GroupFilter(group.toString()));
            }
            if ((mod = map.get("mod")) != null) {
                predicate.list.add(new ModFilter(mod.toString()));
            }
            if ((input = map.get("input")) != null) {
                predicate.list.add(new InputFilter(IngredientMatch.of(input)));
            }
            if ((output = map.get("output")) != null) {
                predicate.list.add(new OutputFilter(IngredientMatch.of(output)));
            }
            return predicate.list.isEmpty() ? ALWAYS_TRUE : (predicate.list.size() == 1 ? predicate.list.get(0) : predicate);
        }
        catch (RecipeExceptionJS ex) {
            if (ex.error) {
                ConsoleJS.getCurrent(cx).error(ex.getMessage());
            } else {
                ConsoleJS.getCurrent(cx).warn(ex.getMessage());
            }
            return ALWAYS_FALSE;
        }
    }
}

