/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.ingredient;

import com.google.common.collect.Iterables;
import dev.latvian.mods.kubejs.KubeJS;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.mutable.MutableObject;

public interface TagContext {
    public static final TagContext EMPTY = new TagContext(){

        @Override
        public boolean isEmpty(TagKey<Item> tag) {
            return true;
        }

        @Override
        public boolean areTagsBound() {
            return false;
        }

        @Override
        public Iterable<Holder<Item>> getTag(TagKey<Item> tag) {
            KubeJS.LOGGER.warn("Tried to get tag {} from an empty tag context!", (Object)tag.f_203868_());
            return List.of();
        }
    };
    public static final TagContext REGISTRY = new TagContext(){

        @Override
        public boolean isEmpty(TagKey<Item> tag) {
            return Registry.f_122827_.m_203431_(tag).isEmpty();
        }

        @Override
        public boolean areTagsBound() {
            return true;
        }

        @Override
        public Iterable<Holder<Item>> getTag(TagKey<Item> tag) {
            return Registry.f_122827_.m_206058_(tag);
        }
    };
    public static final MutableObject<TagContext> INSTANCE = new MutableObject((Object)EMPTY);

    public static TagContext usingResult(final TagManager.LoadResult<Item> manager) {
        return new TagContext(){

            @Override
            public boolean isEmpty(TagKey<Item> tag) {
                return Iterables.isEmpty(this.getTag(tag));
            }

            @Override
            public boolean areTagsBound() {
                return false;
            }

            @Override
            public Iterable<Holder<Item>> getTag(TagKey<Item> tag) {
                return manager.f_203929_().getOrDefault(tag.f_203868_(), Set.of());
            }
        };
    }

    public boolean isEmpty(TagKey<Item> var1);

    public boolean areTagsBound();

    public Iterable<Holder<Item>> getTag(TagKey<Item> var1);

    public record Result(TagContext context, Collection<Holder<Item>> holders) {
    }
}

