/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.latvian.mods.kubejs.bindings.event.ItemEvents;
import dev.latvian.mods.kubejs.bindings.event.PlayerEvents;
import dev.latvian.mods.kubejs.item.ItemClickedEventJS;
import dev.latvian.mods.kubejs.item.ItemCraftedEventJS;
import dev.latvian.mods.kubejs.item.ItemDroppedEventJS;
import dev.latvian.mods.kubejs.item.ItemEntityInteractedEventJS;
import dev.latvian.mods.kubejs.item.ItemPickedUpEventJS;
import dev.latvian.mods.kubejs.item.ItemSmeltedEventJS;
import dev.latvian.mods.kubejs.player.InventoryChangedEventJS;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class KubeJSItemEventHandler {
    public static void init() {
        InteractionEvent.RIGHT_CLICK_ITEM.register(KubeJSItemEventHandler::rightClick);
        PlayerEvent.PICKUP_ITEM_PRE.register(KubeJSItemEventHandler::canPickUp);
        PlayerEvent.PICKUP_ITEM_POST.register(KubeJSItemEventHandler::pickup);
        PlayerEvent.DROP_ITEM.register(KubeJSItemEventHandler::drop);
        InteractionEvent.INTERACT_ENTITY.register(KubeJSItemEventHandler::entityInteract);
        PlayerEvent.CRAFT_ITEM.register(KubeJSItemEventHandler::crafted);
        PlayerEvent.SMELT_ITEM.register(KubeJSItemEventHandler::smelted);
    }

    private static CompoundEventResult<ItemStack> rightClick(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)player;
            if (!player.m_36335_().m_41519_(player.m_21120_(hand).m_41720_()) && ItemEvents.RIGHT_CLICKED.post(p.m_21120_(hand).m_41720_(), new ItemClickedEventJS((Player)p, hand))) {
                return CompoundEventResult.interruptFalse((Object)player.m_21120_(hand));
            }
        }
        return CompoundEventResult.pass();
    }

    private static EventResult canPickUp(Player player, ItemEntity entity, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)player;
            if (entity != null && ItemEvents.CAN_PICK_UP.post(stack.m_41720_(), new ItemPickedUpEventJS(p, entity, stack))) {
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    private static void pickup(Player player, ItemEntity entity, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)player;
            if (entity != null) {
                ItemEvents.PICKED_UP.post(stack.m_41720_(), new ItemPickedUpEventJS(p, entity, stack));
            }
        }
    }

    private static EventResult drop(Player player, ItemEntity entity) {
        if (player instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)player;
            if (entity != null && ItemEvents.DROPPED.post(entity.m_32055_().m_41720_(), new ItemDroppedEventJS(p, entity))) {
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    private static EventResult entityInteract(Player player, Entity entity, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)player;
            if (entity != null && ItemEvents.ENTITY_INTERACTED.post(p.m_21120_(hand).m_41720_(), new ItemEntityInteractedEventJS(p, entity, hand))) {
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    private static void crafted(Player player, ItemStack stack, Container grid) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!stack.m_41619_()) {
                ItemEvents.CRAFTED.post(stack.m_41720_(), new ItemCraftedEventJS(serverPlayer, stack, grid));
                PlayerEvents.INVENTORY_CHANGED.post(stack.m_41720_(), new InventoryChangedEventJS(serverPlayer, stack, -1));
            }
        }
    }

    private static void smelted(Player player, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!stack.m_41619_()) {
                ItemEvents.SMELTED.post(stack.m_41720_(), new ItemSmeltedEventJS(serverPlayer, stack));
                PlayerEvents.INVENTORY_CHANGED.post(stack.m_41720_(), new InventoryChangedEventJS(serverPlayer, stack, -1));
            }
        }
    }
}

