/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.latvian.mods.kubejs.BuilderBase;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.RegistryObjectBuilderTypes;
import dev.latvian.mods.kubejs.bindings.ItemWrapper;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.generator.DataJsonGenerator;
import dev.latvian.mods.kubejs.item.FoodBuilder;
import dev.latvian.mods.kubejs.item.KubeJSItemProperties;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.mod.util.color.Color;
import dev.latvian.mods.rhino.mod.wrapper.ColorWrapper;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ItemBuilder
extends BuilderBase<Item> {
    public static final Map<String, Tier> TOOL_TIERS = new HashMap<String, Tier>();
    public static final Map<String, ArmorMaterial> ARMOR_TIERS = new HashMap<String, ArmorMaterial>();
    public transient int maxStackSize = 64;
    public transient int maxDamage = 0;
    public transient int burnTime = 0;
    private ResourceLocation containerItem = null;
    public transient Function<ItemStack, Collection<ItemStack>> subtypes = null;
    public transient Rarity rarity = Rarity.COMMON;
    public transient boolean fireResistant = false;
    public transient boolean glow = false;
    public final transient List<Component> tooltip = new ArrayList<Component>();
    @Nullable
    public transient CreativeModeTab group = KubeJS.tab;
    @Nullable
    public transient ItemColorJS colorCallback;
    public transient FoodBuilder foodBuilder = null;
    public transient Function<ItemStack, Color> barColor;
    public transient ToIntFunction<ItemStack> barWidth;
    public transient NameCallback nameGetter;
    public transient Multimap<ResourceLocation, AttributeModifier> attributes;
    public transient UseAnim anim = null;
    public transient ToIntFunction<ItemStack> useDuration = null;
    public transient UseCallback use = null;
    public transient FinishUsingCallback finishUsing = null;
    public transient ReleaseUsingCallback releaseUsing = null;
    public String texture;
    public String parentModel = "";
    public JsonObject textureJson = new JsonObject();
    public JsonObject modelJson = null;

    public static ArmorMaterial ofArmorMaterial(Object o) {
        String asString = String.valueOf(o);
        ArmorMaterial armorMaterial = ARMOR_TIERS.get(asString);
        if (armorMaterial != null) {
            return armorMaterial;
        }
        String withKube = KubeJS.appendModId(asString);
        return ARMOR_TIERS.getOrDefault(withKube, (ArmorMaterial)ArmorMaterials.IRON);
    }

    public ItemBuilder(ResourceLocation i) {
        super(i);
        this.attributes = ArrayListMultimap.create();
    }

    @Override
    public final RegistryObjectBuilderTypes<Item> getRegistryType() {
        return RegistryObjectBuilderTypes.ITEM;
    }

    @Override
    public Item transformObject(Item obj) {
        obj.kjs$setItemBuilder(this);
        return obj;
    }

    @Override
    public void generateDataJsons(DataJsonGenerator generator) {
    }

    @Override
    public void generateAssetJsons(AssetJsonGenerator generator) {
        if (this.modelJson != null) {
            generator.json(AssetJsonGenerator.asItemModelLocation(this.id), (JsonElement)this.modelJson);
            return;
        }
        generator.itemModel(this.id, m -> {
            if (!this.parentModel.isEmpty()) {
                m.parent(this.parentModel);
            } else {
                m.parent("minecraft:item/generated");
            }
            if (this.textureJson.size() == 0) {
                this.texture(this.newID("item/", "").toString());
            }
            m.textures(this.textureJson);
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientRegistry(Supplier<Minecraft> minecraft) {
        if (this.colorCallback != null) {
            ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> this.colorCallback.getColor(stack, tintIndex).getArgbJS(), (Supplier[])new Supplier[]{this});
        }
    }

    public ItemBuilder maxStackSize(int v) {
        this.maxStackSize = v;
        return this;
    }

    public ItemBuilder unstackable() {
        return this.maxStackSize(1);
    }

    public ItemBuilder maxDamage(int v) {
        this.maxDamage = v;
        return this;
    }

    public ItemBuilder burnTime(int v) {
        this.burnTime = v;
        return this;
    }

    public ItemBuilder containerItem(ResourceLocation id) {
        this.containerItem = id;
        return this;
    }

    public ItemBuilder subtypes(Function<ItemStack, Collection<ItemStack>> fn) {
        this.subtypes = fn;
        return this;
    }

    public ItemBuilder rarity(Rarity v) {
        this.rarity = v;
        return this;
    }

    public ItemBuilder glow(boolean v) {
        this.glow = v;
        return this;
    }

    public ItemBuilder tooltip(Component text) {
        this.tooltip.add(text);
        return this;
    }

    public ItemBuilder group(@Nullable String g) {
        if (g == null) {
            this.group = null;
            return this;
        }
        for (CreativeModeTab ig : CreativeModeTab.f_40748_) {
            if (!ig.m_40783_().equals(g)) continue;
            this.group = ig;
            return this;
        }
        return this;
    }

    public ItemBuilder color(int index, Color c) {
        ItemColorJS itemColorJS = this.colorCallback;
        if (!(itemColorJS instanceof IndexedItemColor)) {
            if (this.colorCallback != null) {
                ConsoleJS.STARTUP.warnf("Overwriting existing dynamic item color for {} with an indexed color", this.id);
            }
            this.color((ItemColorJS)Util.m_137469_((Object)new IndexedItemColor(), col -> col.add(index, c)));
        } else {
            IndexedItemColor indexed = (IndexedItemColor)itemColorJS;
            indexed.add(index, c);
        }
        return this;
    }

    public ItemBuilder color(ItemColorJS callback) {
        this.colorCallback = callback;
        return this;
    }

    public ItemBuilder texture(String tex) {
        this.textureJson.addProperty("layer0", tex);
        return this;
    }

    public ItemBuilder texture(String key, String tex) {
        this.textureJson.addProperty(key, tex);
        return this;
    }

    public ItemBuilder textureJson(JsonObject json) {
        this.textureJson = json;
        return this;
    }

    public ItemBuilder modelJson(JsonObject json) {
        this.modelJson = json;
        return this;
    }

    public ItemBuilder parentModel(String m) {
        this.parentModel = m;
        return this;
    }

    public ItemBuilder barColor(Function<ItemStack, Color> barColor) {
        this.barColor = barColor;
        return this;
    }

    public ItemBuilder barWidth(ToIntFunction<ItemStack> barWidth) {
        this.barWidth = barWidth;
        return this;
    }

    public ItemBuilder name(NameCallback name) {
        this.nameGetter = name;
        return this;
    }

    public ItemBuilder food(Consumer<FoodBuilder> b) {
        this.foodBuilder = new FoodBuilder();
        b.accept(this.foodBuilder);
        return this;
    }

    public ItemBuilder fireResistant(boolean isFireResistant) {
        this.fireResistant = isFireResistant;
        return this;
    }

    public ItemBuilder fireResistant() {
        return this.fireResistant(true);
    }

    public Item.Properties createItemProperties() {
        Item item;
        KubeJSItemProperties properties = new KubeJSItemProperties(this);
        if (this.group != null) {
            properties.m_41491_(this.group);
        }
        if (this.maxDamage > 0) {
            properties.m_41503_(this.maxDamage);
        } else {
            properties.m_41487_(this.maxStackSize);
        }
        properties.m_41497_(this.rarity);
        Item item2 = item = this.containerItem == null ? Items.f_41852_ : ItemWrapper.getItem(this.containerItem);
        if (item != Items.f_41852_) {
            properties.m_41495_(item);
        }
        if (this.foodBuilder != null) {
            properties.m_41489_(this.foodBuilder.build());
        }
        if (this.fireResistant) {
            properties.m_41486_();
        }
        return properties;
    }

    public ItemBuilder modifyAttribute(ResourceLocation attribute, String identifier, double d, AttributeModifier.Operation operation) {
        this.attributes.put((Object)attribute, (Object)new AttributeModifier(new UUID(identifier.hashCode(), identifier.hashCode()), identifier, d, operation));
        return this;
    }

    public ItemBuilder useAnimation(UseAnim animation) {
        this.anim = animation;
        return this;
    }

    public ItemBuilder useDuration(ToIntFunction<ItemStack> useDuration) {
        this.useDuration = useDuration;
        return this;
    }

    public ItemBuilder use(UseCallback use) {
        this.use = use;
        return this;
    }

    public ItemBuilder finishUsing(FinishUsingCallback finishUsing) {
        this.finishUsing = finishUsing;
        return this;
    }

    public ItemBuilder releaseUsing(ReleaseUsingCallback releaseUsing) {
        this.releaseUsing = releaseUsing;
        return this;
    }

    static {
        for (Tiers tiers : Tiers.values()) {
            TOOL_TIERS.put(tiers.toString().toLowerCase(), (Tier)tiers);
        }
        for (Tiers tiers : ArmorMaterials.values()) {
            ARMOR_TIERS.put(tiers.toString().toLowerCase(), (ArmorMaterial)tiers);
        }
    }

    @FunctionalInterface
    public static interface UseCallback {
        public boolean use(Level var1, Player var2, InteractionHand var3);
    }

    @FunctionalInterface
    public static interface FinishUsingCallback {
        public ItemStack finishUsingItem(ItemStack var1, Level var2, LivingEntity var3);
    }

    @FunctionalInterface
    public static interface ReleaseUsingCallback {
        public void releaseUsing(ItemStack var1, Level var2, LivingEntity var3, int var4);
    }

    @FunctionalInterface
    public static interface ItemColorJS {
        public Color getColor(ItemStack var1, int var2);
    }

    public static class IndexedItemColor
    implements ItemColorJS {
        Int2IntOpenHashMap colors = new Int2IntOpenHashMap();

        public IndexedItemColor() {
            this.colors.defaultReturnValue(-1);
        }

        @Override
        public Color getColor(ItemStack stack, int tintIndex) {
            return ColorWrapper.of((Object)this.colors.get(tintIndex));
        }

        public void add(int tintIndex, Color color) {
            this.colors.put(tintIndex, color.getRgbJS());
        }
    }

    @FunctionalInterface
    public static interface NameCallback {
        public Component apply(ItemStack var1);
    }
}

