/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.event;

import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.IEventHandler;
import dev.latvian.mods.kubejs.script.ScriptType;
import org.jetbrains.annotations.Nullable;

class EventHandlerContainer {
    private final IEventHandler handler;
    private EventHandlerContainer child;

    public static boolean isEmpty(@Nullable EventHandlerContainer[] array) {
        if (array == null) {
            return true;
        }
        for (EventHandlerContainer c : array) {
            if (c == null) continue;
            return false;
        }
        return true;
    }

    public EventHandlerContainer(IEventHandler handler) {
        this.handler = handler;
    }

    public boolean handle(ScriptType scriptType, EventHandler eventHandler, EventJS event, boolean cancelable) {
        EventHandlerContainer itr = this;
        do {
            try {
                itr.handler.onEvent(event);
            }
            catch (Throwable ex) {
                scriptType.console.handleError(ex, null, "Error occurred while handling event '" + eventHandler + "'");
            }
            if (!cancelable || !event.isCanceled()) continue;
            return true;
        } while ((itr = itr.child) != null);
        return false;
    }

    public void add(IEventHandler handler) {
        EventHandlerContainer itr = this;
        while (itr.child != null) {
            itr = itr.child;
        }
        itr.child = new EventHandlerContainer(handler);
    }
}

