/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.command;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.bindings.event.ServerEvents;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.net.PaintMessage;
import dev.latvian.mods.kubejs.platform.IngredientPlatformHelper;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.data.VirtualKubeJSDataPack;
import dev.latvian.mods.kubejs.server.CustomCommandEventJS;
import dev.latvian.mods.kubejs.server.DataExport;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.ReloadCommand;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.WorldData;

public class KubeJSCommands {
    public static final DynamicCommandExceptionType NO_REGISTRY = new DynamicCommandExceptionType(id -> Component.m_237113_((String)("No builtin or static registry found for " + id)));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"kubejs").then(Commands.m_82127_((String)"custom_command").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).executes(context -> KubeJSCommands.customCommand((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"id")))))).then(Commands.m_82127_((String)"hand").executes(context -> KubeJSCommands.hand(((CommandSourceStack)context.getSource()).m_81375_(), InteractionHand.MAIN_HAND)))).then(Commands.m_82127_((String)"offhand").executes(context -> KubeJSCommands.hand(((CommandSourceStack)context.getSource()).m_81375_(), InteractionHand.OFF_HAND)))).then(Commands.m_82127_((String)"inventory").executes(context -> KubeJSCommands.inventory(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82127_((String)"hotbar").executes(context -> KubeJSCommands.hotbar(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82127_((String)"errors").executes(context -> KubeJSCommands.errors((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"warnings").executes(context -> KubeJSCommands.warnings((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"startup_scripts").requires(source -> source.m_81377_().m_129792_() || source.m_6761_(2))).executes(context -> KubeJSCommands.reloadStartup((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"server_scripts").requires(source -> source.m_81377_().m_129792_() || source.m_6761_(2))).executes(context -> KubeJSCommands.reloadServer((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"client_scripts").requires(source -> true)).executes(context -> KubeJSCommands.reloadClient((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"textures").requires(source -> true)).executes(context -> KubeJSCommands.reloadTextures((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"lang").requires(source -> true)).executes(context -> KubeJSCommands.reloadLang((CommandSourceStack)context.getSource()))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"export").requires(source -> source.m_81377_().m_129792_() || source.m_6761_(2))).executes(context -> KubeJSCommands.export((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"export_virtual_data").requires(source -> source.m_81377_().m_129792_() || source.m_6761_(2))).executes(context -> KubeJSCommands.exportVirtualData((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"list_tag").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"registry", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82981_(((CommandSourceStack)ctx.getSource()).m_5894_().m_206193_().map(entry -> entry.f_206233_().m_135782_().toString()), (SuggestionsBuilder)builder)).executes(ctx -> KubeJSCommands.listTagsFor((CommandSourceStack)ctx.getSource(), KubeJSCommands.registry((CommandContext<CommandSourceStack>)ctx, "registry")))).then(Commands.m_82129_((String)"tag", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82981_(KubeJSCommands.allTags((CommandSourceStack)ctx.getSource(), KubeJSCommands.registry((CommandContext<CommandSourceStack>)ctx, "registry")).map(TagKey::f_203868_).map(ResourceLocation::toString), (SuggestionsBuilder)builder)).executes(ctx -> KubeJSCommands.tagObjects((CommandSourceStack)ctx.getSource(), TagKey.m_203882_(KubeJSCommands.registry((CommandContext<CommandSourceStack>)ctx, "registry"), (ResourceLocation)ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"tag")))))))).then(Commands.m_82127_((String)"dump_registry").then(Commands.m_82129_((String)"registry", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82981_(((CommandSourceStack)ctx.getSource()).m_5894_().m_206193_().map(entry -> entry.f_206233_().m_135782_().toString()), (SuggestionsBuilder)builder)).executes(ctx -> KubeJSCommands.dumpRegistry((CommandSourceStack)ctx.getSource(), KubeJSCommands.registry((CommandContext<CommandSourceStack>)ctx, "registry")))))).then(Commands.m_82127_((String)"wiki").executes(context -> KubeJSCommands.wiki((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"stages").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"stage", (ArgumentType)StringArgumentType.string()).executes(context -> KubeJSCommands.addStage((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"stage"))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"stage", (ArgumentType)StringArgumentType.string()).executes(context -> KubeJSCommands.removeStage((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"stage"))))))).then(Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> KubeJSCommands.clearStages((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"list").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> KubeJSCommands.listStages((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"))))))).then(Commands.m_82127_((String)"painter").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"object", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> KubeJSCommands.painter((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), CompoundTagArgument.m_87660_((CommandContext)context, (String)"object"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"generate_typings").requires(source -> source.m_81377_().m_129792_())).executes(context -> KubeJSCommands.generateTypings((CommandSourceStack)context.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"kjs_hand").executes(context -> KubeJSCommands.hand(((CommandSourceStack)context.getSource()).m_81375_(), InteractionHand.MAIN_HAND)));
    }

    private static <T> ResourceKey<Registry<T>> registry(CommandContext<CommandSourceStack> ctx, String arg) {
        return ResourceKey.m_135788_((ResourceLocation)ResourceLocationArgument.m_107011_(ctx, (String)arg));
    }

    private static <T> Stream<TagKey<T>> allTags(CommandSourceStack source, ResourceKey<Registry<T>> registry) throws CommandSyntaxException {
        return ((Registry)source.m_5894_().m_6632_(registry).orElseThrow(() -> NO_REGISTRY.create((Object)registry.m_135782_()))).m_203613_();
    }

    private static Component copy(String s, ChatFormatting col, String info) {
        MutableComponent component = Component.m_237113_((String)"- ");
        component.m_6270_(component.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY)));
        component.m_6270_(component.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, s)));
        component.m_6270_(component.m_7383_().m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)(info + " (Click to copy)")))));
        component.m_7220_((Component)Component.m_237113_((String)s).m_130940_(col));
        return component;
    }

    private static int customCommand(CommandSourceStack source, String id) {
        try {
            ServerEvents.CUSTOM_COMMAND.post(id, new CustomCommandEventJS((Level)source.m_81372_(), source.m_81373_(), new BlockPos(source.m_81371_()), id));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return 1;
    }

    private static int hand(ServerPlayer player, InteractionHand hand) {
        player.m_213846_((Component)Component.m_237113_((String)"Item in hand:"));
        ItemStack stack = player.m_21120_(hand);
        player.m_213846_(KubeJSCommands.copy(ItemStackJS.toItemString(stack), ChatFormatting.GREEN, "Item ID"));
        ArrayList tags = new ArrayList(stack.kjs$getTags());
        tags.sort(null);
        for (ResourceLocation resourceLocation : tags) {
            player.m_213846_(KubeJSCommands.copy("'#" + resourceLocation + "'", ChatFormatting.YELLOW, "Item Tag [" + IngredientPlatformHelper.get().tag(resourceLocation.toString()).kjs$getStacks().size() + " items]"));
        }
        player.m_213846_(KubeJSCommands.copy("'@" + stack.kjs$getMod() + "'", ChatFormatting.AQUA, "Mod [" + IngredientPlatformHelper.get().mod(stack.kjs$getMod()).kjs$getStacks().size() + " items]"));
        CreativeModeTab cat = stack.m_41720_().m_41471_();
        if (cat != null) {
            player.m_213846_(KubeJSCommands.copy("'%" + cat.m_40783_() + "'", ChatFormatting.LIGHT_PURPLE, "Item Group [" + IngredientPlatformHelper.get().creativeTab(cat).kjs$getStacks().size() + " items]"));
        }
        return 1;
    }

    private static int inventory(ServerPlayer player) {
        return KubeJSCommands.dump((List<ItemStack>)player.m_150109_().f_35974_, player, "Inventory");
    }

    private static int hotbar(ServerPlayer player) {
        return KubeJSCommands.dump(player.m_150109_().f_35974_.subList(0, 9), player, "Hotbar");
    }

    private static int dump(List<ItemStack> stacks, ServerPlayer player, String name) {
        String dump = stacks.toString();
        player.m_213846_(KubeJSCommands.copy(dump, ChatFormatting.WHITE, name + " Item List"));
        return 1;
    }

    private static int errors(CommandSourceStack source) {
        if (ScriptType.SERVER.errors.isEmpty()) {
            source.m_81354_((Component)Component.m_237113_((String)"No errors found!").m_130940_(ChatFormatting.GREEN), false);
            if (!ScriptType.SERVER.warnings.isEmpty()) {
                source.m_81354_(ScriptType.SERVER.warningsComponent("/kubejs warnings"), false);
            }
            return 1;
        }
        for (int i = 0; i < ScriptType.SERVER.errors.size(); ++i) {
            source.m_81354_((Component)Component.m_237113_((String)(i + 1 + ") ")).m_7220_((Component)Component.m_237113_((String)ScriptType.SERVER.errors.get(i)).m_130940_(ChatFormatting.RED)).m_130940_(ChatFormatting.DARK_RED), false);
        }
        source.m_81354_((Component)Component.m_237113_((String)"More info in ").m_7220_((Component)Component.m_237113_((String)"'logs/kubejs/server.txt'").kjs$click(new ClickEvent(ClickEvent.Action.OPEN_FILE, ScriptType.SERVER.getLogFile().toString())).kjs$hover((Component)Component.m_237113_((String)"Click to open"))).m_130940_(ChatFormatting.DARK_RED), false);
        if (!ScriptType.SERVER.warnings.isEmpty()) {
            source.m_81354_(ScriptType.SERVER.warningsComponent("/kubejs warnings"), false);
        }
        return 1;
    }

    private static int warnings(CommandSourceStack source) {
        if (ScriptType.SERVER.warnings.isEmpty()) {
            source.m_81354_((Component)Component.m_237113_((String)"No warnings found!").m_130940_(ChatFormatting.GREEN), false);
            return 1;
        }
        for (int i = 0; i < ScriptType.SERVER.warnings.size(); ++i) {
            source.m_81354_((Component)Component.m_237113_((String)(i + 1 + ") ")).m_7220_((Component)Component.m_237113_((String)ScriptType.SERVER.warnings.get(i)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16753920))).m_130940_(ChatFormatting.RED)), false);
        }
        return 1;
    }

    private static int reloadStartup(CommandSourceStack source) {
        KubeJS.getStartupScriptManager().reload(null);
        source.m_81354_((Component)Component.m_237113_((String)"Done!"), false);
        return 1;
    }

    private static int reloadServer(CommandSourceStack source) {
        ServerScriptManager.instance.reloadScriptManager((ResourceManager)source.m_81377_().kjs$getReloadableResources().f_206584_());
        source.m_81354_((Component)Component.m_237113_((String)"Done! To reload recipes, tags, loot tables and other datapack things, run ").m_7220_((Component)Component.m_237113_((String)"'/reload'").kjs$click(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/reload")).kjs$hover((Component)Component.m_237113_((String)"Click to run"))), false);
        return 1;
    }

    private static int reloadClient(CommandSourceStack source) {
        KubeJS.PROXY.reloadClientInternal();
        source.m_81354_((Component)Component.m_237113_((String)"Done! To reload textures, models and other assets, press F3 + T"), false);
        return 1;
    }

    private static int reloadTextures(CommandSourceStack source) {
        KubeJS.PROXY.reloadTextures();
        return 1;
    }

    private static int reloadLang(CommandSourceStack source) {
        KubeJS.PROXY.reloadLang();
        return 1;
    }

    private static int export(CommandSourceStack source) {
        if (DataExport.dataExport != null) {
            return 0;
        }
        DataExport.source = source;
        DataExport.dataExport = new JsonObject();
        source.m_81354_((Component)Component.m_237113_((String)"Reloading server and exporting data..."), false);
        MinecraftServer minecraftServer = source.m_81377_();
        PackRepository packRepository = minecraftServer.m_129891_();
        WorldData worldData = minecraftServer.m_129910_();
        Collection collection = packRepository.m_10523_();
        packRepository.m_10506_();
        ArrayList collection2 = Lists.newArrayList((Iterable)collection);
        List collection3 = worldData.m_7513_().m_45855_();
        for (String string : packRepository.m_10514_()) {
            if (collection3.contains(string) || collection2.contains(string)) continue;
            collection2.add(string);
        }
        ReloadCommand.m_138235_((Collection)collection2, (CommandSourceStack)source);
        return 1;
    }

    private static int exportVirtualData(CommandSourceStack source) {
        return source.m_81377_().m_177941_().m_7536_().filter(pack -> pack instanceof VirtualKubeJSDataPack).map(pack -> (VirtualKubeJSDataPack)((Object)pack)).mapToInt(pack -> {
            Path path = KubeJSPaths.EXPORTED.resolve(pack.m_8017_() + ".zip");
            try {
                Files.deleteIfExists(path);
                try (FileSystem fs = FileSystems.newFileSystem(path, Map.of("create", true));){
                    pack.export(fs);
                }
                source.m_81354_((Component)Component.m_237113_((String)"Successfully exported %s to %s".formatted(pack, path)).m_130940_(ChatFormatting.GREEN), false);
                return 1;
            }
            catch (IOException e) {
                e.printStackTrace();
                source.m_81352_((Component)Component.m_237113_((String)"Failed to export %s!".formatted(pack)).m_130938_(style -> style.m_131140_(ChatFormatting.RED).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)e.getMessage())))));
                return 0;
            }
        }).sum();
    }

    private static int outputRecipes(ServerPlayer player) {
        player.m_213846_((Component)Component.m_237113_((String)"WIP!"));
        return 1;
    }

    private static int inputRecipes(ServerPlayer player) {
        player.m_213846_((Component)Component.m_237113_((String)"WIP!"));
        return 1;
    }

    private static int checkRecipeConflicts(ServerPlayer player) {
        player.m_213846_((Component)Component.m_237113_((String)"WIP!"));
        return 1;
    }

    private static <T> int listTagsFor(CommandSourceStack source, ResourceKey<Registry<T>> registry) throws CommandSyntaxException {
        Stream<TagKey<TagKey>> tags = KubeJSCommands.allTags(source, registry);
        source.m_81354_((Component)Component.m_237119_(), false);
        source.m_81354_((Component)Component.m_237113_((String)("List of all Tags for " + registry.m_135782_() + ":")), false);
        source.m_81354_((Component)Component.m_237119_(), false);
        long size = tags.map(TagKey::f_203868_).map(tag -> Component.m_237113_((String)"- %s".formatted(tag)).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/kubejs list_tag %s %s".formatted(registry.m_135782_(), tag))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"[Show all entries for %s]".formatted(tag)))))).mapToLong(msg -> {
            source.m_81354_((Component)msg, false);
            return 1L;
        }).sum();
        source.m_81354_((Component)Component.m_237119_(), false);
        source.m_81354_((Component)Component.m_237113_((String)"Total: %d tags".formatted(size)), false);
        source.m_81354_((Component)Component.m_237113_((String)"(Click on any of the above tags to list their contents!)"), false);
        source.m_81354_((Component)Component.m_237119_(), false);
        return 1;
    }

    private static <T> int tagObjects(CommandSourceStack source, TagKey<T> key) throws CommandSyntaxException {
        Registry registry = (Registry)source.m_5894_().m_6632_(key.f_203867_()).orElseThrow(() -> NO_REGISTRY.create((Object)key.f_203867_().m_135782_()));
        Optional tag = registry.m_203431_(key);
        if (tag.isEmpty()) {
            source.m_81352_((Component)Component.m_237113_((String)"Tag not found or empty!"));
            return 0;
        }
        source.m_81354_((Component)Component.m_237119_(), false);
        source.m_81354_((Component)Component.m_237113_((String)("Contents of #" + key.f_203868_() + " [" + key.f_203867_().m_135782_() + "]:")), false);
        source.m_81354_((Component)Component.m_237119_(), false);
        HolderSet.Named items = (HolderSet.Named)tag.get();
        for (Holder holder : items) {
            String id = (String)holder.m_203439_().map(o -> o.m_135782_().toString(), o -> o + " (unknown ID)");
            source.m_81354_((Component)Component.m_237113_((String)("- " + id)), false);
        }
        source.m_81354_((Component)Component.m_237119_(), false);
        source.m_81354_((Component)Component.m_237113_((String)("Total: " + items.m_203632_() + " elements")), false);
        source.m_81354_((Component)Component.m_237119_(), false);
        return 1;
    }

    private static <T> int dumpRegistry(CommandSourceStack source, ResourceKey<Registry<T>> registry) throws CommandSyntaxException {
        Stream ids = ((Registry)source.m_5894_().m_6632_(registry).orElseThrow(() -> NO_REGISTRY.create((Object)registry.m_135782_()))).m_203611_();
        source.m_81354_((Component)Component.m_237119_(), false);
        source.m_81354_((Component)Component.m_237113_((String)("List of all entries for registry " + registry.m_135782_() + ":")), false);
        source.m_81354_((Component)Component.m_237119_(), false);
        long size = ids.map(holder -> {
            ResourceLocation id = holder.m_205785_().m_135782_();
            return Component.m_237113_((String)"- %s".formatted(id)).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"%s [%s]".formatted(holder.m_203334_(), holder.m_203334_().getClass().getName())))));
        }).mapToLong(msg -> {
            source.m_81354_((Component)msg, false);
            return 1L;
        }).sum();
        source.m_81354_((Component)Component.m_237119_(), false);
        source.m_81354_((Component)Component.m_237113_((String)"Total: %d entries".formatted(size)), false);
        source.m_81354_((Component)Component.m_237119_(), false);
        return 1;
    }

    private static int wiki(CommandSourceStack source) {
        source.m_81354_((Component)Component.m_237113_((String)"Click here to open the Wiki").m_130940_(ChatFormatting.BLUE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://kubejs.com/"))), false);
        return 1;
    }

    private static int addStage(CommandSourceStack source, Collection<ServerPlayer> players, String stage) {
        for (ServerPlayer p : players) {
            if (!p.kjs$getStages().add(stage)) continue;
            source.m_81354_((Component)Component.m_237113_((String)("Added '" + stage + "' stage for " + p.m_6302_())), false);
        }
        return 1;
    }

    private static int removeStage(CommandSourceStack source, Collection<ServerPlayer> players, String stage) {
        for (ServerPlayer p : players) {
            if (!p.kjs$getStages().remove(stage)) continue;
            source.m_81354_((Component)Component.m_237113_((String)("Removed '" + stage + "' stage for " + p.m_6302_())), false);
        }
        return 1;
    }

    private static int clearStages(CommandSourceStack source, Collection<ServerPlayer> players) {
        for (ServerPlayer p : players) {
            if (!p.kjs$getStages().clear()) continue;
            source.m_81354_((Component)Component.m_237113_((String)("Cleared stages for " + p.m_6302_())), false);
        }
        return 1;
    }

    private static int listStages(CommandSourceStack source, Collection<ServerPlayer> players) {
        for (ServerPlayer p : players) {
            source.m_81354_((Component)Component.m_237113_((String)(p.m_6302_() + " stages:")), false);
            p.kjs$getStages().getAll().stream().sorted().forEach(s -> source.m_81354_((Component)Component.m_237113_((String)("- " + s)), false));
        }
        return 1;
    }

    private static int painter(CommandSourceStack source, Collection<ServerPlayer> players, CompoundTag object) {
        new PaintMessage(object).sendTo(players);
        return 1;
    }

    private static int generateTypings(CommandSourceStack source) {
        if (!source.m_81377_().m_129792_()) {
            source.m_81352_((Component)Component.m_237113_((String)"You can only run this command in singleplayer!"));
            return 0;
        }
        KubeJS.PROXY.generateTypings(source);
        return 1;
    }
}

