/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.latvian.mods.kubejs.util.JSObjectType;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.mod.wrapper.ColorWrapper;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

public class ComponentWrapper {
    public static MutableComponent of(@Nullable Object o) {
        Map map;
        if ((o = UtilsJS.wrap(o, JSObjectType.ANY)) == null) {
            return Component.m_237113_((String)"null");
        }
        if (o instanceof Component) {
            Component component = (Component)o;
            return component.m_6881_();
        }
        if (o instanceof CharSequence || o instanceof Number || o instanceof Character) {
            return Component.m_237113_((String)o.toString());
        }
        if (o instanceof Enum) {
            Enum e = (Enum)o;
            return Component.m_237113_((String)e.name());
        }
        if (o instanceof StringTag) {
            StringTag tag = (StringTag)o;
            String s = tag.m_7916_();
            if (s.startsWith("{") && s.endsWith("}")) {
                try {
                    return Component.Serializer.m_130701_((String)s);
                }
                catch (JsonParseException ex) {
                    return Component.m_237113_((String)("Error: " + ex));
                }
            }
            return Component.m_237113_((String)s);
        }
        if (o instanceof Map && ((map = (Map)o).containsKey("text") || map.containsKey("translate"))) {
            Object a;
            MutableComponent text;
            if (map.containsKey("text")) {
                text = Component.m_237113_((String)map.get("text").toString());
            } else {
                Object[] with;
                Object v = map.get("with");
                if (v instanceof Collection) {
                    a = (Collection)v;
                    with = new Object[a.size()];
                    int i = 0;
                    Iterator iterator = a.iterator();
                    while (iterator.hasNext()) {
                        Object e1 = iterator.next();
                        with[i] = e1;
                        if (with[i] instanceof MapJS || with[i] instanceof ListJS) {
                            with[i] = ComponentWrapper.of(e1);
                        }
                        ++i;
                    }
                } else {
                    with = new Object[]{};
                }
                text = Component.m_237110_((String)map.get("translate").toString(), (Object[])with);
            }
            if (map.containsKey("color")) {
                text.kjs$color(ColorWrapper.of(map.get("color")));
            }
            text.kjs$bold((Boolean)map.getOrDefault("bold", null));
            text.kjs$italic((Boolean)map.getOrDefault("italic", null));
            text.kjs$underlined((Boolean)map.getOrDefault("underlined", null));
            text.kjs$strikethrough((Boolean)map.getOrDefault("strikethrough", null));
            text.kjs$obfuscated((Boolean)map.getOrDefault("obfuscated", null));
            text.kjs$insertion((String)map.getOrDefault("insertion", null));
            text.kjs$font(map.containsKey("font") ? new ResourceLocation(map.get("font").toString()) : null);
            text.kjs$click(map.containsKey("click") ? ComponentWrapper.clickEventOf(map.get("click")) : null);
            text.kjs$hover(map.containsKey("hover") ? ComponentWrapper.of(map.get("hover")) : null);
            a = map.get("extra");
            if (a instanceof Iterable) {
                Iterable itr = (Iterable)a;
                for (Object e : itr) {
                    text.m_7220_((Component)ComponentWrapper.of(e));
                }
            }
            return text;
        }
        if (o instanceof Iterable) {
            Iterable list = (Iterable)o;
            MutableComponent text = Component.m_237119_().m_6881_();
            for (Object e1 : list) {
                text.m_7220_((Component)ComponentWrapper.of(e1));
            }
            return text;
        }
        return Component.m_237113_((String)o.toString());
    }

    public static MutableComponent ofMutable(Object o) {
        return Component.m_237113_((String)"").m_7220_((Component)ComponentWrapper.of(o));
    }

    public static ClickEvent clickEventOf(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ClickEvent) {
            ClickEvent ce = (ClickEvent)o;
            return ce;
        }
        JsonObject json = MapJS.json(o);
        if (json != null) {
            String action = GsonHelper.m_13906_((JsonObject)json, (String)"action");
            String value = GsonHelper.m_13906_((JsonObject)json, (String)"value");
            return new ClickEvent(Objects.requireNonNull(ClickEvent.Action.m_130645_((String)action), "Invalid click event action %s!".formatted(action)), value);
        }
        String s = o.toString();
        String[] split = s.split(":", 2);
        return switch (split[0]) {
            case "command" -> new ClickEvent(ClickEvent.Action.RUN_COMMAND, split[1]);
            case "suggest_command" -> new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, split[1]);
            case "copy" -> new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, split[1]);
            case "file" -> new ClickEvent(ClickEvent.Action.OPEN_FILE, split[1]);
            default -> {
                ClickEvent.Action action = ClickEvent.Action.m_130645_((String)split[0]);
                if (action != null) {
                    yield new ClickEvent(action, split[1]);
                }
                yield new ClickEvent(ClickEvent.Action.OPEN_URL, s);
            }
        };
    }

    public static Component prettyPrintNbt(Tag tag) {
        return NbtUtils.m_178061_((Tag)tag);
    }

    public static MutableComponent join(MutableComponent separator, Iterable<? extends Component> texts) {
        MutableComponent joined = Component.m_237119_().m_6879_();
        boolean first = true;
        for (Component component : texts) {
            if (first) {
                first = false;
            } else {
                joined.m_7220_((Component)separator);
            }
            joined.m_7220_(component);
        }
        return joined;
    }

    public static MutableComponent string(String text) {
        return Component.m_237113_((String)text);
    }

    public static MutableComponent translate(String key) {
        return Component.m_237110_((String)key, (Object[])new Object[0]);
    }

    public static MutableComponent translate(String key, Object ... objects) {
        return Component.m_237110_((String)key, (Object[])objects);
    }

    public static MutableComponent keybind(String keybind) {
        return Component.m_237117_((String)keybind);
    }

    public static MutableComponent black(Object text) {
        return ComponentWrapper.of(text).kjs$black();
    }

    public static MutableComponent darkBlue(Object text) {
        return ComponentWrapper.of(text).kjs$darkBlue();
    }

    public static MutableComponent darkGreen(Object text) {
        return ComponentWrapper.of(text).kjs$darkGreen();
    }

    public static MutableComponent darkAqua(Object text) {
        return ComponentWrapper.of(text).kjs$darkAqua();
    }

    public static MutableComponent darkRed(Object text) {
        return ComponentWrapper.of(text).kjs$darkRed();
    }

    public static MutableComponent darkPurple(Object text) {
        return ComponentWrapper.of(text).kjs$darkPurple();
    }

    public static MutableComponent gold(Object text) {
        return ComponentWrapper.of(text).kjs$gold();
    }

    public static MutableComponent gray(Object text) {
        return ComponentWrapper.of(text).kjs$gray();
    }

    public static MutableComponent darkGray(Object text) {
        return ComponentWrapper.of(text).kjs$darkGray();
    }

    public static MutableComponent blue(Object text) {
        return ComponentWrapper.of(text).kjs$blue();
    }

    public static MutableComponent green(Object text) {
        return ComponentWrapper.of(text).kjs$green();
    }

    public static MutableComponent aqua(Object text) {
        return ComponentWrapper.of(text).kjs$aqua();
    }

    public static MutableComponent red(Object text) {
        return ComponentWrapper.of(text).kjs$red();
    }

    public static MutableComponent lightPurple(Object text) {
        return ComponentWrapper.of(text).kjs$lightPurple();
    }

    public static MutableComponent yellow(Object text) {
        return ComponentWrapper.of(text).kjs$yellow();
    }

    public static MutableComponent white(Object text) {
        return ComponentWrapper.of(text).kjs$white();
    }
}

