/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs;

import com.google.common.base.Stopwatch;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.utils.EnvExecutor;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJSCommon;
import dev.latvian.mods.kubejs.KubeJSOtherEventHandler;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.bindings.event.StartupEvents;
import dev.latvian.mods.kubejs.block.KubeJSBlockEventHandler;
import dev.latvian.mods.kubejs.client.KubeJSClient;
import dev.latvian.mods.kubejs.entity.KubeJSEntityEventHandler;
import dev.latvian.mods.kubejs.event.StartupEventJS;
import dev.latvian.mods.kubejs.item.KubeJSItemEventHandler;
import dev.latvian.mods.kubejs.level.KubeJSWorldEventHandler;
import dev.latvian.mods.kubejs.net.KubeJSNet;
import dev.latvian.mods.kubejs.player.KubeJSPlayerEventHandler;
import dev.latvian.mods.kubejs.recipe.KubeJSRecipeEventHandler;
import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptsLoadedEvent;
import dev.latvian.mods.kubejs.server.KubeJSServerEventHandler;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeJS {
    public static final String MOD_ID = "kubejs";
    public static final String MOD_NAME = "KubeJS";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"KubeJS");
    public static KubeJS instance;
    private static Path gameDirectory;
    public static KubeJSCommon PROXY;
    public static CreativeModeTab tab;
    private static ScriptManager startupScriptManager;
    private static ScriptManager clientScriptManager;
    public static Mod thisMod;

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ScriptManager getStartupScriptManager() {
        return startupScriptManager;
    }

    public static ScriptManager getClientScriptManager() {
        return clientScriptManager;
    }

    public KubeJS() throws Throwable {
        instance = this;
        gameDirectory = Platform.getGameFolder().normalize().toAbsolutePath();
        Locale.setDefault(Locale.US);
        if (Files.notExists(KubeJSPaths.README, new LinkOption[0])) {
            try {
                Files.writeString(KubeJSPaths.README, (CharSequence)"Find more info on the website: https://kubejs.com/\n\nDirectory information:\n\nassets - Acts as a resource pack, you can put any client resources in here, like textures, models, etc. Example: assets/kubejs/textures/item/test_item.png\ndata - Acts as a datapack, you can put any server resources in here, like loot tables, functions, etc. Example: data/kubejs/loot_tables/blocks/test_block.json\n\nstartup_scripts - Scripts that get loaded once during game startup - Used for adding items and other things that can only happen while the game is loading (Can be reloaded with /kubejs reload_startup_scripts, but it may not work!)\nserver_scripts - Scripts that get loaded every time server resources reload - Used for modifying recipes, tags, loot tables, and handling server events (Can be reloaded with /reload)\nclient_scripts - Scripts that get loaded every time client resources reload - Used for JEI events, tooltips and other client side things (Can be reloaded with F3+T)\n\nconfig - KubeJS config storage. This is also the only directory that scripts can access other than world directory\nexported - Data dumps like texture atlases end up here\n\nYou can find type-specific logs in logs/kubejs/ directory\n".trim(), new OpenOption[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        PROXY = (KubeJSCommon)EnvExecutor.getEnvSpecific(() -> KubeJSClient::new, () -> KubeJSCommon::new);
        PROXY.startThread();
        Stopwatch pluginTimer = Stopwatch.createStarted();
        LOGGER.info("Looking for KubeJS plugins...");
        thisMod = Platform.getMod((String)MOD_ID);
        KubeJSPlugins.load(thisMod);
        for (Mod mod : Platform.getMods()) {
            if (mod == thisMod) continue;
            try {
                KubeJSPlugins.load(mod);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        LOGGER.info("Done in " + pluginTimer.stop());
        KubeJSPlugins.forEachPlugin(KubeJSPlugin::init);
        KubeJSPlugins.forEachPlugin(KubeJSPlugin::registerEvents);
        startupScriptManager = new ScriptManager(ScriptType.STARTUP, KubeJSPaths.STARTUP_SCRIPTS, "example_startup_script.js");
        clientScriptManager = new ScriptManager(ScriptType.CLIENT, KubeJSPaths.CLIENT_SCRIPTS, "example_client_script.js");
        if (!CommonProperties.get().serverOnly) {
            tab = CreativeTabRegistry.create((ResourceLocation)new ResourceLocation(MOD_ID, MOD_ID), () -> new ItemStack((ItemLike)Items.f_42493_));
        }
        startupScriptManager.reload(null);
        KubeJSPlugins.forEachPlugin(KubeJSPlugin::initStartup);
        KubeJSOtherEventHandler.init();
        KubeJSWorldEventHandler.init();
        KubeJSPlayerEventHandler.init();
        KubeJSEntityEventHandler.init();
        KubeJSBlockEventHandler.init();
        KubeJSItemEventHandler.init();
        KubeJSServerEventHandler.init();
        KubeJSRecipeEventHandler.init();
        PROXY.init();
    }

    public static void loadScripts(ScriptPack pack, Path dir, String path) {
        if (!((String)path).isEmpty() && !((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        String pathPrefix = path;
        try {
            for (Path file : Files.walk(dir, 10, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList()) {
                String fileName = dir.relativize(file).toString().replace(File.separatorChar, '/');
                if (!fileName.endsWith(".js")) continue;
                pack.info.scripts.add(new ScriptFileInfo(pack.info, pathPrefix + fileName));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String appendModId(String id) {
        return id.indexOf(58) == -1 ? "kubejs:" + id : id;
    }

    public static Path getGameDirectory() {
        return gameDirectory;
    }

    public static Path verifyFilePath(Path path) throws IOException {
        if (!path.normalize().toAbsolutePath().startsWith(gameDirectory)) {
            throw new IOException("You can't access files outside Minecraft directory!");
        }
        return path;
    }

    public void setup() {
        KubeJSNet.init();
        StartupEvents.INIT.post(new StartupEventJS());
    }

    public void loadComplete() {
        KubeJSPlugins.forEachPlugin(KubeJSPlugin::afterInit);
        ((Runnable)ScriptsLoadedEvent.EVENT.invoker()).run();
        StartupEvents.POST_INIT.post(new StartupEventJS());
        UtilsJS.postModificationEvents();
        if (!ScriptType.STARTUP.errors.isEmpty()) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add("Startup script errors:");
            for (int i = 0; i < ScriptType.STARTUP.errors.size(); ++i) {
                list.add(i + 1 + ") " + ScriptType.STARTUP.errors.get(i));
            }
            LOGGER.error(String.join((CharSequence)"\n", list));
            ConsoleJS.STARTUP.flush(true);
            throw new RuntimeException("There were KubeJS startup script syntax errors! See logs/kubejs/startup.txt for more info");
        }
    }

    static {
        tab = CreativeModeTab.f_40753_;
    }
}

