/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import dev.ftb.mods.ftbteams.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.util.Optional;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class DoubleProperty
extends TeamProperty<Double> {
    public final double minValue;
    public final double maxValue;

    public DoubleProperty(ResourceLocation id, double def, double min, double max) {
        super(id, def);
        this.minValue = min;
        this.maxValue = max;
    }

    public DoubleProperty(ResourceLocation id, double def) {
        this(id, def, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DoubleProperty(ResourceLocation id, FriendlyByteBuf buf) {
        super(id, buf.readDouble());
        this.minValue = buf.readDouble();
        this.maxValue = buf.readDouble();
    }

    @Override
    public TeamPropertyType<Double> getType() {
        return TeamPropertyType.DOUBLE;
    }

    @Override
    public Optional<Double> fromString(String string) {
        try {
            double num = Double.parseDouble(string);
            return Optional.of(Mth.m_14008_((double)num, (double)this.minValue, (double)this.maxValue));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeDouble(((Double)this.defaultValue).doubleValue());
        buf.writeDouble(this.minValue);
        buf.writeDouble(this.maxValue);
    }

    @Override
    public void config(ConfigGroup config, TeamPropertyValue<Double> value) {
        config.addDouble(this.id.m_135815_(), ((Double)value.value).doubleValue(), value.consumer, ((Double)this.defaultValue).doubleValue(), this.minValue, this.maxValue);
    }

    @Override
    public Tag toNBT(Double value) {
        return DoubleTag.m_128500_((double)value);
    }

    @Override
    public Optional<Double> fromNBT(Tag tag) {
        if (tag instanceof NumericTag) {
            return Optional.of(Mth.m_14008_((double)((NumericTag)tag).m_7061_(), (double)this.minValue, (double)this.maxValue));
        }
        return Optional.empty();
    }
}

