/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamBase;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;

public class ClientTeam
extends TeamBase {
    public final ClientTeamManager manager;
    public boolean invalid;
    TeamType type;
    private final UUID ownerID;

    public ClientTeam(ClientTeamManager m, FriendlyByteBuf buffer, long now) {
        this.manager = m;
        this.id = buffer.m_130259_();
        this.type = TeamType.VALUES[buffer.readByte()];
        this.properties.read(buffer);
        int rs = buffer.m_130242_();
        for (int i = 0; i < rs; ++i) {
            this.ranks.put(buffer.m_130259_(), TeamRank.VALUES[buffer.readByte()]);
        }
        this.extraData = buffer.m_130260_();
        this.ownerID = buffer.readBoolean() ? buffer.m_130259_() : Util.f_137441_;
    }

    public ClientTeam(ClientTeamManager m, Team team) {
        this.manager = m;
        this.id = team.getId();
        this.type = team.getType();
        this.properties.updateFrom(team.properties);
        this.ranks.putAll(team.ranks);
        this.extraData = team.extraData == null ? null : team.extraData.m_6426_();
        this.ownerID = team.getOwner();
    }

    @Override
    public TeamType getType() {
        return this.type;
    }

    @Override
    public boolean isValid() {
        return this.manager.teamMap.containsKey(this.id);
    }

    public void write(FriendlyByteBuf buffer, long now) {
        buffer.m_130077_(this.id);
        buffer.writeByte(this.type.ordinal());
        this.properties.write(buffer);
        buffer.m_130130_(this.ranks.size());
        for (Map.Entry entry : this.ranks.entrySet()) {
            buffer.m_130077_((UUID)entry.getKey());
            buffer.writeByte(((TeamRank)((Object)entry.getValue())).ordinal());
        }
        buffer.m_130079_(this.extraData);
        boolean hasOwner = !this.ownerID.equals(Util.f_137441_);
        buffer.writeBoolean(hasOwner);
        if (hasOwner) {
            buffer.m_130077_(this.ownerID);
        }
    }

    public boolean isSelf() {
        return this == this.manager.selfTeam;
    }

    public UUID getOwnerID() {
        return this.ownerID;
    }
}

