/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.client;

import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftbteams.client.BaseInvitationScreen;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import dev.ftb.mods.ftbteams.net.PlayerGUIOperationMessage;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.chat.Component;

public class AllyScreen
extends BaseInvitationScreen {
    private final Set<GameProfile> existingAllies = new HashSet<GameProfile>();
    private Set<GameProfile> toAdd = new HashSet<GameProfile>();
    private Set<GameProfile> toRemove = new HashSet<GameProfile>();

    public AllyScreen() {
        super((Component)Component.m_237115_((String)"ftbteams.gui.manage_allies"));
        this.available.forEach(player -> {
            if (ClientTeamManager.INSTANCE.selfTeam.isAlly(player.uuid)) {
                this.existingAllies.add(player.getProfile());
                this.invites.add(player.getProfile());
            }
        });
    }

    @Override
    protected boolean shouldIncludePlayer(KnownClientPlayer player) {
        return player.isValid() && !ClientTeamManager.INSTANCE.selfTeam.isMember(player.uuid);
    }

    @Override
    public void setInvited(GameProfile profile, boolean invited) {
        super.setInvited(profile, invited);
        this.toRemove = Sets.difference(this.existingAllies, (Set)this.invites);
        this.toAdd = Sets.difference((Set)this.invites, this.existingAllies);
    }

    @Override
    protected BaseInvitationScreen.ExecuteButton makeExecuteButton() {
        return new BaseInvitationScreen.ExecuteButton((Component)Component.m_237115_((String)"gui.accept"), Icons.ADD, () -> {
            if (!this.toAdd.isEmpty()) {
                new PlayerGUIOperationMessage(PlayerGUIOperationMessage.Operation.ADD_ALLY, this.toAdd).sendToServer();
            }
            if (!this.toRemove.isEmpty()) {
                new PlayerGUIOperationMessage(PlayerGUIOperationMessage.Operation.REMOVE_ALLY, this.toRemove).sendToServer();
            }
            this.closeGui();
        }){

            public boolean isEnabled() {
                return !AllyScreen.this.toAdd.isEmpty() || !AllyScreen.this.toRemove.isEmpty();
            }
        };
    }
}

