/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.forge;

import dev.architectury.platform.Platform;
import dev.architectury.platform.forge.EventBuses;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.compat.waystones.WaystonesCompat;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.Protection;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="ftbchunks")
public class FTBChunksForge {
    public FTBChunksForge() {
        EventBuses.registerModEventBus((String)"ftbchunks", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.addListener(this::entityInteractSpecific);
        FTBChunks.instance = new FTBChunks();
        ForgeChunkManager.setForcedChunkLoadingCallback((String)"ftbchunks", this::validateLoadedChunks);
        if (Platform.isModLoaded((String)"waystones")) {
            WaystonesCompat.init();
        }
    }

    private void entityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!event.getEntity().f_19853_.f_46443_ && FTBChunksAPI.getManager().protect((Entity)event.getEntity(), event.getHand(), event.getEntity().m_20183_(), Protection.INTERACT_ENTITY, event.getTarget())) {
            event.setCancellationResult(InteractionResult.FAIL);
            event.setCanceled(true);
        }
    }

    private void validateLoadedChunks(ServerLevel level, ForgeChunkManager.TicketHelper ticketHelper) {
        ticketHelper.getEntityTickets().forEach((id, chunks) -> {
            FTBChunks.LOGGER.info(String.format("cleaning up %d non-ticking and %d ticking tickets for %s", ((LongSet)chunks.getFirst()).size(), ((LongSet)chunks.getSecond()).size(), id));
            ticketHelper.removeAllTickets(id);
        });
    }
}

