/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.simibubi.create.content.contraptions.fluids.actors.FluidManipulationBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.utility.BBHelper;
import com.simibubi.create.foundation.utility.Iterate;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.LevelTicks;

public class FluidFillingBehaviour
extends FluidManipulationBehaviour {
    public static final BehaviourType<FluidFillingBehaviour> TYPE = new BehaviourType();
    PriorityQueue<FluidManipulationBehaviour.BlockPosEntry> queue = new ObjectHeapPriorityQueue((p, p2) -> -this.comparePositions((FluidManipulationBehaviour.BlockPosEntry)p, (FluidManipulationBehaviour.BlockPosEntry)p2));
    List<FluidManipulationBehaviour.BlockPosEntry> infinityCheckFrontier;
    Set<BlockPos> infinityCheckVisited;

    public FluidFillingBehaviour(SmartTileEntity te) {
        super(te);
        this.revalidateIn = 1;
        this.infinityCheckFrontier = new ArrayList<FluidManipulationBehaviour.BlockPosEntry>();
        this.infinityCheckVisited = new HashSet<BlockPos>();
    }

    @Override
    public void tick() {
        Fluid fluid;
        super.tick();
        if (!this.infinityCheckFrontier.isEmpty() && this.rootPos != null && (fluid = this.getWorld().m_6425_(this.rootPos).m_76152_()) != Fluids.f_76191_) {
            this.continueValidation(fluid);
        }
        if (this.revalidateIn > 0) {
            --this.revalidateIn;
        }
    }

    protected void continueValidation(Fluid fluid) {
        try {
            this.search(fluid, this.infinityCheckFrontier, this.infinityCheckVisited, (p, d) -> this.infinityCheckFrontier.add(new FluidManipulationBehaviour.BlockPosEntry((BlockPos)p, (int)d)), true);
        }
        catch (FluidManipulationBehaviour.ChunkNotLoadedException e) {
            this.infinityCheckFrontier.clear();
            this.setLongValidationTimer();
            return;
        }
        int maxBlocks = this.maxBlocks();
        if (this.infinityCheckVisited.size() > maxBlocks && maxBlocks != -1 && !this.fillInfinite()) {
            if (!this.infinite) {
                this.reset();
                this.infinite = true;
                this.tileEntity.sendData();
            }
            this.infinityCheckFrontier.clear();
            this.setLongValidationTimer();
            return;
        }
        if (!this.infinityCheckFrontier.isEmpty()) {
            return;
        }
        if (this.infinite) {
            this.reset();
            return;
        }
        this.infinityCheckVisited.clear();
    }

    public boolean tryDeposit(Fluid fluid, BlockPos root, boolean simulate) {
        if (!Objects.equals(root, this.rootPos)) {
            this.reset();
            this.rootPos = root;
            this.queue.enqueue((Object)new FluidManipulationBehaviour.BlockPosEntry(root, 0));
            this.affectedArea = BoundingBox.m_162375_((Vec3i)this.rootPos, (Vec3i)this.rootPos);
            return false;
        }
        if (this.counterpartActed) {
            this.counterpartActed = false;
            this.softReset(root);
            return false;
        }
        if (this.affectedArea == null) {
            this.affectedArea = BoundingBox.m_162375_((Vec3i)root, (Vec3i)root);
        }
        if (this.revalidateIn == 0) {
            this.visited.clear();
            this.infinityCheckFrontier.clear();
            this.infinityCheckVisited.clear();
            this.infinityCheckFrontier.add(new FluidManipulationBehaviour.BlockPosEntry(root, 0));
            this.setValidationTimer();
            this.softReset(root);
        }
        Level world = this.getWorld();
        int maxRange = this.maxRange();
        int maxRangeSq = maxRange * maxRange;
        int maxBlocks = this.maxBlocks();
        boolean evaporate = world.m_6042_().f_63857_() && FluidHelper.isTag(fluid, (TagKey<Fluid>)FluidTags.f_13131_);
        boolean canPlaceSources = (Boolean)AllConfigs.SERVER.fluids.placeFluidSourceBlocks.get();
        if (!this.fillInfinite() && this.infinite || evaporate || !canPlaceSources) {
            FluidState fluidState = world.m_6425_(this.rootPos);
            boolean equivalentTo = fluidState.m_76152_().m_6212_(fluid);
            if (!equivalentTo && !evaporate && canPlaceSources) {
                return false;
            }
            if (simulate) {
                return true;
            }
            this.playEffect(world, root, fluid, false);
            if (evaporate) {
                int i = root.m_123341_();
                int j = root.m_123342_();
                int k = root.m_123343_();
                world.m_6263_(null, (double)i, (double)j, (double)k, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.8f);
            } else if (!canPlaceSources) {
                this.tileEntity.award(AllAdvancements.HOSE_PULLEY);
            }
            return true;
        }
        boolean success = false;
        for (int i = 0; !success && !this.queue.isEmpty() && i < 1024; ++i) {
            SpaceType spaceType;
            FluidManipulationBehaviour.BlockPosEntry entry = (FluidManipulationBehaviour.BlockPosEntry)this.queue.first();
            BlockPos currentPos = entry.pos();
            if (this.visited.contains(currentPos)) {
                this.queue.dequeue();
                continue;
            }
            if (!simulate) {
                this.visited.add(currentPos);
            }
            if (this.visited.size() >= maxBlocks && maxBlocks != -1) {
                this.infinite = true;
                if (!this.fillInfinite()) {
                    this.visited.clear();
                    this.queue.clear();
                    return false;
                }
            }
            if ((spaceType = this.getAtPos(world, currentPos, fluid)) == SpaceType.BLOCKING) continue;
            if (spaceType == SpaceType.FILLABLE) {
                success = true;
                if (!simulate) {
                    LevelTickAccess pendingFluidTicks;
                    this.playEffect(world, currentPos, fluid, false);
                    BlockState blockState = world.m_8055_(currentPos);
                    if (blockState.m_61138_((Property)BlockStateProperties.f_61362_) && fluid.m_6212_((Fluid)Fluids.f_76193_)) {
                        if (!this.tileEntity.isVirtual()) {
                            world.m_7731_(currentPos, this.updatePostWaterlogging((BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true))), 18);
                        }
                    } else {
                        this.replaceBlock(world, currentPos, blockState);
                        if (!this.tileEntity.isVirtual()) {
                            world.m_7731_(currentPos, FluidHelper.convertToStill(fluid).m_76145_().m_76188_(), 18);
                        }
                    }
                    if ((pendingFluidTicks = world.m_183324_()) instanceof LevelTicks) {
                        LevelTicks serverTickList = (LevelTicks)pendingFluidTicks;
                        serverTickList.m_193234_(new BoundingBox(currentPos));
                    }
                    this.affectedArea = BBHelper.encapsulate(this.affectedArea, currentPos);
                }
            }
            if (simulate && success) {
                return true;
            }
            this.visited.add(currentPos);
            this.queue.dequeue();
            for (Direction side : Iterate.directions) {
                SpaceType nextSpaceType;
                BlockPos offsetPos;
                if (side == Direction.UP || this.visited.contains(offsetPos = currentPos.m_121945_(side)) || offsetPos.m_123331_((Vec3i)this.rootPos) > (double)maxRangeSq || (nextSpaceType = this.getAtPos(world, offsetPos, fluid)) == SpaceType.BLOCKING) continue;
                this.queue.enqueue((Object)new FluidManipulationBehaviour.BlockPosEntry(offsetPos, entry.distance() + 1));
            }
        }
        if (!simulate && success) {
            this.tileEntity.award(AllAdvancements.HOSE_PULLEY);
        }
        return success;
    }

    protected void softReset(BlockPos root) {
        this.visited.clear();
        this.queue.clear();
        this.queue.enqueue((Object)new FluidManipulationBehaviour.BlockPosEntry(root, 0));
        this.infinite = false;
        this.setValidationTimer();
        this.tileEntity.sendData();
    }

    protected SpaceType getAtPos(Level world, BlockPos pos, Fluid toFill) {
        BlockState blockState = world.m_8055_(pos);
        FluidState fluidState = blockState.m_60819_();
        if (blockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
            return toFill.m_6212_((Fluid)Fluids.f_76193_) ? (((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() ? SpaceType.FILLED : SpaceType.FILLABLE) : SpaceType.BLOCKING;
        }
        if (blockState.m_60734_() instanceof LiquidBlock) {
            return (Integer)blockState.m_61143_((Property)LiquidBlock.f_54688_) == 0 ? (toFill.m_6212_(fluidState.m_76152_()) ? SpaceType.FILLED : SpaceType.BLOCKING) : SpaceType.FILLABLE;
        }
        if (fluidState.m_76152_() != Fluids.f_76191_ && blockState.m_60742_((BlockGetter)this.getWorld(), pos, CollisionContext.m_82749_()).m_83281_()) {
            return toFill.m_6212_(fluidState.m_76152_()) ? SpaceType.FILLED : SpaceType.BLOCKING;
        }
        return this.canBeReplacedByFluid((BlockGetter)world, pos, blockState) ? SpaceType.FILLABLE : SpaceType.BLOCKING;
    }

    protected void replaceBlock(Level world, BlockPos pos, BlockState state) {
        BlockEntity tileentity = state.m_155947_() ? world.m_7702_(pos) : null;
        Block.m_49892_((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)tileentity);
    }

    protected boolean canBeReplacedByFluid(BlockGetter world, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (!(block instanceof DoorBlock) && !state.m_204336_(BlockTags.f_13068_) && block != Blocks.f_50155_ && block != Blocks.f_50130_ && block != Blocks.f_50628_) {
            Material material = state.m_60767_();
            if (material != Material.f_76298_ && material != Material.f_76297_ && material != Material.f_76301_ && material != Material.f_76304_) {
                return !material.m_76334_();
            }
            return false;
        }
        return false;
    }

    protected BlockState updatePostWaterlogging(BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61443_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    @Override
    public void reset() {
        super.reset();
        this.queue.clear();
        this.infinityCheckFrontier.clear();
        this.infinityCheckVisited.clear();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    static enum SpaceType {
        FILLABLE,
        FILLED,
        BLOCKING;

    }
}

