/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.google.common.base.Predicates;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.components.actors.BlockBreakingMovementBehaviour;
import com.simibubi.create.content.contraptions.components.actors.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovingInteractionBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.TrainCollisionPacket;
import com.simibubi.create.content.contraptions.components.structureMovement.TranslatingContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.sync.ClientMotionPacket;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.collision.ContinuousOBBCollider;
import com.simibubi.create.foundation.collision.Matrix3d;
import com.simibubi.create.foundation.collision.OrientedBB;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableObject;

public class ContraptionCollider {
    static void collideEntities(AbstractContraptionEntity contraptionEntity) {
        Level world = contraptionEntity.m_20193_();
        Contraption contraption = contraptionEntity.getContraption();
        AABB bounds = contraptionEntity.m_20191_();
        if (contraption == null) {
            return;
        }
        if (bounds == null) {
            return;
        }
        Vec3 contraptionPosition = contraptionEntity.m_20182_();
        Vec3 contraptionMotion = contraptionPosition.m_82546_(contraptionEntity.getPrevPositionVec());
        Vec3 anchorVec = contraptionEntity.getAnchorVec();
        AbstractContraptionEntity.ContraptionRotationState rotation = null;
        boolean skipClientPlayer = false;
        List entitiesWithinAABB = world.m_6443_(Entity.class, bounds.m_82400_(2.0).m_82363_(0.0, 32.0, 0.0), contraptionEntity::m_7337_);
        for (Entity entity : entitiesWithinAABB) {
            double d1;
            double idealVerticalMotion;
            boolean anyCollision;
            Vec3 entityMotion;
            PlayerType playerType;
            if (!entity.m_6084_() || (playerType = ContraptionCollider.getPlayerType(entity)) == PlayerType.REMOTE) continue;
            entity.m_20199_().forEach(e -> {
                if (e instanceof ServerPlayer) {
                    ((ServerPlayer)e).f_8906_.f_9737_ = 0;
                }
            });
            if (playerType == PlayerType.SERVER) continue;
            if (playerType == PlayerType.CLIENT) {
                if (skipClientPlayer) continue;
                skipClientPlayer = true;
            }
            if (rotation == null) {
                rotation = contraptionEntity.getRotationState();
            }
            Matrix3d rotationMatrix = rotation.asMatrix();
            Vec3 entityPosition = entity.m_20182_();
            AABB entityBounds = entity.m_20191_();
            Vec3 motion = entity.m_20184_();
            float yawOffset = rotation.getYawOffset();
            Vec3 position = ContraptionCollider.getWorldToLocalTranslation(entity, anchorVec, rotationMatrix, yawOffset);
            AABB localBB = entityBounds.m_82383_(position).m_82400_(1.0E-7);
            OrientedBB obb = new OrientedBB(localBB);
            obb.setRotation(rotationMatrix);
            motion = motion.m_82546_(contraptionMotion);
            Vec3 motionCopy = motion = rotationMatrix.transform(motion);
            List collidableBBs = contraption.getSimplifiedEntityColliders().orElseGet(() -> {
                ArrayList bbs = new ArrayList();
                List<VoxelShape> potentialHits = ContraptionCollider.getPotentiallyCollidedShapes(world, contraption, localBB.m_82369_(motionCopy));
                potentialHits.forEach(shape -> shape.m_83299_().forEach(bbs::add));
                return bbs;
            });
            MutableObject collisionResponse = new MutableObject((Object)Vec3.f_82478_);
            MutableObject normal = new MutableObject((Object)Vec3.f_82478_);
            MutableObject location = new MutableObject((Object)Vec3.f_82478_);
            MutableBoolean surfaceCollision = new MutableBoolean(false);
            MutableFloat temporalResponse = new MutableFloat(1.0f);
            Vec3 obbCenter = obb.getCenter();
            boolean doHorizontalPass = !rotation.hasVerticalRotation();
            for (boolean horizontalPass : Iterate.trueAndFalse) {
                boolean noVerticalCollision;
                boolean verticalPass = !horizontalPass || !doHorizontalPass;
                for (AABB bb : collidableBBs) {
                    boolean nearest;
                    Vec3 separation;
                    double timeOfImpact;
                    Vec3 currentResponse = (Vec3)collisionResponse.getValue();
                    Vec3 currentCenter = obbCenter.m_82549_(currentResponse);
                    if (Math.abs(currentCenter.f_82479_ - bb.m_82399_().f_82479_) - entityBounds.m_82362_() - 1.0 > bb.m_82362_() / 2.0 || Math.abs(currentCenter.f_82480_ + motion.f_82480_ - bb.m_82399_().f_82480_) - entityBounds.m_82376_() - 1.0 > bb.m_82376_() / 2.0 || Math.abs(currentCenter.f_82481_ - bb.m_82399_().f_82481_) - entityBounds.m_82385_() - 1.0 > bb.m_82385_() / 2.0) continue;
                    obb.setCenter(currentCenter);
                    ContinuousOBBCollider.ContinuousSeparationManifold intersect = obb.intersect(bb, motion);
                    if (intersect == null) continue;
                    if (verticalPass && surfaceCollision.isFalse()) {
                        surfaceCollision.setValue(intersect.isSurfaceCollision());
                    }
                    boolean isTemporal = (timeOfImpact = intersect.getTimeOfImpact()) > 0.0 && timeOfImpact < 1.0;
                    Vec3 collidingNormal = intersect.getCollisionNormal();
                    Vec3 collisionPosition = intersect.getCollisionPosition();
                    if (!isTemporal && (separation = intersect.asSeparationVec(entity.getStepHeight())) != null && !separation.equals((Object)Vec3.f_82478_)) {
                        collisionResponse.setValue((Object)currentResponse.m_82549_(separation));
                        timeOfImpact = 0.0;
                    }
                    boolean bl = nearest = timeOfImpact >= 0.0 && (double)temporalResponse.getValue().floatValue() > timeOfImpact;
                    if (collidingNormal != null && nearest) {
                        normal.setValue((Object)collidingNormal);
                    }
                    if (collisionPosition != null && nearest) {
                        location.setValue((Object)collisionPosition);
                    }
                    if (!isTemporal || !((double)temporalResponse.getValue().floatValue() > timeOfImpact)) continue;
                    temporalResponse.setValue((Number)timeOfImpact);
                }
                if (verticalPass) break;
                boolean noVerticalMotionResponse = temporalResponse.getValue().floatValue() == 1.0f;
                boolean bl = noVerticalCollision = ((Vec3)collisionResponse.getValue()).f_82480_ == 0.0;
                if (noVerticalCollision && noVerticalMotionResponse) break;
                collisionResponse.setValue((Object)((Vec3)collisionResponse.getValue()).m_82542_(1.0078125, 0.0, 1.0078125));
            }
            Vec3 entityMotionNoTemporal = entityMotion = entity.m_20184_();
            Vec3 collisionNormal = (Vec3)normal.getValue();
            Vec3 collisionLocation = (Vec3)location.getValue();
            Vec3 totalResponse = (Vec3)collisionResponse.getValue();
            boolean hardCollision = !totalResponse.equals((Object)Vec3.f_82478_);
            boolean temporalCollision = temporalResponse.getValue().floatValue() != 1.0f;
            Vec3 motionResponse = !temporalCollision ? motion : motion.m_82541_().m_82490_(motion.m_82553_() * (double)temporalResponse.getValue().floatValue());
            rotationMatrix.transpose();
            motionResponse = rotationMatrix.transform(motionResponse).m_82549_(contraptionMotion);
            totalResponse = rotationMatrix.transform(totalResponse);
            totalResponse = VecHelper.rotate(totalResponse, yawOffset, Direction.Axis.Y);
            collisionNormal = rotationMatrix.transform(collisionNormal);
            collisionNormal = VecHelper.rotate(collisionNormal, yawOffset, Direction.Axis.Y);
            collisionNormal = collisionNormal.m_82541_();
            collisionLocation = rotationMatrix.transform(collisionLocation);
            collisionLocation = VecHelper.rotate(collisionLocation, yawOffset, Direction.Axis.Y);
            rotationMatrix.transpose();
            double bounce = 0.0;
            double slide = 0.0;
            if (!collisionLocation.equals((Object)Vec3.f_82478_)) {
                BlockState blockState;
                collisionLocation = collisionLocation.m_82549_(entity.m_20182_().m_82549_(entity.m_20191_().m_82399_()).m_82490_(0.5));
                if (temporalCollision) {
                    collisionLocation = collisionLocation.m_82520_(0.0, motionResponse.f_82480_, 0.0);
                }
                BlockPos pos = new BlockPos(contraptionEntity.toLocalVector(entity.m_20182_(), 0.0f));
                if (contraption.getBlocks().containsKey(pos) && (blockState = contraption.getBlocks().get((Object)pos).f_74676_).m_204336_(BlockTags.f_13082_)) {
                    surfaceCollision.setTrue();
                    totalResponse = totalResponse.m_82520_(0.0, (double)0.1f, 0.0);
                }
                pos = new BlockPos(contraptionEntity.toLocalVector(collisionLocation, 0.0f));
                if (contraption.getBlocks().containsKey(pos)) {
                    blockState = contraption.getBlocks().get((Object)pos).f_74676_;
                    MovingInteractionBehaviour movingInteractionBehaviour = contraption.interactors.get(pos);
                    if (movingInteractionBehaviour != null) {
                        movingInteractionBehaviour.handleEntityCollision(entity, pos, contraptionEntity);
                    }
                    bounce = BlockHelper.getBounceMultiplier(blockState.m_60734_());
                    slide = Math.max(0.0f, blockState.getFriction((LevelReader)contraption.world, pos, entity) - 0.6f);
                }
            }
            boolean hasNormal = !collisionNormal.equals((Object)Vec3.f_82478_);
            boolean bl = anyCollision = hardCollision || temporalCollision;
            if (bounce > 0.0 && hasNormal && anyCollision && ContraptionCollider.bounceEntity(entity, collisionNormal, contraptionEntity, bounce)) {
                entity.f_19853_.m_6263_(playerType == PlayerType.CLIENT ? (Player)entity : null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12390_, SoundSource.BLOCKS, 0.5f, 1.0f);
                continue;
            }
            if (temporalCollision && (idealVerticalMotion = motionResponse.f_82480_) != entityMotion.f_82480_) {
                entity.m_20256_(entityMotion.m_82542_(1.0, 0.0, 1.0).m_82520_(0.0, idealVerticalMotion, 0.0));
                entityMotion = entity.m_20184_();
            }
            if (hardCollision) {
                double motionX = entityMotion.m_7096_();
                double motionY = entityMotion.m_7098_();
                double motionZ = entityMotion.m_7094_();
                double intersectX = totalResponse.m_7096_();
                double intersectY = totalResponse.m_7098_();
                double intersectZ = totalResponse.m_7094_();
                double horizonalEpsilon = 0.0078125;
                if (motionX != 0.0 && Math.abs(intersectX) > horizonalEpsilon && motionX > 0.0 == intersectX < 0.0) {
                    entityMotion = entityMotion.m_82542_(0.0, 1.0, 1.0);
                }
                if (motionY != 0.0 && intersectY != 0.0 && motionY > 0.0 == intersectY < 0.0) {
                    entityMotion = entityMotion.m_82542_(1.0, 0.0, 1.0).m_82520_(0.0, contraptionMotion.f_82480_, 0.0);
                }
                if (motionZ != 0.0 && Math.abs(intersectZ) > horizonalEpsilon && motionZ > 0.0 == intersectZ < 0.0) {
                    entityMotion = entityMotion.m_82542_(1.0, 1.0, 0.0);
                }
            }
            if (bounce == 0.0 && slide > 0.0 && hasNormal && anyCollision && rotation.hasVerticalRotation()) {
                double slideFactor = collisionNormal.m_82542_(1.0, 0.0, 1.0).m_82553_() * 1.25;
                Vec3 motionIn = entityMotionNoTemporal.m_82542_(0.0, 0.9, 0.0).m_82520_(0.0, (double)-0.01f, 0.0);
                Vec3 slideNormal = collisionNormal.m_82537_(motionIn.m_82537_(collisionNormal)).m_82541_();
                Vec3 newMotion = entityMotion.m_82542_(0.85, 0.0, 0.85).m_82549_(slideNormal.m_82490_(((double)0.2f + slide) * motionIn.m_82553_() * slideFactor).m_82520_(0.0, (double)-0.1f - collisionNormal.f_82480_ * 0.125, 0.0));
                entity.m_20256_(newMotion);
                entityMotion = entity.m_20184_();
            }
            if (!hardCollision && surfaceCollision.isFalse()) continue;
            Vec3 allowedMovement = ContraptionCollider.collide(totalResponse, entity);
            entity.m_6034_(entityPosition.f_82479_ + allowedMovement.f_82479_, entityPosition.f_82480_ + allowedMovement.f_82480_, entityPosition.f_82481_ + allowedMovement.f_82481_);
            entityPosition = entity.m_20182_();
            entityMotion = ContraptionCollider.handleDamageFromTrain(world, contraptionEntity, contraptionMotion, entity, entityMotion, playerType);
            entity.f_19864_ = true;
            Vec3 contactPointMotion = Vec3.f_82478_;
            if (surfaceCollision.isTrue()) {
                boolean canWalk;
                contraptionEntity.registerColliding(entity);
                entity.f_19789_ = 0.0f;
                boolean bl2 = canWalk = bounce != 0.0 || slide == 0.0;
                if (canWalk || !rotation.hasVerticalRotation()) {
                    if (canWalk) {
                        entity.m_6853_(true);
                    }
                    if (entity instanceof ItemEntity) {
                        entityMotion = entityMotion.m_82542_(0.5, 1.0, 0.5);
                    }
                }
                contactPointMotion = contraptionEntity.getContactPointMotion(entityPosition);
                allowedMovement = ContraptionCollider.collide(contactPointMotion, entity);
                entity.m_6034_(entityPosition.f_82479_ + allowedMovement.f_82479_, entityPosition.f_82480_, entityPosition.f_82481_ + allowedMovement.f_82481_);
            }
            entity.m_20256_(entityMotion);
            if (playerType != PlayerType.CLIENT) continue;
            double d0 = entity.m_20185_() - entity.f_19854_ - contactPointMotion.f_82479_;
            float limbSwing = Mth.m_14116_((float)((float)(d0 * d0 + (d1 = entity.m_20189_() - entity.f_19856_ - contactPointMotion.f_82481_) * d1))) * 4.0f;
            if (limbSwing > 1.0f) {
                limbSwing = 1.0f;
            }
            AllPackets.channel.sendToServer((Object)new ClientMotionPacket(entityMotion, true, limbSwing));
        }
    }

    private static Vec3 handleDamageFromTrain(Level world, AbstractContraptionEntity contraptionEntity, Vec3 contraptionMotion, Entity entity, Vec3 entityMotion, PlayerType playerType) {
        Player p;
        if (!(contraptionEntity instanceof CarriageContraptionEntity)) {
            return entityMotion;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)contraptionEntity;
        if (!entity.m_20096_()) {
            return entityMotion;
        }
        CompoundTag persistentData = entity.getPersistentData();
        if (persistentData.m_128441_("ContraptionGrounded")) {
            persistentData.m_128473_("ContraptionGrounded");
            return entityMotion;
        }
        if (cce.collidingEntities.containsKey(entity)) {
            return entityMotion;
        }
        if (entity instanceof ItemEntity) {
            return entityMotion;
        }
        if (cce.nonDamageTicks != 0) {
            return entityMotion;
        }
        if (!((Boolean)AllConfigs.SERVER.trains.trainsCauseDamage.get()).booleanValue()) {
            return entityMotion;
        }
        Vec3 diffMotion = contraptionMotion.m_82546_(entity.m_20184_());
        if (diffMotion.m_82553_() <= (double)0.35f || contraptionMotion.m_82553_() <= (double)0.35f) {
            return entityMotion;
        }
        EntityDamageSource pSource = new EntityDamageSource("create.run_over", (Entity)contraptionEntity);
        double damage = diffMotion.m_82553_();
        if (entity.getClassification(false) == MobCategory.MONSTER) {
            damage *= 2.0;
        }
        if (entity instanceof Player && ((p = (Player)entity).m_7500_() || p.m_5833_())) {
            return entityMotion;
        }
        if (playerType == PlayerType.CLIENT) {
            AllPackets.channel.sendToServer((Object)new TrainCollisionPacket((int)(damage * 16.0), contraptionEntity.m_19879_()));
            world.m_5594_((Player)entity, entity.m_20183_(), SoundEvents.f_12313_, SoundSource.NEUTRAL, 1.0f, 0.75f);
        } else {
            entity.m_6469_((DamageSource)pSource, (float)((int)(damage * 16.0)));
            world.m_5594_(null, entity.m_20183_(), SoundEvents.f_12313_, SoundSource.NEUTRAL, 1.0f, 0.75f);
            if (!entity.m_6084_()) {
                contraptionEntity.getControllingPlayer().map(arg_0 -> ((Level)world).m_46003_(arg_0)).ifPresent(AllAdvancements.TRAIN_ROADKILL::awardTo);
            }
        }
        Vec3 added = entityMotion.m_82549_(contraptionMotion.m_82542_(1.0, 0.0, 1.0).m_82541_().m_82520_(0.0, 0.25, 0.0).m_82490_(damage * 4.0)).m_82549_(diffMotion);
        return VecHelper.clamp(added, 3.0f);
    }

    static boolean bounceEntity(Entity entity, Vec3 normal, AbstractContraptionEntity contraption, double factor) {
        if (factor == 0.0) {
            return false;
        }
        if (entity.m_20162_()) {
            return false;
        }
        Vec3 contactPointMotion = contraption.getContactPointMotion(entity.m_20182_());
        Vec3 motion = entity.m_20184_().m_82546_(contactPointMotion);
        Vec3 deltav = normal.m_82490_(factor * 2.0 * motion.m_82526_(normal));
        if (deltav.m_82526_(deltav) < (double)0.1f) {
            return false;
        }
        entity.m_20256_(entity.m_20184_().m_82546_(deltav));
        return true;
    }

    public static Vec3 getWorldToLocalTranslation(Entity entity, AbstractContraptionEntity contraptionEntity) {
        return ContraptionCollider.getWorldToLocalTranslation(entity, contraptionEntity.getAnchorVec(), contraptionEntity.getRotationState());
    }

    public static Vec3 getWorldToLocalTranslation(Entity entity, Vec3 anchorVec, AbstractContraptionEntity.ContraptionRotationState rotation) {
        return ContraptionCollider.getWorldToLocalTranslation(entity, anchorVec, rotation.asMatrix(), rotation.getYawOffset());
    }

    public static Vec3 getWorldToLocalTranslation(Entity entity, Vec3 anchorVec, Matrix3d rotationMatrix, float yawOffset) {
        Vec3 entityPosition = entity.m_20182_();
        Vec3 centerY = new Vec3(0.0, entity.m_20191_().m_82376_() / 2.0, 0.0);
        Vec3 position = entityPosition;
        position = position.m_82549_(centerY);
        position = position.m_82546_(VecHelper.CENTER_OF_ORIGIN);
        position = position.m_82546_(anchorVec);
        position = VecHelper.rotate(position, -yawOffset, Direction.Axis.Y);
        position = rotationMatrix.transform(position);
        position = position.m_82549_(VecHelper.CENTER_OF_ORIGIN);
        position = position.m_82546_(centerY);
        position = position.m_82546_(entityPosition);
        return position;
    }

    public static Vec3 getWorldToLocalTranslation(Vec3 entity, AbstractContraptionEntity contraptionEntity) {
        return ContraptionCollider.getWorldToLocalTranslation(entity, contraptionEntity.getAnchorVec(), contraptionEntity.getRotationState());
    }

    public static Vec3 getWorldToLocalTranslation(Vec3 inPos, Vec3 anchorVec, AbstractContraptionEntity.ContraptionRotationState rotation) {
        return ContraptionCollider.getWorldToLocalTranslation(inPos, anchorVec, rotation.asMatrix(), rotation.getYawOffset());
    }

    public static Vec3 getWorldToLocalTranslation(Vec3 inPos, Vec3 anchorVec, Matrix3d rotationMatrix, float yawOffset) {
        Vec3 position = inPos;
        position = position.m_82546_(VecHelper.CENTER_OF_ORIGIN);
        position = position.m_82546_(anchorVec);
        position = VecHelper.rotate(position, -yawOffset, Direction.Axis.Y);
        position = rotationMatrix.transform(position);
        position = position.m_82549_(VecHelper.CENTER_OF_ORIGIN);
        position = position.m_82546_(inPos);
        return position;
    }

    static Vec3 collide(Vec3 p_20273_, Entity e) {
        boolean flag3;
        AABB aabb = e.m_20191_();
        List list = e.f_19853_.m_183134_(e, aabb.m_82369_(p_20273_));
        Vec3 vec3 = p_20273_.m_82556_() == 0.0 ? p_20273_ : Entity.m_198894_((Entity)e, (Vec3)p_20273_, (AABB)aabb, (Level)e.f_19853_, (List)list);
        boolean flag = p_20273_.f_82479_ != vec3.f_82479_;
        boolean flag1 = p_20273_.f_82480_ != vec3.f_82480_;
        boolean flag2 = p_20273_.f_82481_ != vec3.f_82481_;
        boolean bl = flag3 = flag1 && p_20273_.f_82480_ < 0.0;
        if (e.getStepHeight() > 0.0f && flag3 && (flag || flag2)) {
            Vec3 vec33;
            Vec3 vec31 = Entity.m_198894_((Entity)e, (Vec3)new Vec3(p_20273_.f_82479_, (double)e.getStepHeight(), p_20273_.f_82481_), (AABB)aabb, (Level)e.f_19853_, (List)list);
            Vec3 vec32 = Entity.m_198894_((Entity)e, (Vec3)new Vec3(0.0, (double)e.getStepHeight(), 0.0), (AABB)aabb.m_82363_(p_20273_.f_82479_, 0.0, p_20273_.f_82481_), (Level)e.f_19853_, (List)list);
            if (vec32.f_82480_ < (double)e.getStepHeight() && (vec33 = Entity.m_198894_((Entity)e, (Vec3)new Vec3(p_20273_.f_82479_, 0.0, p_20273_.f_82481_), (AABB)aabb.m_82383_(vec32), (Level)e.f_19853_, (List)list).m_82549_(vec32)).m_165925_() > vec31.m_165925_()) {
                vec31 = vec33;
            }
            if (vec31.m_165925_() > vec3.m_165925_()) {
                return vec31.m_82549_(Entity.m_198894_((Entity)e, (Vec3)new Vec3(0.0, -vec31.f_82480_ + p_20273_.f_82480_, 0.0), (AABB)aabb.m_82383_(vec31), (Level)e.f_19853_, (List)list));
            }
        }
        return vec3;
    }

    private static PlayerType getPlayerType(Entity entity) {
        if (!(entity instanceof Player)) {
            return PlayerType.NONE;
        }
        if (!entity.f_19853_.f_46443_) {
            return PlayerType.SERVER;
        }
        MutableBoolean isClient = new MutableBoolean(false);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> isClient.setValue(ContraptionCollider.isClientPlayerEntity(entity)));
        return isClient.booleanValue() ? PlayerType.CLIENT : PlayerType.REMOTE;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean isClientPlayerEntity(Entity entity) {
        return entity instanceof LocalPlayer;
    }

    private static List<VoxelShape> getPotentiallyCollidedShapes(Level world, Contraption contraption, AABB localBB) {
        double width;
        double height = localBB.m_82376_();
        double horizontalFactor = height > (width = localBB.m_82362_()) && width != 0.0 ? height / width : 1.0;
        double verticalFactor = width > height && height != 0.0 ? width / height : 1.0;
        AABB blockScanBB = localBB.m_82400_(0.5);
        blockScanBB = blockScanBB.m_82377_(horizontalFactor, verticalFactor, horizontalFactor);
        BlockPos min = new BlockPos(blockScanBB.f_82288_, blockScanBB.f_82289_, blockScanBB.f_82290_);
        BlockPos max = new BlockPos(blockScanBB.f_82291_, blockScanBB.f_82292_, blockScanBB.f_82293_);
        List<VoxelShape> potentialHits = BlockPos.m_121990_((BlockPos)min, (BlockPos)max).filter(contraption.getBlocks()::containsKey).filter((Predicate<BlockPos>)Predicates.not(contraption::isHiddenInPortal)).map(p -> {
            BlockState blockState = contraption.getBlocks().get((Object)p).f_74676_;
            BlockPos pos = contraption.getBlocks().get((Object)p).f_74675_;
            VoxelShape collisionShape = blockState.m_60812_((BlockGetter)world, p);
            return collisionShape.m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        }).filter((Predicate<VoxelShape>)Predicates.not(VoxelShape::m_83281_)).toList();
        return potentialHits;
    }

    public static boolean collideBlocks(AbstractContraptionEntity contraptionEntity) {
        if (!contraptionEntity.supportsTerrainCollision()) {
            return false;
        }
        Level world = contraptionEntity.m_20193_();
        Vec3 motion = contraptionEntity.m_20184_();
        TranslatingContraption contraption = (TranslatingContraption)contraptionEntity.getContraption();
        AABB bounds = contraptionEntity.m_20191_();
        Vec3 position = contraptionEntity.m_20182_();
        BlockPos gridPos = new BlockPos(position);
        if (contraption == null) {
            return false;
        }
        if (bounds == null) {
            return false;
        }
        if (motion.equals((Object)Vec3.f_82478_)) {
            return false;
        }
        Direction movementDirection = Direction.m_122366_((double)motion.f_82479_, (double)motion.f_82480_, (double)motion.f_82481_);
        if (movementDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            gridPos = gridPos.m_121945_(movementDirection);
        }
        if (ContraptionCollider.isCollidingWithWorld(world, contraption, gridPos, movementDirection)) {
            return true;
        }
        for (ControlledContraptionEntity otherContraptionEntity : world.m_6443_(ControlledContraptionEntity.class, bounds.m_82400_(1.0), e -> !e.equals((Object)contraptionEntity))) {
            if (!otherContraptionEntity.supportsTerrainCollision()) continue;
            Vec3 otherMotion = otherContraptionEntity.m_20184_();
            TranslatingContraption otherContraption = (TranslatingContraption)otherContraptionEntity.getContraption();
            AABB otherBounds = otherContraptionEntity.m_20191_();
            Vec3 otherPosition = otherContraptionEntity.m_20182_();
            if (otherContraption == null) {
                return false;
            }
            if (otherBounds == null) {
                return false;
            }
            if (!bounds.m_82383_(motion).m_82381_(otherBounds.m_82383_(otherMotion))) continue;
            for (BlockPos colliderPos : contraption.getColliders(world, movementDirection)) {
                colliderPos = colliderPos.m_121955_((Vec3i)gridPos).m_121996_((Vec3i)new BlockPos(otherPosition));
                if (!otherContraption.getBlocks().containsKey(colliderPos)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCollidingWithWorld(Level world, TranslatingContraption contraption, BlockPos anchor, Direction movementDirection) {
        for (BlockPos pos : contraption.getColliders(world, movementDirection)) {
            BlockPos colliderPos = pos.m_121955_((Vec3i)anchor);
            if (!world.m_46749_(colliderPos)) {
                return true;
            }
            BlockState collidedState = world.m_8055_(colliderPos);
            StructureTemplate.StructureBlockInfo blockInfo = contraption.getBlocks().get(pos);
            boolean emptyCollider = collidedState.m_60812_((BlockGetter)world, pos).m_83281_();
            if (collidedState.m_60734_() instanceof CocoaBlock) continue;
            MovementBehaviour movementBehaviour = AllMovementBehaviours.getBehaviour(blockInfo.f_74676_);
            if (movementBehaviour != null) {
                if (movementBehaviour instanceof BlockBreakingMovementBehaviour) {
                    BlockBreakingMovementBehaviour behaviour = (BlockBreakingMovementBehaviour)movementBehaviour;
                    if (behaviour.canBreak(world, colliderPos, collidedState) || emptyCollider) continue;
                    return true;
                }
                if (movementBehaviour instanceof HarvesterMovementBehaviour) {
                    HarvesterMovementBehaviour harvesterMovementBehaviour = (HarvesterMovementBehaviour)movementBehaviour;
                    if (harvesterMovementBehaviour.isValidCrop(world, colliderPos, collidedState) || harvesterMovementBehaviour.isValidOther(world, colliderPos, collidedState) || emptyCollider) continue;
                    return true;
                }
            }
            if (AllBlocks.PULLEY_MAGNET.has(collidedState) && pos.equals((Object)BlockPos.f_121853_) && movementDirection == Direction.UP || collidedState.m_60767_().m_76336_() || emptyCollider) continue;
            return true;
        }
        return false;
    }

    static enum PlayerType {
        NONE,
        CLIENT,
        REMOTE,
        SERVER;

    }
}

