/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.utility.Lang;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.Collections;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class AllTags {
    public static <T> TagKey<T> optionalTag(IForgeRegistry<T> registry, ResourceLocation id) {
        return registry.tags().createOptionalTagKey(id, Collections.emptySet());
    }

    public static <T> TagKey<T> forgeTag(IForgeRegistry<T> registry, String path) {
        return AllTags.optionalTag(registry, new ResourceLocation("forge", path));
    }

    public static TagKey<Block> forgeBlockTag(String path) {
        return AllTags.forgeTag(ForgeRegistries.BLOCKS, path);
    }

    public static TagKey<Item> forgeItemTag(String path) {
        return AllTags.forgeTag(ForgeRegistries.ITEMS, path);
    }

    public static TagKey<Fluid> forgeFluidTag(String path) {
        return AllTags.forgeTag(ForgeRegistries.FLUIDS, path);
    }

    @Deprecated(forRemoval=true)
    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOrPickaxe() {
        return TagGen.axeOrPickaxe();
    }

    @Deprecated(forRemoval=true)
    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOnly() {
        return TagGen.axeOnly();
    }

    @Deprecated(forRemoval=true)
    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> pickaxeOnly() {
        return TagGen.pickaxeOnly();
    }

    @Deprecated(forRemoval=true)
    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, ItemBuilder<BlockItem, BlockBuilder<T, P>>> tagBlockAndItem(String ... path) {
        return TagGen.tagBlockAndItem(path);
    }

    public static void init() {
        AllBlockTags.init();
        AllItemTags.init();
        AllFluidTags.init();
    }

    public static enum AllBlockTags {
        BRITTLE,
        CASING,
        FAN_TRANSPARENT,
        NON_MOVABLE,
        MOVABLE_EMPTY_COLLIDER,
        ORE_OVERRIDE_STONE,
        PASSIVE_BOILER_HEATERS,
        SAFE_NBT,
        SEATS,
        TOOLBOXES,
        TREE_ATTACHMENTS,
        VALVE_HANDLES,
        WINDMILL_SAILS,
        WRENCH_PICKUP,
        RELOCATION_NOT_SUPPORTED(NameSpace.FORGE),
        WG_STONE(NameSpace.FORGE),
        SLIMY_LOGS(NameSpace.TIC),
        NON_DOUBLE_DOOR(NameSpace.QUARK);

        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;

        private AllBlockTags() {
            this(NameSpace.MOD);
        }

        private AllBlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllBlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId(this.name()) : path);
            this.tag = optional ? AllTags.optionalTag(ForgeRegistries.BLOCKS, id) : BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Block block) {
            return block.m_204297_().m_203656_(this.tag);
        }

        public boolean matches(BlockState state) {
            return state.m_204336_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum AllItemTags {
        BLAZE_BURNER_FUEL_REGULAR(NameSpace.MOD, "blaze_burner_fuel/regular"),
        BLAZE_BURNER_FUEL_SPECIAL(NameSpace.MOD, "blaze_burner_fuel/special"),
        CASING,
        CREATE_INGOTS,
        CRUSHED_ORES,
        MODDED_STRIPPED_LOGS,
        MODDED_STRIPPED_WOOD,
        PRESSURIZED_AIR_SOURCES,
        SANDPAPER,
        SEATS,
        SLEEPERS,
        TOOLBOXES,
        UPRIGHT_ON_BELT,
        VALVE_HANDLES,
        VANILLA_STRIPPED_LOGS,
        VANILLA_STRIPPED_WOOD,
        STRIPPED_LOGS(NameSpace.FORGE),
        STRIPPED_WOOD(NameSpace.FORGE),
        PLATES(NameSpace.FORGE),
        WRENCH(NameSpace.FORGE, "tools/wrench");

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private AllItemTags() {
            this(NameSpace.MOD);
        }

        private AllItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId(this.name()) : path);
            this.tag = optional ? AllTags.optionalTag(ForgeRegistries.ITEMS, id) : ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.m_204114_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum AllFluidTags {
        BOTTOMLESS_ALLOW(NameSpace.MOD, "bottomless/allow"),
        BOTTOMLESS_DENY(NameSpace.MOD, "bottomless/deny"),
        HONEY(NameSpace.FORGE);

        public final TagKey<Fluid> tag;
        public final boolean alwaysDatagen;

        private AllFluidTags() {
            this(NameSpace.MOD);
        }

        private AllFluidTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllFluidTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllFluidTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllFluidTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId(this.name()) : path);
            this.tag = optional ? AllTags.optionalTag(ForgeRegistries.FLUIDS, id) : FluidTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Fluid fluid) {
            return fluid.m_205067_(this.tag);
        }

        public boolean matches(FluidState state) {
            return state.m_205070_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum NameSpace {
        MOD("create", false, true),
        FORGE("forge"),
        TIC("tconstruct"),
        QUARK("quark");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

