/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.DropdownBoxEntry;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DropdownMenuBuilder<T>
extends FieldBuilder<T, DropdownBoxEntry<T>, DropdownMenuBuilder<T>> {
    protected DropdownBoxEntry.SelectionTopCellElement<T> topCellElement;
    protected DropdownBoxEntry.SelectionCellCreator<T> cellCreator;
    protected Function<T, Optional<Component[]>> tooltipSupplier = str -> Optional.empty();
    protected Consumer<T> saveConsumer = null;
    protected Iterable<T> selections = Collections.emptyList();
    protected boolean suggestionMode = true;

    public DropdownMenuBuilder(Component resetButtonKey, Component fieldNameKey, DropdownBoxEntry.SelectionTopCellElement<T> topCellElement, DropdownBoxEntry.SelectionCellCreator<T> cellCreator) {
        super(resetButtonKey, fieldNameKey);
        this.topCellElement = Objects.requireNonNull(topCellElement);
        this.cellCreator = Objects.requireNonNull(cellCreator);
    }

    public DropdownMenuBuilder<T> setSelections(Iterable<T> selections) {
        this.selections = selections;
        return this;
    }

    public DropdownMenuBuilder<T> setDefaultValue(Supplier<T> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public DropdownMenuBuilder<T> setDefaultValue(T defaultValue) {
        this.defaultValue = () -> Objects.requireNonNull(defaultValue);
        return this;
    }

    public DropdownMenuBuilder<T> setSaveConsumer(Consumer<T> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return this;
    }

    public DropdownMenuBuilder<T> setTooltipSupplier(Supplier<Optional<Component[]>> tooltipSupplier) {
        this.tooltipSupplier = str -> (Optional)tooltipSupplier.get();
        return this;
    }

    public DropdownMenuBuilder<T> setTooltipSupplier(Function<T, Optional<Component[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public DropdownMenuBuilder<T> setTooltip(Optional<Component[]> tooltip) {
        this.tooltipSupplier = str -> tooltip;
        return this;
    }

    public DropdownMenuBuilder<T> setTooltip(Component ... tooltip) {
        this.tooltipSupplier = str -> Optional.ofNullable(tooltip);
        return this;
    }

    public DropdownMenuBuilder<T> requireRestart() {
        this.requireRestart(true);
        return this;
    }

    public DropdownMenuBuilder<T> setErrorSupplier(Function<T, Optional<Component>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return this;
    }

    public DropdownMenuBuilder<T> setSuggestionMode(boolean suggestionMode) {
        this.suggestionMode = suggestionMode;
        return this;
    }

    public boolean isSuggestionMode() {
        return this.suggestionMode;
    }

    @Override
    @NotNull
    public DropdownBoxEntry<T> build() {
        DropdownBoxEntry<T> entry = new DropdownBoxEntry<T>(this.getFieldNameKey(), this.getResetButtonKey(), null, this.isRequireRestart(), this.defaultValue, this.saveConsumer, this.selections, this.topCellElement, this.cellCreator);
        entry.setTooltipSupplier(() -> this.tooltipSupplier.apply(entry.getValue()));
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        entry.setSuggestionMode(this.suggestionMode);
        return entry;
    }

    public static class CellCreatorBuilder {
        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of() {
            return new DropdownBoxEntry.DefaultSelectionCellCreator();
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of(Function<T, Component> toTextFunction) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(toTextFunction);
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> ofWidth(final int cellWidth) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(){

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> ofWidth(final int cellWidth, Function<T, Component> toTextFunction) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(toTextFunction){

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> ofCellCount(final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(){

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> ofCellCount(final int maxItems, Function<T, Component> toTextFunction) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(toTextFunction){

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of(final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(){

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of(final int cellWidth, final int maxItems, Function<T, Component> toTextFunction) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(toTextFunction){

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of(final int cellHeight, final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(){

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of(final int cellHeight, final int cellWidth, final int maxItems, Function<T, Component> toTextFunction) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(toTextFunction){

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static DropdownBoxEntry.SelectionCellCreator<ResourceLocation> ofItemIdentifier() {
            return CellCreatorBuilder.ofItemIdentifier(20, 146, 7);
        }

        public static DropdownBoxEntry.SelectionCellCreator<ResourceLocation> ofItemIdentifier(int maxItems) {
            return CellCreatorBuilder.ofItemIdentifier(20, 146, maxItems);
        }

        public static DropdownBoxEntry.SelectionCellCreator<ResourceLocation> ofItemIdentifier(final int cellHeight, final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<ResourceLocation>(){

                @Override
                public DropdownBoxEntry.SelectionCellElement<ResourceLocation> create(ResourceLocation selection) {
                    final ItemStack s = new ItemStack((ItemLike)Registry.f_122827_.m_7745_(selection));
                    return new DropdownBoxEntry.DefaultSelectionCellElement<ResourceLocation>(selection, this.toTextFunction){

                        @Override
                        public void render(PoseStack matrices, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                            boolean b;
                            this.rendering = true;
                            this.x = x;
                            this.y = y;
                            this.width = width;
                            this.height = height;
                            boolean bl = b = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
                            if (b) {
                                CellCreatorBuilder.1.m_93172_((PoseStack)matrices, (int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)-15132391);
                            }
                            Minecraft.m_91087_().f_91062_.m_92744_(matrices, ((Component)this.toTextFunction.apply((ResourceLocation)this.r)).m_7532_(), (float)(x + 6 + 18), (float)(y + 6), b ? 0xFFFFFF : 0x888888);
                            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                            itemRenderer.m_115123_(s, x + 4, y + 2);
                        }
                    };
                }

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static DropdownBoxEntry.SelectionCellCreator<ResourceLocation> ofBlockIdentifier() {
            return CellCreatorBuilder.ofBlockIdentifier(20, 146, 7);
        }

        public static DropdownBoxEntry.SelectionCellCreator<ResourceLocation> ofBlockIdentifier(int maxItems) {
            return CellCreatorBuilder.ofBlockIdentifier(20, 146, maxItems);
        }

        public static DropdownBoxEntry.SelectionCellCreator<ResourceLocation> ofBlockIdentifier(final int cellHeight, final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<ResourceLocation>(){

                @Override
                public DropdownBoxEntry.SelectionCellElement<ResourceLocation> create(ResourceLocation selection) {
                    final ItemStack s = new ItemStack((ItemLike)Registry.f_122824_.m_7745_(selection));
                    return new DropdownBoxEntry.DefaultSelectionCellElement<ResourceLocation>(selection, this.toTextFunction){

                        @Override
                        public void render(PoseStack matrices, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                            boolean b;
                            this.rendering = true;
                            this.x = x;
                            this.y = y;
                            this.width = width;
                            this.height = height;
                            boolean bl = b = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
                            if (b) {
                                1.m_93172_((PoseStack)matrices, (int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)-15132391);
                            }
                            Minecraft.m_91087_().f_91062_.m_92744_(matrices, ((Component)this.toTextFunction.apply((ResourceLocation)this.r)).m_7532_(), (float)(x + 6 + 18), (float)(y + 6), b ? 0xFFFFFF : 0x888888);
                            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                            itemRenderer.m_115123_(s, x + 4, y + 2);
                        }
                    };
                }

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static DropdownBoxEntry.SelectionCellCreator<Item> ofItemObject() {
            return CellCreatorBuilder.ofItemObject(20, 146, 7);
        }

        public static DropdownBoxEntry.SelectionCellCreator<Item> ofItemObject(int maxItems) {
            return CellCreatorBuilder.ofItemObject(20, 146, maxItems);
        }

        public static DropdownBoxEntry.SelectionCellCreator<Item> ofItemObject(final int cellHeight, final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<Item>(i -> Component.m_237113_((String)Registry.f_122827_.m_7981_(i).toString())){

                @Override
                public DropdownBoxEntry.SelectionCellElement<Item> create(Item selection) {
                    final ItemStack s = new ItemStack((ItemLike)selection);
                    return new DropdownBoxEntry.DefaultSelectionCellElement<Item>(selection, this.toTextFunction){

                        @Override
                        public void render(PoseStack matrices, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                            boolean b;
                            this.rendering = true;
                            this.x = x;
                            this.y = y;
                            this.width = width;
                            this.height = height;
                            boolean bl = b = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
                            if (b) {
                                CellCreatorBuilder.1.m_93172_((PoseStack)matrices, (int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)-15132391);
                            }
                            Minecraft.m_91087_().f_91062_.m_92744_(matrices, ((Component)this.toTextFunction.apply((Item)this.r)).m_7532_(), (float)(x + 6 + 18), (float)(y + 6), b ? 0xFFFFFF : 0x888888);
                            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                            itemRenderer.m_115123_(s, x + 4, y + 2);
                        }
                    };
                }

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static DropdownBoxEntry.SelectionCellCreator<Block> ofBlockObject() {
            return CellCreatorBuilder.ofBlockObject(20, 146, 7);
        }

        public static DropdownBoxEntry.SelectionCellCreator<Block> ofBlockObject(int maxItems) {
            return CellCreatorBuilder.ofBlockObject(20, 146, maxItems);
        }

        public static DropdownBoxEntry.SelectionCellCreator<Block> ofBlockObject(final int cellHeight, final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<Block>(i -> Component.m_237113_((String)Registry.f_122824_.m_7981_(i).toString())){

                @Override
                public DropdownBoxEntry.SelectionCellElement<Block> create(Block selection) {
                    final ItemStack s = new ItemStack((ItemLike)selection);
                    return new DropdownBoxEntry.DefaultSelectionCellElement<Block>(selection, this.toTextFunction){

                        @Override
                        public void render(PoseStack matrices, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                            boolean b;
                            this.rendering = true;
                            this.x = x;
                            this.y = y;
                            this.width = width;
                            this.height = height;
                            boolean bl = b = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
                            if (b) {
                                CellCreatorBuilder.1.m_93172_((PoseStack)matrices, (int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)-15132391);
                            }
                            Minecraft.m_91087_().f_91062_.m_92744_(matrices, ((Component)this.toTextFunction.apply((Block)this.r)).m_7532_(), (float)(x + 6 + 18), (float)(y + 6), b ? 0xFFFFFF : 0x888888);
                            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                            itemRenderer.m_115123_(s, x + 4, y + 2);
                        }
                    };
                }

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }
    }

    public static class TopCellElementBuilder {
        public static final Function<String, ResourceLocation> IDENTIFIER_FUNCTION = str -> {
            try {
                return new ResourceLocation(str);
            }
            catch (NumberFormatException e) {
                return null;
            }
        };
        public static final Function<String, ResourceLocation> ITEM_IDENTIFIER_FUNCTION = str -> {
            try {
                ResourceLocation identifier = new ResourceLocation(str);
                if (Registry.f_122827_.m_6612_(identifier).isPresent()) {
                    return identifier;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        };
        public static final Function<String, ResourceLocation> BLOCK_IDENTIFIER_FUNCTION = str -> {
            try {
                ResourceLocation identifier = new ResourceLocation(str);
                if (Registry.f_122824_.m_6612_(identifier).isPresent()) {
                    return identifier;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        };
        public static final Function<String, Item> ITEM_FUNCTION = str -> {
            try {
                return Registry.f_122827_.m_6612_(new ResourceLocation(str)).orElse(null);
            }
            catch (Exception exception) {
                return null;
            }
        };
        public static final Function<String, Block> BLOCK_FUNCTION = str -> {
            try {
                return Registry.f_122824_.m_6612_(new ResourceLocation(str)).orElse(null);
            }
            catch (Exception exception) {
                return null;
            }
        };
        private static final ItemStack BARRIER = new ItemStack((ItemLike)Items.f_42127_);

        public static <T> DropdownBoxEntry.SelectionTopCellElement<T> of(T value, Function<String, T> toObjectFunction) {
            return TopCellElementBuilder.of(value, toObjectFunction, t -> Component.m_237113_((String)t.toString()));
        }

        public static <T> DropdownBoxEntry.SelectionTopCellElement<T> of(T value, Function<String, T> toObjectFunction, Function<T, Component> toTextFunction) {
            return new DropdownBoxEntry.DefaultSelectionTopCellElement<T>(value, toObjectFunction, toTextFunction);
        }

        public static DropdownBoxEntry.SelectionTopCellElement<ResourceLocation> ofItemIdentifier(Item item) {
            return new DropdownBoxEntry.DefaultSelectionTopCellElement<ResourceLocation>(Registry.f_122827_.m_7981_((Object)item), ITEM_IDENTIFIER_FUNCTION, identifier -> Component.m_237113_((String)identifier.toString())){

                @Override
                public void render(PoseStack matrices, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                    this.textFieldWidget.f_93620_ = x + 4;
                    this.textFieldWidget.f_93621_ = y + 6;
                    this.textFieldWidget.m_93674_(width - 4 - 20);
                    this.textFieldWidget.m_94186_(this.getParent().isEditable());
                    this.textFieldWidget.m_94202_(this.getPreferredTextColor());
                    this.textFieldWidget.m_6305_(matrices, mouseX, mouseY, delta);
                    ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                    ItemStack stack = this.hasConfigError() ? BARRIER : new ItemStack((ItemLike)Registry.f_122827_.m_7745_((ResourceLocation)this.getValue()));
                    itemRenderer.m_115123_(stack, x + width - 18, y + 2);
                }
            };
        }

        public static DropdownBoxEntry.SelectionTopCellElement<ResourceLocation> ofBlockIdentifier(Block block) {
            return new DropdownBoxEntry.DefaultSelectionTopCellElement<ResourceLocation>(Registry.f_122824_.m_7981_((Object)block), BLOCK_IDENTIFIER_FUNCTION, identifier -> Component.m_237113_((String)identifier.toString())){

                @Override
                public void render(PoseStack matrices, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                    this.textFieldWidget.f_93620_ = x + 4;
                    this.textFieldWidget.f_93621_ = y + 6;
                    this.textFieldWidget.m_93674_(width - 4 - 20);
                    this.textFieldWidget.m_94186_(this.getParent().isEditable());
                    this.textFieldWidget.m_94202_(this.getPreferredTextColor());
                    this.textFieldWidget.m_6305_(matrices, mouseX, mouseY, delta);
                    ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                    ItemStack stack = this.hasConfigError() ? BARRIER : new ItemStack((ItemLike)Registry.f_122824_.m_7745_((ResourceLocation)this.getValue()));
                    itemRenderer.m_115123_(stack, x + width - 18, y + 2);
                }
            };
        }

        public static DropdownBoxEntry.SelectionTopCellElement<Item> ofItemObject(Item item) {
            return new DropdownBoxEntry.DefaultSelectionTopCellElement<Item>(item, ITEM_FUNCTION, i -> Component.m_237113_((String)Registry.f_122827_.m_7981_(i).toString())){

                @Override
                public void render(PoseStack matrices, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                    this.textFieldWidget.f_93620_ = x + 4;
                    this.textFieldWidget.f_93621_ = y + 6;
                    this.textFieldWidget.m_93674_(width - 4 - 20);
                    this.textFieldWidget.m_94186_(this.getParent().isEditable());
                    this.textFieldWidget.m_94202_(this.getPreferredTextColor());
                    this.textFieldWidget.m_6305_(matrices, mouseX, mouseY, delta);
                    ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                    ItemStack stack = this.hasConfigError() ? BARRIER : new ItemStack((ItemLike)this.getValue());
                    itemRenderer.m_115123_(stack, x + width - 18, y + 2);
                }
            };
        }

        public static DropdownBoxEntry.SelectionTopCellElement<Block> ofBlockObject(Block block) {
            return new DropdownBoxEntry.DefaultSelectionTopCellElement<Block>(block, BLOCK_FUNCTION, i -> Component.m_237113_((String)Registry.f_122824_.m_7981_(i).toString())){

                @Override
                public void render(PoseStack matrices, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                    this.textFieldWidget.f_93620_ = x + 4;
                    this.textFieldWidget.f_93621_ = y + 6;
                    this.textFieldWidget.m_93674_(width - 4 - 20);
                    this.textFieldWidget.m_94186_(this.getParent().isEditable());
                    this.textFieldWidget.m_94202_(this.getPreferredTextColor());
                    this.textFieldWidget.m_6305_(matrices, mouseX, mouseY, delta);
                    ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                    ItemStack stack = this.hasConfigError() ? BARRIER : new ItemStack((ItemLike)this.getValue());
                    itemRenderer.m_115123_(stack, x + width - 18, y + 2);
                }
            };
        }
    }
}

