/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.PngInfo;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.StitcherException;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.inventory.InventoryMenu;
import net.optifine.Config;
import net.optifine.EmissiveTextures;
import net.optifine.SmartAnimations;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorMethod;
import net.optifine.shaders.ITextureFormat;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersTex;
import net.optifine.shaders.ShadersTextureType;
import net.optifine.texture.ColorBlenderLinear;
import net.optifine.texture.IColorBlender;
import net.optifine.util.CounterInt;
import net.optifine.util.TextureUtils;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextureAtlas
extends AbstractTexture
implements Tickable {
    private static final Logger f_118261_ = LogUtils.getLogger();
    @Deprecated
    public static final ResourceLocation f_118259_ = InventoryMenu.f_39692_;
    @Deprecated
    public static final ResourceLocation f_118260_ = new ResourceLocation("textures/atlas/particles.png");
    private static final String f_174697_ = ".png";
    private final List<Tickable> f_118262_ = Lists.newArrayList();
    private final Set<ResourceLocation> f_118263_ = Sets.newHashSet();
    private final Map<ResourceLocation, TextureAtlasSprite> f_118264_ = Maps.newHashMap();
    private final ResourceLocation f_118265_;
    private final int f_118266_;
    private Map<ResourceLocation, TextureAtlasSprite> mapRegisteredSprites = new LinkedHashMap();
    private Map<ResourceLocation, TextureAtlasSprite> mapMissingSprites = new LinkedHashMap();
    private TextureAtlasSprite[] iconGrid = null;
    private int iconGridSize = -1;
    private int iconGridCountX = -1;
    private int iconGridCountY = -1;
    private double iconGridSizeU = -1.0;
    private double iconGridSizeV = -1.0;
    private CounterInt counterIndexInMap = new CounterInt(0);
    public int atlasWidth = 0;
    public int atlasHeight = 0;
    public int mipmapLevel = 0;
    private int countAnimationsActive;
    private int frameCountAnimations;
    private boolean terrain;
    private boolean shaders;
    private boolean multiTexture;
    private ITextureFormat textureFormat;

    public TextureAtlas(ResourceLocation textureLocationIn) {
        this.f_118265_ = textureLocationIn;
        this.f_118266_ = RenderSystem.m_69839_();
        this.terrain = textureLocationIn.equals((Object)f_118259_);
        this.shaders = Config.isShaders();
        this.multiTexture = Config.isMultiTexture();
        if (this.terrain) {
            Config.setTextureMap((TextureAtlas)this);
        }
    }

    public void m_6704_(ResourceManager manager) {
    }

    public void m_118312_(Preparations sheetDataIn) {
        List listSprites;
        this.f_118263_.clear();
        this.f_118263_.addAll(sheetDataIn.f_118331_);
        f_118261_.info("Created: {}x{}x{} {}-atlas", new Object[]{sheetDataIn.f_118332_, sheetDataIn.f_118333_, sheetDataIn.f_118334_, this.f_118265_});
        TextureUtil.m_85287_((int)this.m_117963_(), (int)sheetDataIn.f_118334_, (int)sheetDataIn.f_118332_, (int)sheetDataIn.f_118333_);
        this.atlasWidth = sheetDataIn.f_118332_;
        this.atlasHeight = sheetDataIn.f_118333_;
        this.mipmapLevel = sheetDataIn.f_118334_;
        if (this.shaders) {
            ShadersTex.allocateTextureMapNS((int)sheetDataIn.f_118334_, (int)sheetDataIn.f_118332_, (int)sheetDataIn.f_118333_, (TextureAtlas)this);
        }
        this.m_118329_();
        for (TextureAtlasSprite textureatlassprite : sheetDataIn.f_118335_) {
            this.f_118264_.put(textureatlassprite.m_118413_(), textureatlassprite);
            try {
                textureatlassprite.m_118416_();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Stitching texture atlas");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Texture being stitched together");
                crashreportcategory.m_128159_("Atlas path", (Object)this.f_118265_);
                crashreportcategory.m_128159_("Sprite", (Object)textureatlassprite);
                throw new ReportedException(crashreport);
            }
            Tickable tickable = textureatlassprite.m_174746_();
            if (tickable == null) continue;
            textureatlassprite.setAnimationIndex(this.f_118262_.size());
            this.f_118262_.add(tickable);
        }
        TextureUtils.refreshCustomSprites((TextureAtlas)this);
        Config.log((String)("Animated sprites: " + this.f_118262_.size()));
        if (Config.isMultiTexture()) {
            listSprites = sheetDataIn.f_118335_;
            for (TextureAtlasSprite tas : listSprites) {
                TextureAtlas.uploadMipmapsSingle((TextureAtlasSprite)tas);
                if (tas.spriteNormal != null) {
                    TextureAtlas.uploadMipmapsSingle((TextureAtlasSprite)tas.spriteNormal);
                }
                if (tas.spriteSpecular == null) continue;
                TextureAtlas.uploadMipmapsSingle((TextureAtlasSprite)tas.spriteSpecular);
            }
            GlStateManager.m_84544_((int)this.m_117963_());
        }
        if (Config.isShaders()) {
            listSprites = sheetDataIn.f_118335_;
            if (Shaders.configNormalMap) {
                GlStateManager.m_84544_((int)this.getMultiTexID().norm);
                for (TextureAtlasSprite tas : listSprites) {
                    TextureAtlasSprite spriteNormal = tas.spriteNormal;
                    if (spriteNormal == null) continue;
                    spriteNormal.m_118416_();
                }
            }
            if (Shaders.configSpecularMap) {
                GlStateManager.m_84544_((int)this.getMultiTexID().spec);
                for (TextureAtlasSprite tas : listSprites) {
                    TextureAtlasSprite spriteSpecular = tas.spriteSpecular;
                    if (spriteSpecular == null) continue;
                    spriteSpecular.m_118416_();
                }
            }
            GlStateManager.m_84544_((int)this.m_117963_());
        }
        Reflector.callVoid((ReflectorMethod)Reflector.ForgeHooksClient_onTextureStitchedPost, (Object[])new Object[]{this});
        this.updateIconGrid(sheetDataIn.f_118332_, sheetDataIn.f_118333_);
        if (Config.equals((Object)System.getProperty("saveTextureMap"), (Object)"true")) {
            Config.dbg((String)("Exporting texture map: " + this.f_118265_));
            TextureUtils.saveGlTexture((String)("debug/" + this.f_118265_.m_135815_().replaceAll("/", "_")), (int)this.m_117963_(), (int)sheetDataIn.f_118334_, (int)sheetDataIn.f_118332_, (int)sheetDataIn.f_118333_);
            if (this.shaders) {
                if (Shaders.configNormalMap) {
                    TextureUtils.saveGlTexture((String)("debug/" + this.f_118265_.m_135815_().replaceAll("/", "_").replace(".png", "_n.png")), (int)this.multiTex.norm, (int)sheetDataIn.f_118334_, (int)sheetDataIn.f_118332_, (int)sheetDataIn.f_118333_);
                }
                if (Shaders.configSpecularMap) {
                    TextureUtils.saveGlTexture((String)("debug/" + this.f_118265_.m_135815_().replaceAll("/", "_").replace(".png", "_s.png")), (int)this.multiTex.spec, (int)sheetDataIn.f_118334_, (int)sheetDataIn.f_118332_, (int)sheetDataIn.f_118333_);
                }
                GlStateManager.m_84544_((int)this.m_117963_());
            }
        }
    }

    public Preparations m_118307_(ResourceManager resourceManagerIn, Stream<ResourceLocation> resourceLocationsIn, ProfilerFiller profilerIn, int maxMipmapLevelIn) {
        int k1;
        int minSpriteSize;
        this.terrain = this.f_118265_.equals((Object)f_118259_);
        this.shaders = Config.isShaders();
        this.multiTexture = Config.isMultiTexture();
        this.textureFormat = ITextureFormat.readConfiguration();
        int mipmapLevels = maxMipmapLevelIn;
        this.mapRegisteredSprites.clear();
        this.mapMissingSprites.clear();
        this.counterIndexInMap.reset();
        profilerIn.m_6180_("preparing");
        Set set = resourceLocationsIn.peek(locIn -> {
            if (locIn == null) {
                throw new IllegalArgumentException("Location cannot be null!");
            }
        }).collect(Collectors.toSet());
        Config.dbg((String)("Multitexture: " + Config.isMultiTexture()));
        TextureUtils.registerCustomSpriteLocations((ResourceLocation)this.m_118330_(), set);
        TextureUtils.registerCustomSprites((TextureAtlas)this);
        set.addAll(this.mapRegisteredSprites.keySet());
        Set locsEmissive = TextureAtlas.newHashSet(set, this.mapRegisteredSprites.keySet());
        EmissiveTextures.updateIcons((TextureAtlas)this, (Set)locsEmissive);
        set.addAll(this.mapRegisteredSprites.keySet());
        if (mipmapLevels >= 4) {
            mipmapLevels = this.detectMaxMipmapLevel(set, resourceManagerIn);
            Config.log((String)("Mipmap levels: " + mipmapLevels));
        }
        int i2 = TextureUtils.getGLMaximumTextureSize();
        Stitcher stitcher = new Stitcher(i2, i2, maxMipmapLevelIn);
        int j2 = Integer.MAX_VALUE;
        this.iconGridSize = minSpriteSize = TextureAtlas.getMinSpriteSize((int)mipmapLevels);
        int k2 = 1 << maxMipmapLevelIn;
        profilerIn.m_6182_("extracting_frames");
        Reflector.callVoid((ReflectorMethod)Reflector.ForgeHooksClient_onTextureStitchedPre, (Object[])new Object[]{this, set});
        for (TextureAtlasSprite.Info textureatlassprite$info : this.m_118304_(resourceManagerIn, set)) {
            int ws = textureatlassprite$info.m_118434_();
            int hs = textureatlassprite$info.m_118437_();
            if (ws < 1 || hs < 1) {
                Config.warn((String)("Invalid sprite size: " + textureatlassprite$info.m_118431_()));
                continue;
            }
            if (ws < minSpriteSize || mipmapLevels > 0) {
                int ws2;
                int n2 = ws2 = mipmapLevels > 0 ? TextureUtils.scaleToGrid((int)ws, (int)minSpriteSize) : TextureUtils.scaleToMin((int)ws, (int)minSpriteSize);
                if (ws2 != ws) {
                    if (!TextureUtils.isPowerOfTwo((int)ws)) {
                        Config.log((String)("Scaled non power of 2: " + textureatlassprite$info.m_118431_() + ", " + ws + " -> " + ws2));
                    } else {
                        Config.log((String)("Scaled too small texture: " + textureatlassprite$info.m_118431_() + ", " + ws + " -> " + ws2));
                    }
                    int hs2 = hs * ws2 / ws;
                    double scaleFactor = (double)ws2 * 1.0 / (double)ws;
                    textureatlassprite$info.setSpriteWidth(ws2);
                    textureatlassprite$info.setSpriteHeight(hs2);
                    textureatlassprite$info.setScaleFactor(scaleFactor);
                    AnimationMetadataSection anim = textureatlassprite$info.getSpriteAnimationMetadata();
                    if (anim != null) {
                        int frameHeight;
                        int frameWidth = anim.m_119031_(-1);
                        if (frameWidth > 0) {
                            anim.setFrameWidth((int)((double)frameWidth * scaleFactor));
                        }
                        if ((frameHeight = anim.m_119026_(-1)) > 0) {
                            anim.setFrameHeight((int)((double)frameHeight * scaleFactor));
                        }
                    }
                }
            }
            j2 = Math.min(j2, Math.min(textureatlassprite$info.m_118434_(), textureatlassprite$info.m_118437_()));
            int l2 = Math.min(Integer.lowestOneBit(textureatlassprite$info.m_118434_()), Integer.lowestOneBit(textureatlassprite$info.m_118437_()));
            if (l2 < k2) {
                f_118261_.warn("Texture {} with size {}x{} limits mip level from {} to {}", new Object[]{textureatlassprite$info.m_118431_(), textureatlassprite$info.m_118434_(), textureatlassprite$info.m_118437_(), Mth.m_14173_((int)k2), Mth.m_14173_((int)l2)});
                k2 = l2;
            }
            stitcher.m_118185_(textureatlassprite$info);
        }
        int i1 = Math.min(j2, k2);
        int j1 = Mth.m_14173_((int)i1);
        if (j1 < 0) {
            j1 = 0;
        }
        if (j1 < maxMipmapLevelIn) {
            f_118261_.warn("{}: dropping miplevel from {} to {}, because of minimum power of two: {}", new Object[]{this.f_118265_, maxMipmapLevelIn, j1, i1});
            k1 = j1;
        } else {
            k1 = maxMipmapLevelIn;
        }
        profilerIn.m_6182_("register");
        TextureAtlasSprite.Info missingInfo = TextureAtlas.fixSpriteSize((TextureAtlasSprite.Info)MissingTextureAtlasSprite.m_118079_(), (int)minSpriteSize);
        stitcher.m_118185_(missingInfo);
        profilerIn.m_6182_("stitching");
        try {
            stitcher.m_118193_();
        }
        catch (StitcherException stitcherexception) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)stitcherexception, (String)"Stitching");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Stitcher");
            crashreportcategory.m_128159_("Sprites", (Object)stitcherexception.m_118258_().stream().map(p_241734_0_ -> String.format(Locale.ROOT, "%s[%dx%d]", p_241734_0_.m_118431_(), p_241734_0_.m_118434_(), p_241734_0_.m_118437_())).collect(Collectors.joining(",")));
            crashreportcategory.m_128159_("Max Texture Size", (Object)i2);
            throw new ReportedException(crashreport);
        }
        profilerIn.m_6182_("loading");
        List list = this.m_118283_(resourceManagerIn, stitcher, k1);
        profilerIn.m_7238_();
        return new Preparations(set, stitcher.m_118174_(), stitcher.m_118187_(), k1, list);
    }

    private Collection<TextureAtlasSprite.Info> m_118304_(ResourceManager resourceManagerIn, Set<ResourceLocation> spriteLocationsIn) {
        ArrayList list = Lists.newArrayList();
        ConcurrentLinkedQueue<TextureAtlasSprite.Info> queue = new ConcurrentLinkedQueue<TextureAtlasSprite.Info>();
        for (ResourceLocation resourcelocation : spriteLocationsIn) {
            if (MissingTextureAtlasSprite.m_118071_().equals((Object)resourcelocation)) continue;
            list.add(CompletableFuture.runAsync(() -> {
                ResourceLocation resourcelocation1 = this.m_118324_(resourcelocation);
                Optional optional = resourceManagerIn.m_213713_(resourcelocation1);
                if (optional.isEmpty()) {
                    f_118261_.error("Using missing texture, file {} not found", (Object)resourcelocation1);
                } else {
                    AnimationMetadataSection animationmetadatasection;
                    PngInfo pnginfo;
                    Resource resource = (Resource)optional.get();
                    try (InputStream inputstream = resource.m_215507_();){
                        pnginfo = new PngInfo(() -> ((ResourceLocation)resourcelocation1).toString(), inputstream);
                    }
                    catch (IOException ioexception) {
                        f_118261_.error("Using missing texture, unable to load {} : {}", (Object)resourcelocation1, (Object)ioexception);
                        this.onSpriteMissing(resourcelocation);
                        return;
                    }
                    try {
                        animationmetadatasection = resource.m_215509_().m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_).orElse(AnimationMetadataSection.f_119012_);
                    }
                    catch (Exception exception) {
                        f_118261_.error("Unable to parse metadata from {} : {}", (Object)resourcelocation1, (Object)exception);
                        this.onSpriteMissing(resourcelocation);
                        return;
                    }
                    Pair pair = animationmetadatasection.m_7117_(pnginfo.f_85207_, pnginfo.f_85208_);
                    TextureAtlasSprite.Info textureatlassprite$info = new TextureAtlasSprite.Info(resourcelocation, ((Integer)pair.getFirst()).intValue(), ((Integer)pair.getSecond()).intValue(), animationmetadatasection);
                    queue.add(textureatlassprite$info);
                }
            }, Util.m_183991_()));
        }
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).join();
        return queue;
    }

    private List<TextureAtlasSprite> m_118283_(ResourceManager resourceManagerIn, Stitcher stitcherIn, int mipmapLevelIn) {
        ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue();
        ArrayList list = Lists.newArrayList();
        stitcherIn.m_118180_((p_174698_5_, p_174698_6_, p_174698_7_, p_174698_8_, p_174698_9_) -> {
            if (p_174698_5_.m_118431_().equals((Object)MissingTextureAtlasSprite.m_118079_().m_118431_())) {
                MissingTextureAtlasSprite missingtextureatlassprite = new MissingTextureAtlasSprite(this, p_174698_5_, mipmapLevelIn, p_174698_6_, p_174698_7_, p_174698_8_, p_174698_9_);
                missingtextureatlassprite.update(resourceManagerIn);
                queue.add(missingtextureatlassprite);
            } else {
                list.add(CompletableFuture.runAsync(() -> {
                    TextureAtlasSprite textureatlassprite = this.m_118287_(resourceManagerIn, p_174698_5_, p_174698_6_, p_174698_7_, mipmapLevelIn, p_174698_8_, p_174698_9_);
                    if (textureatlassprite != null) {
                        queue.add(textureatlassprite);
                    }
                }, Util.m_183991_()));
            }
        });
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).join();
        return Lists.newArrayList(queue);
    }

    @Nullable
    private TextureAtlasSprite m_118287_(ResourceManager resourceManagerIn, TextureAtlasSprite.Info spriteInfoIn, int widthIn, int heightIn, int mipmapLevelIn, int originX, int originY) {
        ResourceLocation resourcelocation = this.m_118324_(spriteInfoIn.m_118431_());
        try {
            Resource resource = resourceManagerIn.m_215593_(resourcelocation);
            TextureAtlasSprite textureatlassprite = null;
            try (InputStream inputstream = resource.m_215507_();){
                NativeImage nativeimage = NativeImage.m_85058_((InputStream)inputstream);
                if (Reflector.ForgeHooksClient_loadTextureAtlasSprite.exists()) {
                    textureatlassprite = (TextureAtlasSprite)Reflector.ForgeHooksClient_loadTextureAtlasSprite.call(new Object[]{this, resourceManagerIn, spriteInfoIn, resource, widthIn, heightIn, originX, originY, mipmapLevelIn, nativeimage});
                }
                if (textureatlassprite == null) {
                    textureatlassprite = new TextureAtlasSprite(this, spriteInfoIn, mipmapLevelIn, widthIn, heightIn, originX, originY, nativeimage);
                }
                textureatlassprite.update(resourceManagerIn);
            }
            return textureatlassprite;
        }
        catch (RuntimeException runtimeexception) {
            f_118261_.error("Unable to parse metadata from {}", (Object)resourcelocation, (Object)runtimeexception);
            return null;
        }
        catch (IOException ioexception) {
            f_118261_.error("Using missing texture, unable to load {}", (Object)resourcelocation, (Object)ioexception);
            return null;
        }
    }

    public ResourceLocation m_118324_(ResourceLocation location) {
        if (this.isAbsoluteLocation(location)) {
            return new ResourceLocation(location.m_135827_(), location.m_135815_() + ".png");
        }
        return new ResourceLocation(location.m_135827_(), String.format(Locale.ROOT, "textures/%s%s", location.m_135815_(), ".png"));
    }

    public void m_118270_() {
        TextureAtlasSprite textureatlassprite;
        boolean hasNormal = false;
        boolean hasSpecular = false;
        if (!this.f_118262_.isEmpty()) {
            this.m_117966_();
        }
        int countActive = 0;
        for (Tickable tickable : this.f_118262_) {
            if (tickable instanceof TextureAtlasSprite.AnimatedTexture) {
                textureatlassprite = ((TextureAtlasSprite.AnimatedTexture)tickable).getSprite();
                if (!this.isAnimationEnabled(textureatlassprite)) continue;
                tickable.m_7673_();
                if (textureatlassprite.isAnimationActive()) {
                    ++countActive;
                }
                if (textureatlassprite.spriteNormal != null) {
                    hasNormal = true;
                }
                if (textureatlassprite.spriteSpecular == null) continue;
                hasSpecular = true;
                continue;
            }
            tickable.m_7673_();
        }
        if (Config.isShaders()) {
            if (hasNormal) {
                GlStateManager.m_84544_((int)this.getMultiTexID().norm);
                for (Tickable tickable : this.f_118262_) {
                    if (!(tickable instanceof TextureAtlasSprite.AnimatedTexture)) continue;
                    textureatlassprite = ((TextureAtlasSprite.AnimatedTexture)tickable).getSprite();
                    if (textureatlassprite.spriteNormal == null || !this.isAnimationEnabled(textureatlassprite) || !textureatlassprite.isAnimationActive()) continue;
                    textureatlassprite.spriteNormal.updateAnimation();
                    if (!textureatlassprite.spriteNormal.isAnimationActive()) continue;
                    ++countActive;
                }
            }
            if (hasSpecular) {
                GlStateManager.m_84544_((int)this.getMultiTexID().spec);
                for (Tickable tickable : this.f_118262_) {
                    if (!(tickable instanceof TextureAtlasSprite.AnimatedTexture)) continue;
                    textureatlassprite = ((TextureAtlasSprite.AnimatedTexture)tickable).getSprite();
                    if (textureatlassprite.spriteSpecular == null || !this.isAnimationEnabled(textureatlassprite) || !textureatlassprite.isAnimationActive()) continue;
                    textureatlassprite.spriteSpecular.updateAnimation();
                    if (!textureatlassprite.spriteSpecular.isAnimationActive()) continue;
                    ++countActive;
                }
            }
            if (hasNormal || hasSpecular) {
                GlStateManager.m_84544_((int)this.m_117963_());
            }
        }
        if (Config.isMultiTexture()) {
            for (Tickable tickable : this.f_118262_) {
                TextureAtlasSprite ts;
                if (!(tickable instanceof TextureAtlasSprite.AnimatedTexture) || !this.isAnimationEnabled(ts = ((TextureAtlasSprite.AnimatedTexture)tickable).getSprite()) || !ts.isAnimationActive()) continue;
                countActive += TextureAtlas.updateAnimationSingle((TextureAtlasSprite)ts);
                if (ts.spriteNormal != null) {
                    countActive += TextureAtlas.updateAnimationSingle((TextureAtlasSprite)ts.spriteNormal);
                }
                if (ts.spriteSpecular == null) continue;
                countActive += TextureAtlas.updateAnimationSingle((TextureAtlasSprite)ts.spriteSpecular);
            }
            GlStateManager.m_84544_((int)this.m_117963_());
        }
        if (this.terrain) {
            int frameCount = Config.getMinecraft().f_91060_.getFrameCount();
            if (frameCount != this.frameCountAnimations) {
                this.countAnimationsActive = countActive;
                this.frameCountAnimations = frameCount;
            }
            if (SmartAnimations.isActive()) {
                SmartAnimations.resetSpritesRendered((TextureAtlas)this);
            }
        }
    }

    public void m_7673_() {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(() -> this.m_118270_());
        } else {
            this.m_118270_();
        }
    }

    public TextureAtlasSprite m_118316_(ResourceLocation location) {
        TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.f_118264_.get(location);
        return textureatlassprite == null ? (TextureAtlasSprite)this.f_118264_.get(MissingTextureAtlasSprite.m_118071_()) : textureatlassprite;
    }

    public void m_118329_() {
        for (TextureAtlasSprite textureatlassprite : this.f_118264_.values()) {
            textureatlassprite.close();
        }
        if (this.multiTexture) {
            for (TextureAtlasSprite ts : this.f_118264_.values()) {
                ts.deleteSpriteTexture();
                if (ts.spriteNormal != null) {
                    ts.spriteNormal.deleteSpriteTexture();
                }
                if (ts.spriteSpecular == null) continue;
                ts.spriteSpecular.deleteSpriteTexture();
            }
        }
        this.f_118264_.clear();
        this.f_118262_.clear();
    }

    public ResourceLocation m_118330_() {
        return this.f_118265_;
    }

    public void m_118322_(Preparations sheetDataIn) {
        this.m_117960_(false, sheetDataIn.f_118334_ > 0);
    }

    private boolean isAbsoluteLocation(ResourceLocation loc) {
        String path = loc.m_135815_();
        return this.isAbsoluteLocationPath(path);
    }

    private boolean isAbsoluteLocationPath(String resPath) {
        String path = resPath.toLowerCase();
        return path.startsWith("optifine/");
    }

    public TextureAtlasSprite getRegisteredSprite(String name) {
        ResourceLocation loc = new ResourceLocation(name);
        return this.getRegisteredSprite(loc);
    }

    public TextureAtlasSprite getRegisteredSprite(ResourceLocation loc) {
        return (TextureAtlasSprite)this.mapRegisteredSprites.get(loc);
    }

    public TextureAtlasSprite getUploadedSprite(String name) {
        ResourceLocation loc = new ResourceLocation(name);
        return this.getUploadedSprite(loc);
    }

    public TextureAtlasSprite getUploadedSprite(ResourceLocation loc) {
        return (TextureAtlasSprite)this.f_118264_.get(loc);
    }

    private boolean isAnimationEnabled(TextureAtlasSprite ts) {
        if (!this.terrain) {
            return true;
        }
        if (ts == TextureUtils.iconWaterStill || ts == TextureUtils.iconWaterFlow) {
            return Config.isAnimatedWater();
        }
        if (ts == TextureUtils.iconLavaStill || ts == TextureUtils.iconLavaFlow) {
            return Config.isAnimatedLava();
        }
        if (ts == TextureUtils.iconFireLayer0 || ts == TextureUtils.iconFireLayer1) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconSoulFireLayer0 || ts == TextureUtils.iconSoulFireLayer1) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconCampFire || ts == TextureUtils.iconCampFireLogLit) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconSoulCampFire || ts == TextureUtils.iconSoulCampFireLogLit) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconPortal) {
            return Config.isAnimatedPortal();
        }
        return Config.isAnimatedTerrain();
    }

    private static void uploadMipmapsSingle(TextureAtlasSprite tas) {
        TextureAtlasSprite ss = tas.spriteSingle;
        if (ss != null) {
            ss.setAnimationIndex(tas.getAnimationIndex());
            tas.bindSpriteTexture();
            try {
                ss.m_118416_();
            }
            catch (Exception e2) {
                Config.dbg((String)("Error uploading sprite single: " + ss + ", parent: " + tas));
                e2.printStackTrace();
            }
        }
    }

    private static int updateAnimationSingle(TextureAtlasSprite tas) {
        TextureAtlasSprite spriteSingle = tas.spriteSingle;
        if (spriteSingle != null) {
            tas.bindSpriteTexture();
            NativeImage.setUpdateBlurMipmap((boolean)false);
            spriteSingle.updateAnimation();
            NativeImage.setUpdateBlurMipmap((boolean)true);
            if (spriteSingle.isAnimationActive()) {
                return 1;
            }
        }
        return 0;
    }

    public int getCountRegisteredSprites() {
        return this.counterIndexInMap.getValue();
    }

    private int detectMaxMipmapLevel(Set<ResourceLocation> setSpriteLocations, ResourceManager rm) {
        int minLevel;
        int minSize = this.detectMinimumSpriteSize(setSpriteLocations, rm, 20);
        if (minSize < 16) {
            minSize = 16;
        }
        if ((minSize = Mth.m_14125_((int)minSize)) > 16) {
            Config.log((String)("Sprite size: " + minSize));
        }
        if ((minLevel = Mth.m_14173_((int)minSize)) < 4) {
            minLevel = 4;
        }
        return minLevel;
    }

    private int detectMinimumSpriteSize(Set<ResourceLocation> setSpriteLocations, ResourceManager rm, int percentScale) {
        int count;
        HashMap<Integer, Integer> mapSizeCounts = new HashMap<Integer, Integer>();
        for (ResourceLocation loc : setSpriteLocations) {
            ResourceLocation locComplete = this.m_118324_(loc);
            try {
                InputStream in;
                Resource res = rm.m_215593_(locComplete);
                if (res == null || (in = res.m_215507_()) == null) continue;
                Dimension dim = TextureUtils.getImageSize((InputStream)in, (String)"png");
                in.close();
                if (dim == null) continue;
                int width = dim.width;
                int width2 = Mth.m_14125_((int)width);
                if (!mapSizeCounts.containsKey(width2)) {
                    mapSizeCounts.put(width2, 1);
                    continue;
                }
                count = (Integer)mapSizeCounts.get(width2);
                mapSizeCounts.put(width2, count + 1);
            }
            catch (Exception e2) {}
        }
        int countSprites = 0;
        Set setSizes = mapSizeCounts.keySet();
        TreeSet setSizesSorted = new TreeSet(setSizes);
        Iterator it = setSizesSorted.iterator();
        while (it.hasNext()) {
            int size = (Integer)it.next();
            int count2 = (Integer)mapSizeCounts.get(size);
            countSprites += count2;
        }
        int minSize = 16;
        int countScale = 0;
        int countScaleMax = countSprites * percentScale / 100;
        Iterator it2 = setSizesSorted.iterator();
        while (it2.hasNext()) {
            int size = (Integer)it2.next();
            count = (Integer)mapSizeCounts.get(size);
            countScale += count;
            if (size > minSize) {
                minSize = size;
            }
            if (countScale <= countScaleMax) continue;
            return minSize;
        }
        return minSize;
    }

    private static int getMinSpriteSize(int mipmapLevels) {
        int minSize = 1 << mipmapLevels;
        if (minSize < 8) {
            minSize = 8;
        }
        return minSize;
    }

    private static TextureAtlasSprite.Info fixSpriteSize(TextureAtlasSprite.Info info, int minSpriteSize) {
        if (info.m_118434_() >= minSpriteSize && info.m_118437_() >= minSpriteSize) {
            return info;
        }
        int widthNew = Math.max(info.m_118434_(), minSpriteSize);
        int heightNew = Math.max(info.m_118437_(), minSpriteSize);
        TextureAtlasSprite.Info infoNew = new TextureAtlasSprite.Info(info.m_118431_(), widthNew, heightNew, info.getSpriteAnimationMetadata());
        return infoNew;
    }

    public boolean isTextureBound() {
        int texId;
        int boundTexId = GlStateManager.getBoundTexture();
        return boundTexId == (texId = this.m_117963_());
    }

    private void updateIconGrid(int sheetWidth, int sheetHeight) {
        this.iconGridCountX = -1;
        this.iconGridCountY = -1;
        this.iconGrid = null;
        if (this.iconGridSize <= 0) {
            return;
        }
        this.iconGridCountX = sheetWidth / this.iconGridSize;
        this.iconGridCountY = sheetHeight / this.iconGridSize;
        this.iconGrid = new TextureAtlasSprite[this.iconGridCountX * this.iconGridCountY];
        this.iconGridSizeU = 1.0 / (double)this.iconGridCountX;
        this.iconGridSizeV = 1.0 / (double)this.iconGridCountY;
        for (TextureAtlasSprite ts : this.f_118264_.values()) {
            double deltaU = 0.5 / (double)sheetWidth;
            double deltaV = 0.5 / (double)sheetHeight;
            double uMin = (double)Math.min(ts.m_118409_(), ts.m_118410_()) + deltaU;
            double vMin = (double)Math.min(ts.m_118411_(), ts.m_118412_()) + deltaV;
            double uMax = (double)Math.max(ts.m_118409_(), ts.m_118410_()) - deltaU;
            double vMax = (double)Math.max(ts.m_118411_(), ts.m_118412_()) - deltaV;
            int iuMin = (int)(uMin / this.iconGridSizeU);
            int ivMin = (int)(vMin / this.iconGridSizeV);
            int iuMax = (int)(uMax / this.iconGridSizeU);
            int ivMax = (int)(vMax / this.iconGridSizeV);
            for (int iu = iuMin; iu <= iuMax; ++iu) {
                if (iu < 0 || iu >= this.iconGridCountX) {
                    Config.warn((String)("Invalid grid U: " + iu + ", icon: " + ts.m_118413_()));
                    continue;
                }
                for (int iv = ivMin; iv <= ivMax; ++iv) {
                    if (iv < 0 || iv >= this.iconGridCountX) {
                        Config.warn((String)("Invalid grid V: " + iv + ", icon: " + ts.m_118413_()));
                        continue;
                    }
                    int index = iv * this.iconGridCountX + iu;
                    this.iconGrid[index] = ts;
                }
            }
        }
    }

    public TextureAtlasSprite getIconByUV(double u, double v) {
        if (this.iconGrid == null) {
            return null;
        }
        int iv = (int)(v / this.iconGridSizeV);
        int iu = (int)(u / this.iconGridSizeU);
        int index = iv * this.iconGridCountX + iu;
        if (index < 0 || index > this.iconGrid.length) {
            return null;
        }
        return this.iconGrid[index];
    }

    public int getCountAnimations() {
        return this.f_118262_.size();
    }

    public int getCountAnimationsActive() {
        return this.countAnimationsActive;
    }

    public TextureAtlasSprite registerSprite(ResourceLocation location) {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null!");
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)this.mapRegisteredSprites.get(location);
        if (sprite != null) {
            return sprite;
        }
        this.f_118263_.add(location);
        sprite = new TextureAtlasSprite(location);
        this.mapRegisteredSprites.put(location, sprite);
        sprite.updateIndexInMap(this.counterIndexInMap);
        return sprite;
    }

    public Collection<TextureAtlasSprite> getRegisteredSprites() {
        return Collections.unmodifiableCollection(this.mapRegisteredSprites.values());
    }

    public boolean isTerrain() {
        return this.terrain;
    }

    public CounterInt getCounterIndexInMap() {
        return this.counterIndexInMap;
    }

    private void onSpriteMissing(ResourceLocation loc) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)this.mapRegisteredSprites.get(loc);
        if (sprite == null) {
            return;
        }
        this.mapMissingSprites.put(loc, sprite);
    }

    private static <T> Set<T> newHashSet(Set<T> set1, Set<T> set2) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(set1);
        set.addAll(set2);
        return set;
    }

    public int getMipmapLevel() {
        return this.mipmapLevel;
    }

    public boolean isMipmaps() {
        return this.mipmapLevel > 0;
    }

    public ITextureFormat getTextureFormat() {
        return this.textureFormat;
    }

    public IColorBlender getShadersColorBlender(ShadersTextureType typeIn) {
        if (typeIn == null) {
            return null;
        }
        if (this.textureFormat != null) {
            return this.textureFormat.getColorBlender(typeIn);
        }
        return new ColorBlenderLinear();
    }

    public boolean isTextureBlend(ShadersTextureType typeIn) {
        if (typeIn == null) {
            return true;
        }
        if (this.textureFormat != null) {
            return this.textureFormat.isTextureBlend(typeIn);
        }
        return true;
    }

    public boolean isNormalBlend() {
        return this.isTextureBlend(ShadersTextureType.NORMAL);
    }

    public boolean isSpecularBlend() {
        return this.isTextureBlend(ShadersTextureType.SPECULAR);
    }

    public String toString() {
        return "" + this.f_118265_;
    }
}

