/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.culling;

import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import net.minecraft.world.phys.AABB;
import net.optifine.render.ICamera;

public class Frustum
implements ICamera {
    public static final int f_194437_ = 4;
    protected final Vector4f[] f_112995_ = new Vector4f[6];
    protected Vector4f f_194438_;
    private double f_112996_;
    private double f_112997_;
    private double f_112998_;
    public boolean disabled = false;

    public Frustum(Matrix4f matrixIn, Matrix4f projectionIn) {
        this.m_113026_(matrixIn, projectionIn);
    }

    public Frustum(Frustum frustumIn) {
        System.arraycopy(frustumIn.f_112995_, 0, this.f_112995_, 0, frustumIn.f_112995_.length);
        this.f_112996_ = frustumIn.f_112996_;
        this.f_112997_ = frustumIn.f_112997_;
        this.f_112998_ = frustumIn.f_112998_;
        this.f_194438_ = frustumIn.f_194438_;
        this.f_194438_ = frustumIn.f_194438_;
        this.f_112996_ = frustumIn.f_112996_;
        this.f_112997_ = frustumIn.f_112997_;
        this.f_112998_ = frustumIn.f_112998_;
        this.disabled = frustumIn.disabled;
    }

    public Frustum m_194441_(int stepIn) {
        double d0 = Math.floor(this.f_112996_ / (double)stepIn) * (double)stepIn;
        double d1 = Math.floor(this.f_112997_ / (double)stepIn) * (double)stepIn;
        double d2 = Math.floor(this.f_112998_ / (double)stepIn) * (double)stepIn;
        double d3 = Math.ceil(this.f_112996_ / (double)stepIn) * (double)stepIn;
        double d4 = Math.ceil(this.f_112997_ / (double)stepIn) * (double)stepIn;
        int count = 0;
        double d5 = Math.ceil(this.f_112998_ / (double)stepIn) * (double)stepIn;
        while (!this.m_194443_((float)(d0 - this.f_112996_), (float)(d1 - this.f_112997_), (float)(d2 - this.f_112998_), (float)(d3 - this.f_112996_), (float)(d4 - this.f_112997_), (float)(d5 - this.f_112998_))) {
            this.f_112996_ -= (double)(this.f_194438_.m_123601_() * 4.0f);
            this.f_112997_ -= (double)(this.f_194438_.m_123615_() * 4.0f);
            if (count++ > 10) break;
            this.f_112998_ -= (double)(this.f_194438_.m_123616_() * 4.0f);
        }
        return this;
    }

    public void m_113002_(double camX, double camY, double camZ) {
        this.f_112996_ = camX;
        this.f_112997_ = camY;
        this.f_112998_ = camZ;
    }

    private void m_113026_(Matrix4f matrixIn, Matrix4f projectionIn) {
        Matrix4f matrix4f = projectionIn.m_27658_();
        matrix4f.m_27644_(matrixIn);
        matrix4f.m_27659_();
        this.f_194438_ = new Vector4f(0.0f, 0.0f, 1.0f, 0.0f);
        this.f_194438_.m_123607_(matrix4f);
        this.m_113020_(matrix4f, -1, 0, 0, 0);
        this.m_113020_(matrix4f, 1, 0, 0, 1);
        this.m_113020_(matrix4f, 0, -1, 0, 2);
        this.m_113020_(matrix4f, 0, 1, 0, 3);
        this.m_113020_(matrix4f, 0, 0, -1, 4);
        this.m_113020_(matrix4f, 0, 0, 1, 5);
    }

    private void m_113020_(Matrix4f matrixIn, int xIn, int yIn, int zIn, int wIn) {
        Vector4f vector4f = new Vector4f((float)xIn, (float)yIn, (float)zIn, 1.0f);
        vector4f.m_123607_(matrixIn);
        vector4f.m_123618_();
        this.f_112995_[wIn] = vector4f;
    }

    public boolean m_113029_(AABB aabbIn) {
        return this.m_113006_(aabbIn.f_82288_, aabbIn.f_82289_, aabbIn.f_82290_, aabbIn.f_82291_, aabbIn.f_82292_, aabbIn.f_82293_);
    }

    private boolean m_113006_(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (this.disabled) {
            return true;
        }
        float f2 = (float)(minX - this.f_112996_);
        float f1 = (float)(minY - this.f_112997_);
        float f22 = (float)(minZ - this.f_112998_);
        float f3 = (float)(maxX - this.f_112996_);
        float f4 = (float)(maxY - this.f_112997_);
        float f5 = (float)(maxZ - this.f_112998_);
        return this.m_113013_(f2, f1, f22, f3, f4, f5);
    }

    private boolean m_113013_(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        for (int i2 = 0; i2 < 6; ++i2) {
            float w;
            float z;
            float y;
            Vector4f vector4f = this.f_112995_[i2];
            float x = vector4f.m_123601_();
            if (!(x * minX + (y = vector4f.m_123615_()) * minY + (z = vector4f.m_123616_()) * minZ + (w = vector4f.m_123617_()) <= 0.0f) || !(x * maxX + y * minY + z * minZ + w <= 0.0f) || !(x * minX + y * maxY + z * minZ + w <= 0.0f) || !(x * maxX + y * maxY + z * minZ + w <= 0.0f) || !(x * minX + y * minY + z * maxZ + w <= 0.0f) || !(x * maxX + y * minY + z * maxZ + w <= 0.0f) || !(x * minX + y * maxY + z * maxZ + w <= 0.0f) || !(x * maxX + y * maxY + z * maxZ + w <= 0.0f)) continue;
            return false;
        }
        return true;
    }

    private boolean m_194443_(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        for (int i2 = 0; i2 < 6; ++i2) {
            Vector4f vector4f = this.f_112995_[i2];
            Vector4f vector4f2 = new Vector4f(minX, minY, minZ, 1.0f);
            if (vector4f.m_123613_(vector4f2) <= 0.0f) {
                return false;
            }
            Vector4f vector4f3 = new Vector4f(maxX, minY, minZ, 1.0f);
            if (vector4f.m_123613_(vector4f3) <= 0.0f) {
                return false;
            }
            Vector4f vector4f4 = new Vector4f(minX, maxY, minZ, 1.0f);
            if (vector4f.m_123613_(vector4f4) <= 0.0f) {
                return false;
            }
            Vector4f vector4f5 = new Vector4f(maxX, maxY, minZ, 1.0f);
            if (vector4f.m_123613_(vector4f5) <= 0.0f) {
                return false;
            }
            Vector4f vector4f6 = new Vector4f(minX, minY, maxZ, 1.0f);
            if (vector4f.m_123613_(vector4f6) <= 0.0f) {
                return false;
            }
            Vector4f vector4f7 = new Vector4f(maxX, minY, maxZ, 1.0f);
            if (vector4f.m_123613_(vector4f7) <= 0.0f) {
                return false;
            }
            Vector4f vector4f8 = new Vector4f(minX, maxY, maxZ, 1.0f);
            if (vector4f.m_123613_(vector4f8) <= 0.0f) {
                return false;
            }
            Vector4f vector4f9 = new Vector4f(maxX, maxY, maxZ, 1.0f);
            if (!(vector4f.m_123613_(vector4f9) <= 0.0f)) continue;
            return false;
        }
        return true;
    }

    public boolean isBoxInFrustumFully(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (this.disabled) {
            return true;
        }
        float minXf = (float)minX;
        float minYf = (float)minY;
        float minZf = (float)minZ;
        float maxXf = (float)maxX;
        float maxYf = (float)maxY;
        float maxZf = (float)maxZ;
        for (int i2 = 0; i2 < 6; ++i2) {
            Vector4f frustumi = this.f_112995_[i2];
            float x = frustumi.m_123601_();
            float y = frustumi.m_123615_();
            float z = frustumi.m_123616_();
            float w = frustumi.m_123617_();
            if (!(i2 < 4 ? x * minXf + y * minYf + z * minZf + w <= 0.0f || x * maxXf + y * minYf + z * minZf + w <= 0.0f || x * minXf + y * maxYf + z * minZf + w <= 0.0f || x * maxXf + y * maxYf + z * minZf + w <= 0.0f || x * minXf + y * minYf + z * maxZf + w <= 0.0f || x * maxXf + y * minYf + z * maxZf + w <= 0.0f || x * minXf + y * maxYf + z * maxZf + w <= 0.0f || x * maxXf + y * maxYf + z * maxZf + w <= 0.0f : x * minXf + y * minYf + z * minZf + w <= 0.0f && x * maxXf + y * minYf + z * minZf + w <= 0.0f && x * minXf + y * maxYf + z * minZf + w <= 0.0f && x * maxXf + y * maxYf + z * minZf + w <= 0.0f && x * minXf + y * minYf + z * maxZf + w <= 0.0f && x * maxXf + y * minYf + z * maxZf + w <= 0.0f && x * minXf + y * maxYf + z * maxZf + w <= 0.0f && x * maxXf + y * maxYf + z * maxZf + w <= 0.0f)) continue;
            return false;
        }
        return true;
    }

    public double getCameraX() {
        return this.f_112996_;
    }

    public double getCameraY() {
        return this.f_112997_;
    }

    public double getCameraZ() {
        return this.f_112998_;
    }
}

