/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.RenderRegionCache;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.phys.Vec3;
import net.optifine.reflect.Reflector;
import net.optifine.render.RenderTypes;
import org.slf4j.Logger;

public class ChunkRenderDispatcher {
    private static final Logger f_112672_ = LogUtils.getLogger();
    private static final int f_173707_ = 4;
    private static final VertexFormat f_173708_ = DefaultVertexFormat.f_85811_;
    private static final int f_194400_ = 2;
    private final PriorityBlockingQueue<RenderChunk.ChunkCompileTask> f_194401_ = Queues.newPriorityBlockingQueue();
    private final Queue<RenderChunk.ChunkCompileTask> f_194402_ = Queues.newLinkedBlockingDeque();
    private int f_194403_ = 2;
    private final Queue<ChunkBufferBuilderPack> f_112674_;
    private final Queue<Runnable> f_112675_ = Queues.newConcurrentLinkedQueue();
    private volatile int f_112676_;
    private volatile int f_112677_;
    final ChunkBufferBuilderPack f_112678_;
    private final ProcessorMailbox<Runnable> f_112679_;
    private final Executor f_112680_;
    ClientLevel f_112681_;
    final LevelRenderer f_112682_;
    private Vec3 f_112683_ = Vec3.f_82478_;
    private int countRenderBuilders;
    private List<ChunkBufferBuilderPack> listPausedBuilders = new ArrayList();
    public static final RenderType[] BLOCK_RENDER_LAYERS = RenderType.m_110506_().toArray(new RenderType[0]);
    public static final RenderType[] BLOCK_RENDER_LAYERS_FORGE = RenderType.m_110506_().toArray(new RenderType[0]);
    private static final boolean FORGE = Reflector.ForgeHooksClient.exists();
    public static int renderChunksUpdated;

    public ChunkRenderDispatcher(ClientLevel worldIn, LevelRenderer worldRendererIn, Executor executorIn, boolean java64bit, ChunkBufferBuilderPack fixedBuilderIn) {
        this(worldIn, worldRendererIn, executorIn, java64bit, fixedBuilderIn, -1);
    }

    public ChunkRenderDispatcher(ClientLevel worldIn, LevelRenderer worldRendererIn, Executor executorIn, boolean java64bit, ChunkBufferBuilderPack fixedBuilderIn, int countRenderBuildersIn) {
        this.f_112681_ = worldIn;
        this.f_112682_ = worldRendererIn;
        int i2 = Math.max(1, (int)((double)Runtime.getRuntime().maxMemory() * 0.3) / (RenderType.m_110506_().stream().mapToInt(RenderType::m_110507_).sum() * 4) - 1);
        int j2 = Runtime.getRuntime().availableProcessors();
        int k2 = java64bit ? j2 : Math.min(j2, 4);
        int l2 = Math.max(1, Math.min(k2, i2));
        if (countRenderBuildersIn > 0) {
            l2 = countRenderBuildersIn;
        }
        this.f_112678_ = fixedBuilderIn;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)l2);
        try {
            for (int i1 = 0; i1 < l2; ++i1) {
                list.add(new ChunkBufferBuilderPack());
            }
        }
        catch (OutOfMemoryError outofmemoryerror) {
            f_112672_.warn("Allocated only {}/{} buffers", (Object)list.size(), (Object)l2);
            int j1 = Math.min(list.size() * 2 / 3, list.size() - 1);
            for (int k1 = 0; k1 < j1; ++k1) {
                list.remove(list.size() - 1);
            }
            System.gc();
        }
        this.f_112674_ = Queues.newConcurrentLinkedQueue((Iterable)list);
        this.countRenderBuilders = this.f_112677_ = this.f_112674_.size();
        this.f_112680_ = executorIn;
        this.f_112679_ = ProcessorMailbox.m_18751_((Executor)executorIn, (String)"Chunk Renderer");
        this.f_112679_.m_6937_(() -> this.m_112734_());
    }

    public void m_194410_(ClientLevel worldIn) {
        this.f_112681_ = worldIn;
    }

    private void m_112734_() {
        RenderChunk.ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask;
        if (!this.f_112674_.isEmpty() && (chunkrenderdispatcher$renderchunk$chunkcompiletask = this.m_194418_()) != null) {
            ChunkBufferBuilderPack chunkbufferbuilderpack = (ChunkBufferBuilderPack)this.f_112674_.poll();
            if (chunkbufferbuilderpack == null) {
                this.f_194401_.add(chunkrenderdispatcher$renderchunk$chunkcompiletask);
                return;
            }
            this.f_112676_ = this.f_194401_.size() + this.f_194402_.size();
            this.f_112677_ = this.f_112674_.size();
            ((CompletableFuture)CompletableFuture.supplyAsync(Util.m_183946_((String)chunkrenderdispatcher$renderchunk$chunkcompiletask.m_183497_(), () -> chunkrenderdispatcher$renderchunk$chunkcompiletask.m_5869_(chunkbufferbuilderpack)), this.f_112680_).thenCompose(p_194415_0_ -> p_194415_0_)).whenComplete((taskResultIn, throwableIn) -> {
                if (throwableIn != null) {
                    Minecraft.m_91087_().m_231412_(CrashReport.m_127521_((Throwable)throwableIn, (String)"Batching chunks"));
                } else {
                    this.f_112679_.m_6937_(() -> {
                        if (taskResultIn == ChunkTaskResult.SUCCESSFUL) {
                            chunkbufferbuilderpack.m_108838_();
                        } else {
                            chunkbufferbuilderpack.m_108841_();
                        }
                        this.f_112674_.add(chunkbufferbuilderpack);
                        this.f_112677_ = this.f_112674_.size();
                        this.m_112734_();
                    });
                }
            });
        }
    }

    @Nullable
    private RenderChunk.ChunkCompileTask m_194418_() {
        RenderChunk.ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask;
        if (this.f_194403_ <= 0 && (chunkrenderdispatcher$renderchunk$chunkcompiletask = (RenderChunk.ChunkCompileTask)this.f_194402_.poll()) != null) {
            this.f_194403_ = 2;
            return chunkrenderdispatcher$renderchunk$chunkcompiletask;
        }
        RenderChunk.ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask1 = (RenderChunk.ChunkCompileTask)this.f_194401_.poll();
        if (chunkrenderdispatcher$renderchunk$chunkcompiletask1 != null) {
            --this.f_194403_;
            return chunkrenderdispatcher$renderchunk$chunkcompiletask1;
        }
        this.f_194403_ = 2;
        return (RenderChunk.ChunkCompileTask)this.f_194402_.poll();
    }

    public String m_112719_() {
        return String.format(Locale.ROOT, "pC: %03d, pU: %02d, aB: %02d", this.f_112676_, this.f_112675_.size(), this.f_112677_);
    }

    public int m_173712_() {
        return this.f_112676_;
    }

    public int m_173713_() {
        return this.f_112675_.size();
    }

    public int m_173714_() {
        return this.f_112677_;
    }

    public void m_112693_(Vec3 posIn) {
        this.f_112683_ = posIn;
    }

    public Vec3 m_112727_() {
        return this.f_112683_;
    }

    public void m_194417_() {
        Runnable runnable;
        while ((runnable = (Runnable)this.f_112675_.poll()) != null) {
            runnable.run();
        }
    }

    public void m_200431_(RenderChunk chunkRenderIn, RenderRegionCache regionCacheIn) {
        chunkRenderIn.m_200439_(regionCacheIn);
    }

    public void m_112731_() {
        this.m_112735_();
    }

    public void m_112709_(RenderChunk.ChunkCompileTask renderTaskIn) {
        this.f_112679_.m_6937_(() -> {
            if (renderTaskIn.f_194420_) {
                this.f_194401_.offer(renderTaskIn);
            } else {
                this.f_194402_.offer(renderTaskIn);
            }
            this.f_112676_ = this.f_194401_.size() + this.f_194402_.size();
            this.m_112734_();
        });
    }

    public CompletableFuture<Void> m_234450_(BufferBuilder.RenderedBuffer bufferIn, VertexBuffer vertexBufferIn) {
        return CompletableFuture.runAsync(() -> {
            if (!vertexBufferIn.m_231230_()) {
                vertexBufferIn.m_85921_();
                vertexBufferIn.m_231221_(bufferIn);
                VertexBuffer.m_85931_();
            }
        }, this.f_112675_::add);
    }

    private void m_112735_() {
        while (!this.f_194401_.isEmpty()) {
            RenderChunk.ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask = (RenderChunk.ChunkCompileTask)this.f_194401_.poll();
            if (chunkrenderdispatcher$renderchunk$chunkcompiletask == null) continue;
            chunkrenderdispatcher$renderchunk$chunkcompiletask.m_6204_();
        }
        while (!this.f_194402_.isEmpty()) {
            RenderChunk.ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask1 = (RenderChunk.ChunkCompileTask)this.f_194402_.poll();
            if (chunkrenderdispatcher$renderchunk$chunkcompiletask1 == null) continue;
            chunkrenderdispatcher$renderchunk$chunkcompiletask1.m_6204_();
        }
        this.f_112676_ = 0;
    }

    public boolean m_112732_() {
        return this.f_112676_ == 0 && this.f_112675_.isEmpty();
    }

    public void m_112733_() {
        this.m_112735_();
        this.f_112679_.close();
        this.f_112674_.clear();
    }

    public void pauseChunkUpdates() {
        long timeStartMs = System.currentTimeMillis();
        if (this.listPausedBuilders.size() > 0) {
            return;
        }
        while (this.listPausedBuilders.size() != this.countRenderBuilders) {
            this.m_194417_();
            ChunkBufferBuilderPack builder = (ChunkBufferBuilderPack)this.f_112674_.poll();
            if (builder != null) {
                this.listPausedBuilders.add(builder);
            }
            if (System.currentTimeMillis() <= timeStartMs + 1000L) continue;
            break;
        }
    }

    public void resumeChunkUpdates() {
        this.f_112674_.addAll(this.listPausedBuilders);
        this.listPausedBuilders.clear();
    }

    public boolean updateChunkNow(RenderChunk renderChunk, RenderRegionCache regionCacheIn) {
        this.m_200431_(renderChunk, regionCacheIn);
        return true;
    }

    public boolean updateChunkLater(RenderChunk renderChunk, RenderRegionCache regionCacheIn) {
        if (this.f_112674_.isEmpty()) {
            return false;
        }
        renderChunk.m_200434_(this, regionCacheIn);
        return true;
    }

    public boolean updateTransparencyLater(RenderChunk renderChunk) {
        if (this.f_112674_.isEmpty()) {
            return false;
        }
        return renderChunk.m_112809_(RenderTypes.TRANSLUCENT, this);
    }
}

