/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.shaders.Shaders;

/*
 * Exception performing whole class analysis ignored.
 */
public class SignRenderer
implements BlockEntityRenderer<SignBlockEntity> {
    public static final int f_173627_ = 90;
    private static final int f_173628_ = 10;
    private static final String f_173629_ = "stick";
    private static final int f_173630_ = -988212;
    private static final int f_173631_ = Mth.m_144944_((int)16);
    private final Map<WoodType, SignModel> f_173632_ = (Map)WoodType.m_61843_().collect(ImmutableMap.toImmutableMap(woodTypeIn -> woodTypeIn, woodTypeIn -> new SignModel(contextIn.m_173582_(ModelLayers.m_171291_((WoodType)woodTypeIn)))));
    private final Font f_173633_;
    private static double textRenderDistanceSq = 4096.0;

    public SignRenderer(BlockEntityRendererProvider.Context contextIn) {
        this.f_173633_ = contextIn.m_173586_();
    }

    public void m_6922_(SignBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockstate = tileEntityIn.m_58900_();
        matrixStackIn.m_85836_();
        float f2 = 0.6666667f;
        WoodType woodtype = SignRenderer.m_173637_((Block)blockstate.m_60734_());
        SignModel signrenderer$signmodel = (SignModel)this.f_173632_.get(woodtype);
        if (blockstate.m_60734_() instanceof StandingSignBlock) {
            matrixStackIn.m_85837_(0.5, 0.5, 0.5);
            float f1 = -((float)((Integer)blockstate.m_61143_((Property)StandingSignBlock.f_56987_) * 360) / 16.0f);
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(f1));
            signrenderer$signmodel.f_112507_.f_104207_ = true;
        } else {
            matrixStackIn.m_85837_(0.5, 0.5, 0.5);
            float f4 = -((Direction)blockstate.m_61143_((Property)WallSignBlock.f_58064_)).m_122435_();
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(f4));
            matrixStackIn.m_85837_(0.0, -0.3125, -0.4375);
            signrenderer$signmodel.f_112507_.f_104207_ = false;
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(0.6666667f, -0.6666667f, -0.6666667f);
        Material material = Sheets.m_173381_((WoodType)woodtype);
        VertexConsumer vertexconsumer = material.m_119194_(bufferIn, arg_0 -> ((SignModel)signrenderer$signmodel).m_103119_(arg_0));
        signrenderer$signmodel.f_173655_.m_104301_(matrixStackIn, vertexconsumer, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85849_();
        if (SignRenderer.isRenderText((SignBlockEntity)tileEntityIn)) {
            int l2;
            boolean flag;
            int k2;
            float f22 = 0.010416667f;
            matrixStackIn.m_85837_(0.0, 0.3333333432674408, 0.046666666865348816);
            matrixStackIn.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
            int i2 = SignRenderer.m_173639_((SignBlockEntity)tileEntityIn);
            int j2 = 20;
            FormattedCharSequence[] aformattedcharsequence = tileEntityIn.m_155717_(Minecraft.m_91087_().m_167974_(), componentIn -> {
                List list = this.f_173633_.m_92923_((FormattedText)componentIn, 90);
                return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
            });
            if (tileEntityIn.m_155727_()) {
                k2 = tileEntityIn.m_59753_().m_41071_();
                if (Config.isCustomColors()) {
                    k2 = CustomColors.getSignTextColor((int)k2);
                }
                flag = SignRenderer.m_173641_((SignBlockEntity)tileEntityIn, (int)k2);
                l2 = 0xF000F0;
            } else {
                k2 = i2;
                flag = false;
                l2 = combinedLightIn;
            }
            for (int i1 = 0; i1 < 4; ++i1) {
                FormattedCharSequence formattedcharsequence = aformattedcharsequence[i1];
                float f3 = -this.f_173633_.m_92724_(formattedcharsequence) / 2;
                if (flag) {
                    this.f_173633_.m_168645_(formattedcharsequence, f3, (float)(i1 * 10 - 20), k2, i2, matrixStackIn.m_85850_().m_85861_(), bufferIn, l2);
                    continue;
                }
                this.f_173633_.m_92733_(formattedcharsequence, f3, (float)(i1 * 10 - 20), k2, false, matrixStackIn.m_85850_().m_85861_(), bufferIn, false, 0, l2);
            }
        }
        matrixStackIn.m_85849_();
    }

    private static boolean m_173641_(SignBlockEntity entityIn, int colorIn) {
        if (colorIn == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localplayer = minecraft.f_91074_;
        if (localplayer != null && minecraft.f_91066_.m_92176_().m_90612_() && localplayer.m_150108_()) {
            return true;
        }
        Entity entity = minecraft.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)entityIn.m_58899_())) < (double)f_173631_;
    }

    private static int m_173639_(SignBlockEntity entityIn) {
        int i2 = entityIn.m_59753_().m_41071_();
        if (Config.isCustomColors()) {
            i2 = CustomColors.getSignTextColor((int)i2);
        }
        double d0 = 0.4;
        int j2 = (int)((double)NativeImage.m_85085_((int)i2) * 0.4);
        int k2 = (int)((double)NativeImage.m_85103_((int)i2) * 0.4);
        int l2 = (int)((double)NativeImage.m_85119_((int)i2) * 0.4);
        return i2 == DyeColor.BLACK.m_41071_() && entityIn.m_155727_() ? -988212 : NativeImage.m_84992_((int)0, (int)l2, (int)k2, (int)j2);
    }

    public static WoodType m_173637_(Block blockIn) {
        WoodType woodtype = blockIn instanceof SignBlock ? ((SignBlock)blockIn).m_56297_() : WoodType.f_61830_;
        return woodtype;
    }

    public static SignModel m_173646_(EntityModelSet modelSetIn, WoodType woodTypeIn) {
        return new SignModel(modelSetIn.m_171103_(ModelLayers.m_171291_((WoodType)woodTypeIn)));
    }

    public static LayerDefinition m_173654_() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("sign", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-12.0f, -14.0f, -1.0f, 24.0f, 12.0f, 2.0f), PartPose.f_171404_);
        partdefinition.m_171599_("stick", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-1.0f, -2.0f, -1.0f, 2.0f, 14.0f, 2.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    private static boolean isRenderText(SignBlockEntity tileEntity) {
        if (Shaders.isShadowPass) {
            return false;
        }
        if (!Config.zoomMode) {
            BlockPos tileEntityPos = tileEntity.m_58899_();
            Entity viewEntity = Minecraft.m_91087_().m_91288_();
            double distSq = viewEntity.m_20275_((double)tileEntityPos.m_123341_(), (double)tileEntityPos.m_123342_(), (double)tileEntityPos.m_123343_());
            if (distSq > textRenderDistanceSq) {
                return false;
            }
        }
        return true;
    }

    public static void updateTextRenderDistance() {
        Minecraft mc = Minecraft.m_91087_();
        double fov = Config.limit((int)((Integer)mc.f_91066_.m_231837_().m_231551_()), (int)1, (int)120);
        double textRenderDistance = Math.max(1.5 * (double)mc.m_91268_().m_85444_() / fov, 16.0);
        textRenderDistanceSq = textRenderDistance * textRenderDistance;
    }
}

