/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.optifine.Config;
import net.optifine.ItemOverrideCache;

public class ItemOverrides {
    public static final ItemOverrides f_111734_ = new ItemOverrides();
    private final BakedOverride[] f_111735_;
    private final ResourceLocation[] f_173461_;
    private ItemOverrideCache itemOverrideCache;
    public static ResourceLocation lastModelLocation = null;

    private ItemOverrides() {
        this.f_111735_ = new BakedOverride[0];
        this.f_173461_ = new ResourceLocation[0];
    }

    public ItemOverrides(ModelBakery modelBakeryIn, BlockModel blockModelIn, Function<ResourceLocation, UnbakedModel> modelGetter, List<ItemOverride> itemOverridesIn) {
        this(modelBakeryIn, (UnbakedModel)blockModelIn, modelGetter, arg_0 -> ((AtlasSet)modelBakeryIn.getAtlasSet()).m_117971_(arg_0), itemOverridesIn);
    }

    public ItemOverrides(ModelBakery modelBakeryIn, UnbakedModel blockModelIn, Function<ResourceLocation, UnbakedModel> modelGetter, Function<Material, TextureAtlasSprite> textureGetter, List<ItemOverride> itemOverridesIn) {
        this.f_173461_ = (ResourceLocation[])itemOverridesIn.stream().flatMap(ItemOverride::m_173449_).map(ItemOverride.Predicate::m_173459_).distinct().toArray(ResourceLocation[]::new);
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        for (int i2 = 0; i2 < this.f_173461_.length; ++i2) {
            object2intmap.put((Object)this.f_173461_[i2], i2);
        }
        ArrayList list = Lists.newArrayList();
        for (int j2 = itemOverridesIn.size() - 1; j2 >= 0; --j2) {
            ItemOverride itemoverride = itemOverridesIn.get(j2);
            BakedModel bakedmodel = this.bakeModel(modelBakeryIn, blockModelIn, modelGetter, textureGetter, itemoverride);
            PropertyMatcher[] aitemoverrides$propertymatcher = (PropertyMatcher[])itemoverride.m_173449_().map(arg_0 -> ItemOverrides.lambda$new$1((Object2IntMap)object2intmap, arg_0)).toArray(PropertyMatcher[]::new);
            list.add(new BakedOverride(aitemoverrides$propertymatcher, bakedmodel));
            BakedOverride bo = (BakedOverride)list.get(list.size() - 1);
            bo.location = itemoverride.m_111718_();
        }
        this.f_111735_ = list.toArray(new BakedOverride[0]);
        if (itemOverridesIn.size() > 65) {
            this.itemOverrideCache = ItemOverrideCache.make(itemOverridesIn);
        }
    }

    @Nullable
    private BakedModel bakeModel(ModelBakery modelBakeryIn, UnbakedModel blockModelIn, Function<ResourceLocation, UnbakedModel> unbakedLocatorIn, Function<Material, TextureAtlasSprite> textureGetter, ItemOverride itemOverrideIn) {
        UnbakedModel unbakedmodel = unbakedLocatorIn.apply(itemOverrideIn.m_111718_());
        return Objects.equals(unbakedmodel, blockModelIn) ? null : modelBakeryIn.bake(itemOverrideIn.m_111718_(), (ModelState)BlockModelRotation.X0_Y0, textureGetter);
    }

    @Nullable
    public BakedModel m_173464_(BakedModel modelIn, ItemStack stackIn, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int seedIn) {
        boolean customItems = Config.isCustomItems();
        if (customItems) {
            lastModelLocation = null;
        }
        if (this.f_111735_.length != 0) {
            Integer modelIndex;
            if (this.itemOverrideCache != null && (modelIndex = this.itemOverrideCache.getModelIndex(stackIn, worldIn, entityIn)) != null) {
                int indexCached = modelIndex;
                if (indexCached >= 0 && indexCached < this.f_111735_.length) {
                    BakedModel modelCached;
                    if (customItems) {
                        lastModelLocation = this.f_111735_[indexCached].location;
                    }
                    if ((modelCached = this.f_111735_[indexCached].f_173481_) != null) {
                        return modelCached;
                    }
                }
                return modelIn;
            }
            Item item = stackIn.m_41720_();
            int i2 = this.f_173461_.length;
            float[] afloat = new float[i2];
            for (int j2 = 0; j2 < i2; ++j2) {
                ResourceLocation resourcelocation = this.f_173461_[j2];
                ItemPropertyFunction itempropertyfunction = ItemProperties.m_117829_((Item)item, (ResourceLocation)resourcelocation);
                afloat[j2] = itempropertyfunction != null ? itempropertyfunction.m_141951_(stackIn, worldIn, entityIn, seedIn) : Float.NEGATIVE_INFINITY;
            }
            for (int ix = 0; ix < this.f_111735_.length; ++ix) {
                BakedOverride itemoverrides$bakedoverride = this.f_111735_[ix];
                if (!itemoverrides$bakedoverride.m_173485_(afloat)) continue;
                BakedModel bakedmodel = itemoverrides$bakedoverride.f_173481_;
                if (customItems) {
                    lastModelLocation = itemoverrides$bakedoverride.location;
                }
                if (this.itemOverrideCache != null) {
                    this.itemOverrideCache.putModelIndex(stackIn, worldIn, entityIn, Integer.valueOf(ix));
                }
                if (bakedmodel == null) {
                    return modelIn;
                }
                return bakedmodel;
            }
        }
        return modelIn;
    }

    private static /* synthetic */ PropertyMatcher lambda$new$1(Object2IntMap object2intmap, ItemOverride.Predicate p_173475_1_) {
        int k2 = object2intmap.getInt((Object)p_173475_1_.m_173459_());
        return new PropertyMatcher(k2, p_173475_1_.m_173460_());
    }
}

