/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import net.optifine.BetterSnow;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.EmissiveTextures;
import net.optifine.model.BlockModelCustomizer;
import net.optifine.model.ListQuadsOverlay;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.render.LightCacheOF;
import net.optifine.render.RenderEnv;
import net.optifine.render.RenderTypes;
import net.optifine.shaders.SVertexBuilder;
import net.optifine.shaders.Shaders;
import net.optifine.util.BlockUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ModelBlockRenderer {
    private static final int f_173403_ = 0;
    private static final int f_173404_ = 1;
    static final Direction[] f_173405_ = Direction.values();
    private final BlockColors f_110995_;
    private static final int f_173406_ = 100;
    static final ThreadLocal<Cache> f_110996_ = ThreadLocal.withInitial(Cache::new);
    private static float aoLightValueOpaque = 0.2f;
    private static boolean separateAoLightValue = false;
    private static final LightCacheOF LIGHT_CACHE_OF = new LightCacheOF();
    private static final RenderType[] OVERLAY_LAYERS = new RenderType[]{RenderTypes.CUTOUT, RenderTypes.CUTOUT_MIPPED, RenderTypes.TRANSLUCENT};
    private boolean forge = Reflector.ForgeHooksClient.exists();

    public ModelBlockRenderer(BlockColors blockColorsIn) {
        this.f_110995_ = blockColorsIn;
    }

    public void m_234379_(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixIn, VertexConsumer buffer, boolean checkSides, RandomSource randomIn, long rand, int combinedOverlayIn) {
        this.tesselateBlock(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, ModelData.EMPTY, null);
    }

    public void tesselateBlock(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixIn, VertexConsumer buffer, boolean checkSides, RandomSource randomIn, long rand, int combinedOverlayIn, ModelData modelData, RenderType renderType) {
        boolean flag;
        boolean bl = flag = Minecraft.m_91086_() && ReflectorForge.getLightEmission((BlockState)stateIn, (BlockAndTintGetter)worldIn, (BlockPos)posIn) == 0 && modelIn.useAmbientOcclusion(stateIn, renderType);
        if (this.forge) {
            modelData = modelIn.getModelData(worldIn, posIn, stateIn, modelData);
        }
        Vec3 vec3 = stateIn.m_60824_((BlockGetter)worldIn, posIn);
        matrixIn.m_85837_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        try {
            if (Config.isShaders()) {
                SVertexBuilder.pushEntity((BlockState)stateIn, (VertexConsumer)buffer);
            }
            if (!Config.isAlternateBlocks()) {
                rand = 0L;
            }
            RenderEnv renderEnv = buffer.getRenderEnv(stateIn, posIn);
            modelIn = BlockModelCustomizer.getRenderModel((BakedModel)modelIn, (BlockState)stateIn, (RenderEnv)renderEnv);
            int prevVertexCount = buffer.getVertexCount();
            if (flag) {
                this.renderModelSmooth(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, modelData, renderType);
            } else {
                this.renderModelFlat(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, modelData, renderType);
            }
            if (buffer.getVertexCount() != prevVertexCount) {
                this.renderOverlayModels(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, combinedOverlayIn, checkSides, randomIn, rand, renderEnv, flag, vec3);
            }
            if (Config.isShaders()) {
                SVertexBuilder.popEntity((VertexConsumer)buffer);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block model being tesselated");
            CrashReportCategory.m_178950_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)worldIn, (BlockPos)posIn, (BlockState)stateIn);
            crashreportcategory.m_128159_("Using AO", (Object)flag);
            throw new ReportedException(crashreport);
        }
    }

    public void m_234390_(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixStackIn, VertexConsumer buffer, boolean checkSides, RandomSource randomIn, long rand, int combinedOverlayIn) {
        this.renderModelSmooth(worldIn, modelIn, stateIn, posIn, matrixStackIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, ModelData.EMPTY, null);
    }

    public void renderModelSmooth(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixStackIn, VertexConsumer buffer, boolean checkSides, RandomSource randomIn, long rand, int combinedOverlayIn, ModelData modelData, RenderType renderType) {
        List list1;
        RenderEnv renderEnv = buffer.getRenderEnv(stateIn, posIn);
        RenderType layer = buffer.getRenderType();
        for (Direction direction : f_173405_) {
            if (checkSides && !BlockUtils.shouldSideBeRendered((BlockState)stateIn, (BlockGetter)worldIn, (BlockPos)posIn, (Direction)direction, (RenderEnv)renderEnv)) continue;
            randomIn.m_188584_(rand);
            List list = this.forge ? modelIn.getQuads(stateIn, direction, randomIn, modelData, renderType) : modelIn.m_213637_(stateIn, direction, randomIn);
            list = BlockModelCustomizer.getRenderQuads((List)list, (BlockAndTintGetter)worldIn, (BlockState)stateIn, (BlockPos)posIn, (Direction)direction, (RenderType)layer, (long)rand, (RenderEnv)renderEnv);
            if (list.isEmpty()) continue;
            this.renderQuadsSmooth(worldIn, stateIn, posIn, matrixStackIn, buffer, list, combinedOverlayIn, renderEnv);
        }
        randomIn.m_188584_(rand);
        List list = list1 = this.forge ? modelIn.getQuads(stateIn, (Direction)null, randomIn, modelData, renderType) : modelIn.m_213637_(stateIn, (Direction)null, randomIn);
        if (!list1.isEmpty()) {
            list1 = BlockModelCustomizer.getRenderQuads((List)list1, (BlockAndTintGetter)worldIn, (BlockState)stateIn, (BlockPos)posIn, null, (RenderType)layer, (long)rand, (RenderEnv)renderEnv);
            this.renderQuadsSmooth(worldIn, stateIn, posIn, matrixStackIn, buffer, list1, combinedOverlayIn, renderEnv);
        }
    }

    public void m_234401_(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixStackIn, VertexConsumer buffer, boolean checkSides, RandomSource randomIn, long rand, int combinedOverlayIn) {
        this.renderModelFlat(worldIn, modelIn, stateIn, posIn, matrixStackIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, ModelData.EMPTY, null);
    }

    public void renderModelFlat(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixStackIn, VertexConsumer buffer, boolean checkSides, RandomSource randomIn, long rand, int combinedOverlayIn, ModelData modelData, RenderType renderType) {
        List list1;
        RenderEnv renderEnv = buffer.getRenderEnv(stateIn, posIn);
        RenderType layer = buffer.getRenderType();
        for (Direction direction : f_173405_) {
            if (checkSides && !BlockUtils.shouldSideBeRendered((BlockState)stateIn, (BlockGetter)worldIn, (BlockPos)posIn, (Direction)direction, (RenderEnv)renderEnv)) continue;
            randomIn.m_188584_(rand);
            List list = this.forge ? modelIn.getQuads(stateIn, direction, randomIn, modelData, renderType) : modelIn.m_213637_(stateIn, direction, randomIn);
            list = BlockModelCustomizer.getRenderQuads((List)list, (BlockAndTintGetter)worldIn, (BlockState)stateIn, (BlockPos)posIn, (Direction)direction, (RenderType)layer, (long)rand, (RenderEnv)renderEnv);
            if (list.isEmpty()) continue;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = renderEnv.getRenderMutableBlockPos();
            blockpos$mutableblockpos.m_122159_((Vec3i)posIn, direction);
            int i2 = LevelRenderer.m_109537_((BlockAndTintGetter)worldIn, (BlockState)stateIn, (BlockPos)blockpos$mutableblockpos);
            this.renderQuadsFlat(worldIn, stateIn, posIn, i2, combinedOverlayIn, false, matrixStackIn, buffer, list, renderEnv);
        }
        randomIn.m_188584_(rand);
        List list = list1 = this.forge ? modelIn.getQuads(stateIn, (Direction)null, randomIn, modelData, renderType) : modelIn.m_213637_(stateIn, (Direction)null, randomIn);
        if (!list1.isEmpty()) {
            list1 = BlockModelCustomizer.getRenderQuads((List)list1, (BlockAndTintGetter)worldIn, (BlockState)stateIn, (BlockPos)posIn, null, (RenderType)layer, (long)rand, (RenderEnv)renderEnv);
            this.renderQuadsFlat(worldIn, stateIn, posIn, -1, combinedOverlayIn, true, matrixStackIn, buffer, list1, renderEnv);
        }
    }

    private void renderQuadsSmooth(BlockAndTintGetter blockAccessIn, BlockState stateIn, BlockPos posIn, PoseStack matrixStackIn, VertexConsumer buffer, List<BakedQuad> list, int combinedOverlayIn, RenderEnv renderEnv) {
        float[] quadBounds = renderEnv.getQuadBounds();
        BitSet bitSet = renderEnv.getBoundsFlags();
        AmbientOcclusionFace aoFace = renderEnv.getAoFace();
        int listSize = list.size();
        for (int ix = 0; ix < listSize; ++ix) {
            boolean updateAo;
            BakedQuad bakedquad = list.get(ix);
            this.m_111039_(blockAccessIn, stateIn, posIn, bakedquad.m_111303_(), bakedquad.m_111306_(), quadBounds, bitSet);
            boolean bl = updateAo = !Reflector.ForgeHooksClient_calculateFaceWithoutAO.exists() || !Reflector.ForgeHooksClient_calculateFaceWithoutAO.callBoolean(new Object[]{blockAccessIn, stateIn, posIn, bakedquad, bitSet.get(0), aoFace.f_111149_, aoFace.f_111150_});
            if (updateAo) {
                aoFace.m_111167_(blockAccessIn, stateIn, posIn, bakedquad.m_111306_(), quadBounds, bitSet, bakedquad.m_111307_());
            }
            if (bakedquad.m_173410_().isSpriteEmissive) {
                aoFace.setMaxBlockLight();
            }
            this.renderQuadSmooth(blockAccessIn, stateIn, posIn, buffer, matrixStackIn.m_85850_(), bakedquad, aoFace.f_111149_[0], aoFace.f_111149_[1], aoFace.f_111149_[2], aoFace.f_111149_[3], aoFace.f_111150_[0], aoFace.f_111150_[1], aoFace.f_111150_[2], aoFace.f_111150_[3], combinedOverlayIn, renderEnv);
        }
    }

    private void renderQuadSmooth(BlockAndTintGetter blockAccessIn, BlockState stateIn, BlockPos posIn, VertexConsumer buffer, PoseStack.Pose matrixEntry, BakedQuad quadIn, float colorMul0, float colorMul1, float colorMul2, float colorMul3, int brightness0, int brightness1, int brightness2, int brightness3, int combinedOverlayIn, RenderEnv renderEnv) {
        float f2;
        float f1;
        float f3;
        int colorMultiplier = CustomColors.getColorMultiplier((BakedQuad)quadIn, (BlockState)stateIn, (BlockAndTintGetter)blockAccessIn, (BlockPos)posIn, (RenderEnv)renderEnv);
        if (quadIn.m_111304_() || colorMultiplier != -1) {
            int i2 = colorMultiplier != -1 ? colorMultiplier : this.f_110995_.m_92577_(stateIn, blockAccessIn, posIn, quadIn.m_111305_());
            f3 = (float)(i2 >> 16 & 0xFF) / 255.0f;
            f1 = (float)(i2 >> 8 & 0xFF) / 255.0f;
            f2 = (float)(i2 & 0xFF) / 255.0f;
        } else {
            f3 = 1.0f;
            f1 = 1.0f;
            f2 = 1.0f;
        }
        buffer.m_85995_(matrixEntry, quadIn, buffer.getTempFloat4(colorMul0, colorMul1, colorMul2, colorMul3), f3, f1, f2, buffer.getTempInt4(brightness0, brightness1, brightness2, brightness3), combinedOverlayIn, true);
    }

    private void m_111039_(BlockAndTintGetter blockReaderIn, BlockState stateIn, BlockPos posIn, int[] vertexData, Direction face, @Nullable float[] quadBounds, BitSet boundsFlags) {
        float f2 = 32.0f;
        float f1 = 32.0f;
        float f22 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        int step = vertexData.length / 4;
        for (int i2 = 0; i2 < 4; ++i2) {
            float f6 = Float.intBitsToFloat(vertexData[i2 * step]);
            float f7 = Float.intBitsToFloat(vertexData[i2 * step + 1]);
            float f8 = Float.intBitsToFloat(vertexData[i2 * step + 2]);
            f2 = Math.min(f2, f6);
            f1 = Math.min(f1, f7);
            f22 = Math.min(f22, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (quadBounds != null) {
            quadBounds[Direction.WEST.m_122411_()] = f2;
            quadBounds[Direction.EAST.m_122411_()] = f3;
            quadBounds[Direction.DOWN.m_122411_()] = f1;
            quadBounds[Direction.UP.m_122411_()] = f4;
            quadBounds[Direction.NORTH.m_122411_()] = f22;
            quadBounds[Direction.SOUTH.m_122411_()] = f5;
            int j2 = f_173405_.length;
            quadBounds[Direction.WEST.m_122411_() + j2] = 1.0f - f2;
            quadBounds[Direction.EAST.m_122411_() + j2] = 1.0f - f3;
            quadBounds[Direction.DOWN.m_122411_() + j2] = 1.0f - f1;
            quadBounds[Direction.UP.m_122411_() + j2] = 1.0f - f4;
            quadBounds[Direction.NORTH.m_122411_() + j2] = 1.0f - f22;
            quadBounds[Direction.SOUTH.m_122411_() + j2] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (1.$SwitchMap$net$minecraft$core$Direction[face.ordinal()]) {
            case 1: {
                boundsFlags.set(1, f2 >= 1.0E-4f || f22 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f1 == f4 && (f1 < 1.0E-4f || stateIn.m_60838_((BlockGetter)blockReaderIn, posIn)));
                break;
            }
            case 2: {
                boundsFlags.set(1, f2 >= 1.0E-4f || f22 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f1 == f4 && (f4 > 0.9999f || stateIn.m_60838_((BlockGetter)blockReaderIn, posIn)));
                break;
            }
            case 3: {
                boundsFlags.set(1, f2 >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, f22 == f5 && (f22 < 1.0E-4f || stateIn.m_60838_((BlockGetter)blockReaderIn, posIn)));
                break;
            }
            case 4: {
                boundsFlags.set(1, f2 >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, f22 == f5 && (f5 > 0.9999f || stateIn.m_60838_((BlockGetter)blockReaderIn, posIn)));
                break;
            }
            case 5: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f22 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f2 == f3 && (f2 < 1.0E-4f || stateIn.m_60838_((BlockGetter)blockReaderIn, posIn)));
                break;
            }
            case 6: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f22 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f2 == f3 && (f3 > 0.9999f || stateIn.m_60838_((BlockGetter)blockReaderIn, posIn)));
            }
        }
    }

    private void renderQuadsFlat(BlockAndTintGetter blockAccessIn, BlockState stateIn, BlockPos posIn, int brightnessIn, int combinedOverlayIn, boolean ownBrightness, PoseStack matrixStackIn, VertexConsumer buffer, List<BakedQuad> list, RenderEnv renderEnv) {
        BitSet bitSet = renderEnv.getBoundsFlags();
        int listSize = list.size();
        for (int ix = 0; ix < listSize; ++ix) {
            BakedQuad bakedquad = list.get(ix);
            if (ownBrightness) {
                this.m_111039_(blockAccessIn, stateIn, posIn, bakedquad.m_111303_(), bakedquad.m_111306_(), (float[])null, bitSet);
                BlockPos blockpos = bitSet.get(0) ? posIn.m_121945_(bakedquad.m_111306_()) : posIn;
                brightnessIn = LevelRenderer.m_109537_((BlockAndTintGetter)blockAccessIn, (BlockState)stateIn, (BlockPos)blockpos);
            }
            if (bakedquad.m_173410_().isSpriteEmissive) {
                brightnessIn = LightTexture.MAX_BRIGHTNESS;
            }
            float f2 = blockAccessIn.m_7717_(bakedquad.m_111306_(), bakedquad.m_111307_());
            this.renderQuadSmooth(blockAccessIn, stateIn, posIn, buffer, matrixStackIn.m_85850_(), bakedquad, f2, f2, f2, f2, brightnessIn, brightnessIn, brightnessIn, brightnessIn, combinedOverlayIn, renderEnv);
        }
    }

    public void m_111067_(PoseStack.Pose matrixEntry, VertexConsumer buffer, @Nullable BlockState state, BakedModel modelIn, float red, float green, float blue, int combinedLightIn, int combinedOverlayIn) {
        this.renderModel(matrixEntry, buffer, state, modelIn, red, green, blue, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, null);
    }

    public void renderModel(PoseStack.Pose matrixEntry, VertexConsumer buffer, @Nullable BlockState state, BakedModel modelIn, float red, float green, float blue, int combinedLightIn, int combinedOverlayIn, ModelData modelData, RenderType renderType) {
        RandomSource randomsource = RandomSource.m_216327_();
        long i2 = 42L;
        for (Direction direction : f_173405_) {
            randomsource.m_188584_(42L);
            if (this.forge) {
                ModelBlockRenderer.m_111058_((PoseStack.Pose)matrixEntry, (VertexConsumer)buffer, (float)red, (float)green, (float)blue, (List)modelIn.getQuads(state, direction, randomsource, modelData, renderType), (int)combinedLightIn, (int)combinedOverlayIn);
                continue;
            }
            ModelBlockRenderer.m_111058_((PoseStack.Pose)matrixEntry, (VertexConsumer)buffer, (float)red, (float)green, (float)blue, (List)modelIn.m_213637_(state, direction, randomsource), (int)combinedLightIn, (int)combinedOverlayIn);
        }
        randomsource.m_188584_(42L);
        if (this.forge) {
            ModelBlockRenderer.m_111058_((PoseStack.Pose)matrixEntry, (VertexConsumer)buffer, (float)red, (float)green, (float)blue, (List)modelIn.getQuads(state, (Direction)null, randomsource, modelData, renderType), (int)combinedLightIn, (int)combinedOverlayIn);
        } else {
            ModelBlockRenderer.m_111058_((PoseStack.Pose)matrixEntry, (VertexConsumer)buffer, (float)red, (float)green, (float)blue, (List)modelIn.m_213637_(state, (Direction)null, randomsource), (int)combinedLightIn, (int)combinedOverlayIn);
        }
    }

    private static void m_111058_(PoseStack.Pose matrixEntry, VertexConsumer buffer, float red, float green, float blue, List<BakedQuad> listQuads, int combinedLightIn, int combinedOverlayIn) {
        boolean emissive = EmissiveTextures.isActive();
        for (BakedQuad bakedquad : listQuads) {
            float f2;
            float f1;
            float f3;
            if (emissive && (bakedquad = EmissiveTextures.getEmissiveQuad((BakedQuad)bakedquad)) == null) continue;
            if (bakedquad.m_111304_()) {
                f3 = Mth.m_14036_((float)red, (float)0.0f, (float)1.0f);
                f1 = Mth.m_14036_((float)green, (float)0.0f, (float)1.0f);
                f2 = Mth.m_14036_((float)blue, (float)0.0f, (float)1.0f);
            } else {
                f3 = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            buffer.m_85987_(matrixEntry, bakedquad, f3, f1, f2, combinedLightIn, combinedOverlayIn);
        }
    }

    public static void m_111000_() {
        ((Cache)f_110996_.get()).m_111220_();
    }

    public static void m_111077_() {
        ((Cache)f_110996_.get()).m_111225_();
    }

    public static float fixAoLightValue(float val) {
        if (val == 0.2f) {
            return aoLightValueOpaque;
        }
        return val;
    }

    public static void updateAoLightValue() {
        aoLightValueOpaque = 1.0f - Config.getAmbientOcclusionLevel() * 0.8f;
        separateAoLightValue = Config.isShaders() && Shaders.isSeparateAo();
    }

    public static boolean isSeparateAoLightValue() {
        return separateAoLightValue;
    }

    private void renderOverlayModels(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixStackIn, VertexConsumer buffer, int combinedOverlayIn, boolean checkSides, RandomSource random, long rand, RenderEnv renderEnv, boolean smooth, Vec3 renderOffset) {
        if (renderEnv.isOverlaysRendered()) {
            for (int l2 = 0; l2 < OVERLAY_LAYERS.length; ++l2) {
                RenderType layer = OVERLAY_LAYERS[l2];
                ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(layer);
                if (listQuadsOverlay.size() <= 0) continue;
                ChunkBufferBuilderPack rrcb = renderEnv.getRegionRenderCacheBuilder();
                if (rrcb != null) {
                    BufferBuilder overlayBuffer = rrcb.m_108839_(layer);
                    if (!overlayBuffer.m_85732_()) {
                        overlayBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
                    }
                    for (int q2 = 0; q2 < listQuadsOverlay.size(); ++q2) {
                        BakedQuad quad = listQuadsOverlay.getQuad(q2);
                        List listQuadSingle = listQuadsOverlay.getListQuadsSingle(quad);
                        BlockState quadBlockState = listQuadsOverlay.getBlockState(q2);
                        if (quad.getQuadEmissive() != null) {
                            listQuadsOverlay.addQuad(quad.getQuadEmissive(), quadBlockState);
                        }
                        renderEnv.reset(quadBlockState, posIn);
                        if (smooth) {
                            this.renderQuadsSmooth(worldIn, quadBlockState, posIn, matrixStackIn, (VertexConsumer)overlayBuffer, listQuadSingle, combinedOverlayIn, renderEnv);
                            continue;
                        }
                        int col = LevelRenderer.m_109537_((BlockAndTintGetter)worldIn, (BlockState)quadBlockState, (BlockPos)posIn.m_121945_(quad.m_111306_()));
                        this.renderQuadsFlat(worldIn, quadBlockState, posIn, col, combinedOverlayIn, false, matrixStackIn, (VertexConsumer)overlayBuffer, listQuadSingle, renderEnv);
                    }
                }
                listQuadsOverlay.clear();
            }
        }
        if (Config.isBetterSnow() && !renderEnv.isBreakingAnimation() && BetterSnow.shouldRender((BlockAndTintGetter)worldIn, (BlockState)stateIn, (BlockPos)posIn)) {
            BakedModel modelSnow = BetterSnow.getModelSnowLayer();
            BlockState stateSnow = BetterSnow.getStateSnowLayer();
            matrixStackIn.m_85837_(-renderOffset.f_82479_, -renderOffset.f_82480_, -renderOffset.f_82481_);
            this.m_234379_(worldIn, modelSnow, stateSnow, posIn, matrixStackIn, buffer, checkSides, random, rand, combinedOverlayIn);
        }
    }
}

