/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class VertexFormat {
    private ImmutableList<VertexFormatElement> f_86012_;
    private ImmutableMap<String, VertexFormatElement> f_166905_;
    private IntList f_86013_ = new IntArrayList();
    private int f_86014_;
    @Nullable
    private VertexBuffer f_231232_;
    private String name;
    private int positionElementOffset = -1;
    private int normalElementOffset = -1;
    private int colorElementOffset = -1;
    private Int2IntMap uvOffsetsById = new Int2IntArrayMap();

    public VertexFormat(ImmutableMap<String, VertexFormatElement> p_i166909_1_) {
        this.f_166905_ = p_i166909_1_;
        this.f_86012_ = p_i166909_1_.values().asList();
        int i2 = 0;
        for (VertexFormatElement vertexformatelement : p_i166909_1_.values()) {
            this.f_86013_.add(i2);
            VertexFormatElement.Usage usage = vertexformatelement.m_86048_();
            if (usage == VertexFormatElement.Usage.POSITION) {
                this.positionElementOffset = i2;
            } else if (usage == VertexFormatElement.Usage.NORMAL) {
                this.normalElementOffset = i2;
            } else if (usage == VertexFormatElement.Usage.COLOR) {
                this.colorElementOffset = i2;
            } else if (usage == VertexFormatElement.Usage.UV) {
                this.uvOffsetsById.put(vertexformatelement.m_86049_(), i2);
            }
            i2 += vertexformatelement.m_86050_();
        }
        this.f_86014_ = i2;
    }

    public String toString() {
        return "format: " + this.name + " " + this.f_166905_.size() + " elements: " + this.f_166905_.entrySet().stream().map(Object::toString).collect(Collectors.joining(" "));
    }

    public int m_86017_() {
        return this.m_86020_() / 4;
    }

    public int m_86020_() {
        return this.f_86014_;
    }

    public ImmutableList<VertexFormatElement> m_86023_() {
        return this.f_86012_;
    }

    public ImmutableList<String> m_166911_() {
        return this.f_166905_.keySet().asList();
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
            VertexFormat vertexformat = (VertexFormat)p_equals_1_;
            return this.f_86014_ != vertexformat.f_86014_ ? false : this.f_166905_.equals((Object)vertexformat.f_166905_);
        }
        return false;
    }

    public int hashCode() {
        return this.f_166905_.hashCode();
    }

    public void m_166912_() {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(() -> this.m_166916_());
        } else {
            this.m_166916_();
        }
    }

    private void m_166916_() {
        int i2 = this.m_86020_();
        ImmutableList list = this.m_86023_();
        for (int j2 = 0; j2 < list.size(); ++j2) {
            VertexFormatElement vfe = (VertexFormatElement)list.get(j2);
            int attributeIndex = vfe.getAttributeIndex(j2);
            if (attributeIndex < 0) continue;
            vfe.m_166965_(attributeIndex, (long)this.f_86013_.getInt(j2), i2);
        }
    }

    public void m_86024_() {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(() -> this.m_166917_());
        } else {
            this.m_166917_();
        }
    }

    private void m_166917_() {
        ImmutableList immutablelist = this.m_86023_();
        for (int i2 = 0; i2 < immutablelist.size(); ++i2) {
            VertexFormatElement vertexformatelement = (VertexFormatElement)immutablelist.get(i2);
            int attributeIndex = vertexformatelement.getAttributeIndex(i2);
            if (attributeIndex < 0) continue;
            vertexformatelement.m_166963_(attributeIndex);
        }
    }

    public VertexBuffer m_231233_() {
        VertexBuffer vertexbuffer = this.f_231232_;
        if (vertexbuffer == null) {
            this.f_231232_ = vertexbuffer = new VertexBuffer();
        }
        return vertexbuffer;
    }

    public int getOffset(int index) {
        return this.f_86013_.getInt(index);
    }

    public boolean hasPosition() {
        return this.positionElementOffset >= 0;
    }

    public int getPositionOffset() {
        return this.positionElementOffset;
    }

    public boolean hasNormal() {
        return this.normalElementOffset >= 0;
    }

    public int getNormalOffset() {
        return this.normalElementOffset;
    }

    public boolean hasColor() {
        return this.colorElementOffset >= 0;
    }

    public int getColorOffset() {
        return this.colorElementOffset;
    }

    public boolean hasUV(int id) {
        return this.uvOffsetsById.containsKey(id);
    }

    public int getUvOffsetById(int id) {
        return this.uvOffsetsById.get(id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void copyFrom(VertexFormat vf) {
        this.f_86012_ = vf.f_86012_;
        this.f_166905_ = vf.f_166905_;
        this.f_86013_ = vf.f_86013_;
        this.f_86014_ = vf.f_86014_;
        this.f_231232_ = vf.f_231232_;
        this.name = vf.name;
        this.positionElementOffset = vf.positionElementOffset;
        this.normalElementOffset = vf.normalElementOffset;
        this.colorElementOffset = vf.colorElementOffset;
        this.uvOffsetsById = vf.uvOffsetsById;
    }

    public VertexFormat duplicate() {
        VertexFormat vf = new VertexFormat(ImmutableMap.of());
        vf.copyFrom(this);
        return vf;
    }

    public ImmutableMap<String, VertexFormatElement> getElementMapping() {
        return this.f_166905_;
    }
}

