/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.IForgeVertexConsumer;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntities;
import net.optifine.reflect.Reflector;
import net.optifine.render.RenderEnv;
import net.optifine.render.VertexPosition;
import net.optifine.shaders.Shaders;

/*
 * Exception performing whole class analysis ignored.
 */
public interface VertexConsumer
extends IForgeVertexConsumer {
    public static final ThreadLocal<RenderEnv> RENDER_ENV = ThreadLocal.withInitial(() -> new RenderEnv(Blocks.f_50016_.m_49966_(), new BlockPos(0, 0, 0)));
    public static final boolean FORGE = Reflector.ForgeHooksClient.exists();

    default public RenderEnv getRenderEnv(BlockState blockState, BlockPos blockPos) {
        RenderEnv renderEnv = (RenderEnv)RENDER_ENV.get();
        renderEnv.reset(blockState, blockPos);
        return renderEnv;
    }

    public VertexConsumer m_5483_(double var1, double var3, double var5);

    public VertexConsumer m_6122_(int var1, int var2, int var3, int var4);

    public VertexConsumer m_7421_(float var1, float var2);

    public VertexConsumer m_7122_(int var1, int var2);

    public VertexConsumer m_7120_(int var1, int var2);

    public VertexConsumer m_5601_(float var1, float var2, float var3);

    public void m_5752_();

    default public void m_5954_(float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        this.m_5483_((double)x, (double)y, (double)z);
        this.m_85950_(red, green, blue, alpha);
        this.m_7421_(texU, texV);
        this.m_86008_(overlayUV);
        this.m_85969_(lightmapUV);
        this.m_5601_(normalX, normalY, normalZ);
        this.m_5752_();
    }

    public void m_7404_(int var1, int var2, int var3, int var4);

    public void m_141991_();

    default public VertexConsumer m_85950_(float red, float green, float blue, float alpha) {
        return this.m_6122_((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    default public VertexConsumer m_193479_(int colorIn) {
        return this.m_6122_(FastColor.ARGB32.m_13665_((int)colorIn), FastColor.ARGB32.m_13667_((int)colorIn), FastColor.ARGB32.m_13669_((int)colorIn), FastColor.ARGB32.m_13655_((int)colorIn));
    }

    default public VertexConsumer m_85969_(int lightmapUV) {
        return this.m_7120_(lightmapUV & 0xFFFF, lightmapUV >> 16 & 0xFFFF);
    }

    default public VertexConsumer m_86008_(int overlayUV) {
        return this.m_7122_(overlayUV & 0xFFFF, overlayUV >> 16 & 0xFFFF);
    }

    default public void m_85987_(PoseStack.Pose matrixEntryIn, BakedQuad quadIn, float redIn, float greenIn, float blueIn, int combinedLightIn, int combinedOverlayIn) {
        this.m_85995_(matrixEntryIn, quadIn, this.getTempFloat4(1.0f, 1.0f, 1.0f, 1.0f), redIn, greenIn, blueIn, this.getTempInt4(combinedLightIn, combinedLightIn, combinedLightIn, combinedLightIn), combinedOverlayIn, false);
    }

    default public void putBulkData(PoseStack.Pose matrixEntry, BakedQuad bakedQuad, float[] baseBrightness, float red, float green, float blue, float alpha, int[] lightmapCoords, int overlayCoords, boolean readExistingColor) {
        this.addQuad(matrixEntry, bakedQuad, baseBrightness, red, green, blue, alpha, lightmapCoords, overlayCoords, readExistingColor);
    }

    default public void putBulkData(PoseStack.Pose matrixEntry, BakedQuad bakedQuad, float red, float green, float blue, float alpha, int packedLight, int packedOverlay, boolean readExistingColor) {
        this.addQuad(matrixEntry, bakedQuad, this.getTempFloat4(1.0f, 1.0f, 1.0f, 1.0f), red, green, blue, alpha, this.getTempInt4(packedLight, packedLight, packedLight, packedLight), packedOverlay, readExistingColor);
    }

    default public void m_85995_(PoseStack.Pose matrixEntryIn, BakedQuad quadIn, float[] colorMuls, float redIn, float greenIn, float blueIn, int[] combinedLightsIn, int combinedOverlayIn, boolean mulColor) {
        this.addQuad(matrixEntryIn, quadIn, colorMuls, redIn, greenIn, blueIn, 1.0f, combinedLightsIn, combinedOverlayIn, mulColor);
    }

    default public void addQuad(PoseStack.Pose matrixEntryIn, BakedQuad quadIn, float[] colorMuls, float redIn, float greenIn, float blueIn, float alphaIn, int[] combinedLightsIn, int combinedOverlayIn, boolean mulColor) {
        IRandomEntity entity;
        boolean shadersVelocity;
        float[] afloat = colorMuls;
        int[] aint = combinedLightsIn;
        int[] aint1 = this.isMultiTexture() ? quadIn.getVertexDataSingle() : quadIn.m_111303_();
        this.putSprite(quadIn.m_173410_());
        boolean separateAoInAlpha = ModelBlockRenderer.isSeparateAoLightValue();
        Vec3i vector3i = quadIn.m_111306_().m_122436_();
        float xv = vector3i.m_123341_();
        float yv = vector3i.m_123342_();
        float zv = vector3i.m_123343_();
        Matrix4f matrix4f = matrixEntryIn.m_85861_();
        Matrix3f matrixNormal = matrixEntryIn.m_85864_();
        float xn = matrixNormal.getTransformX(xv, yv, zv);
        float yn = matrixNormal.getTransformY(xv, yv, zv);
        float zn = matrixNormal.getTransformZ(xv, yv, zv);
        int i2 = 8;
        int vertexIntSize = DefaultVertexFormat.f_85811_.m_86017_();
        int j2 = aint1.length / vertexIntSize;
        boolean bl = shadersVelocity = Config.isShaders() && Shaders.useVelocityAttrib && Config.isMinecraftThread();
        if (shadersVelocity && (entity = RandomEntities.getRandomEntityRendered()) != null) {
            VertexPosition[] quadPos = quadIn.getVertexPositions(entity.getId());
            this.setQuadVertexPositions(quadPos);
        }
        for (int k2 = 0; k2 < j2; ++k2) {
            Vector3f forgeNormals;
            float f5;
            float f4;
            float f3;
            float colorMulAo;
            int pos = k2 * vertexIntSize;
            float f2 = Float.intBitsToFloat(aint1[pos + 0]);
            float f1 = Float.intBitsToFloat(aint1[pos + 1]);
            float f22 = Float.intBitsToFloat(aint1[pos + 2]);
            float ca = 1.0f;
            float f6 = colorMulAo = separateAoInAlpha ? 1.0f : afloat[k2];
            if (mulColor) {
                int col = aint1[pos + 3];
                float f62 = (float)(col & 0xFF) / 255.0f;
                float f7 = (float)(col >> 8 & 0xFF) / 255.0f;
                float f8 = (float)(col >> 16 & 0xFF) / 255.0f;
                f3 = f62 * colorMulAo * redIn;
                f4 = f7 * colorMulAo * greenIn;
                f5 = f8 * colorMulAo * blueIn;
                if (FORGE) {
                    float a2 = (float)(col >> 24 & 0xFF) / 255.0f;
                    ca = a2 * alphaIn;
                }
            } else {
                f3 = colorMulAo * redIn;
                f4 = colorMulAo * greenIn;
                f5 = colorMulAo * blueIn;
                if (FORGE) {
                    ca = alphaIn;
                }
            }
            int l2 = aint[k2];
            if (FORGE) {
                l2 = this.applyBakedLighting(aint[k2], aint1, pos);
            }
            float f9 = Float.intBitsToFloat(aint1[pos + 4]);
            float f10 = Float.intBitsToFloat(aint1[pos + 5]);
            float xt = matrix4f.getTransformX(f2, f1, f22, 1.0f);
            float yt = matrix4f.getTransformY(f2, f1, f22, 1.0f);
            float zt = matrix4f.getTransformZ(f2, f1, f22, 1.0f);
            if (FORGE && (forgeNormals = this.applyBakedNormals(aint1, pos, matrixEntryIn.m_85864_())) != null) {
                xn = forgeNormals.m_122239_();
                yn = forgeNormals.m_122260_();
                zn = forgeNormals.m_122269_();
            }
            if (separateAoInAlpha) {
                ca = afloat[k2];
            }
            this.m_5954_(xt, yt, zt, f3, f4, f5, ca, f9, f10, combinedOverlayIn, l2, xn, yn, zn);
        }
    }

    default public VertexConsumer m_85982_(Matrix4f matrixIn, float x, float y, float z) {
        float xt = matrixIn.getTransformX(x, y, z, 1.0f);
        float yt = matrixIn.getTransformY(x, y, z, 1.0f);
        float zt = matrixIn.getTransformZ(x, y, z, 1.0f);
        return this.m_5483_((double)xt, (double)yt, (double)zt);
    }

    default public VertexConsumer m_85977_(Matrix3f matrixIn, float x, float y, float z) {
        float xt = matrixIn.getTransformX(x, y, z);
        float yt = matrixIn.getTransformY(x, y, z);
        float zt = matrixIn.getTransformZ(x, y, z);
        return this.m_5601_(xt, yt, zt);
    }

    default public void putSprite(TextureAtlasSprite sprite) {
    }

    default public void setSprite(TextureAtlasSprite sprite) {
    }

    default public boolean isMultiTexture() {
        return false;
    }

    default public void setRenderType(RenderType layer) {
    }

    default public RenderType getRenderType() {
        return null;
    }

    default public void setRenderBlocks(boolean renderBlocks) {
    }

    default public Vector3f getTempVec3f(Vector3f vec) {
        return vec.m_122281_();
    }

    default public Vector3f getTempVec3f(float x, float y, float z) {
        return new Vector3f(x, y, z);
    }

    default public float[] getTempFloat4(float f1, float f2, float f3, float f4) {
        return new float[]{f1, f2, f3, f4};
    }

    default public int[] getTempInt4(int i1, int i2, int i3, int i4) {
        return new int[]{i1, i2, i3, i4};
    }

    default public MultiBufferSource.BufferSource getRenderTypeBuffer() {
        return null;
    }

    default public void setQuadVertexPositions(VertexPosition[] vps) {
    }

    default public void setMidBlock(float mbx, float mby, float mbz) {
    }

    default public VertexConsumer getSecondaryBuilder() {
        return null;
    }

    default public int getVertexCount() {
        return 0;
    }

    default public int applyBakedLighting(int lightmapCoord, int[] data, int pos) {
        int offsetInt = VertexConsumer.getLightOffset((int)0);
        int blBaked = LightTexture.m_109883_((int)data[pos + offsetInt]);
        int slBaked = LightTexture.m_109894_((int)data[pos + offsetInt]);
        if (blBaked == 0 && slBaked == 0) {
            return lightmapCoord;
        }
        int bl = LightTexture.m_109883_((int)lightmapCoord);
        int sl = LightTexture.m_109894_((int)lightmapCoord);
        bl = Math.max(bl, blBaked);
        sl = Math.max(sl, slBaked);
        return LightTexture.m_109885_((int)bl, (int)sl);
    }

    public static int getLightOffset(int v) {
        return v * 8 + 6;
    }

    default public Vector3f applyBakedNormals(int[] data, int pos, Matrix3f normalTransform) {
        int offsetNormal = 7;
        int val = data[pos + offsetNormal];
        byte nx = (byte)(val >> 0 & 0xFF);
        byte ny = (byte)(val >> 8 & 0xFF);
        byte nz = (byte)(val >> 16 & 0xFF);
        if (nx != 0 || ny != 0 || nz != 0) {
            Vector3f generated = this.getTempVec3f((float)nx / 127.0f, (float)ny / 127.0f, (float)nz / 127.0f);
            generated.m_122249_(normalTransform);
            return generated;
        }
        return null;
    }
}

