/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.optifine.Config;
import net.optifine.render.MultiTextureData;
import net.optifine.render.MultiTextureRenderer;
import net.optifine.render.VboRange;
import net.optifine.render.VboRegion;
import net.optifine.shaders.SVertexBuilder;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersRender;

public class VertexBuffer
implements AutoCloseable {
    private int f_231217_;
    private int f_166860_;
    private int f_166862_;
    @Nullable
    private VertexFormat f_85917_;
    @Nullable
    private RenderSystem.AutoStorageIndexBuffer f_166865_;
    private VertexFormat.IndexType f_166861_;
    private int f_166863_;
    private VertexFormat.Mode f_166864_;
    private VboRegion vboRegion;
    private VboRange vboRange;
    private MultiTextureData multiTextureData;

    public VertexBuffer() {
        RenderSystem.m_187554_();
        this.f_231217_ = GlStateManager.m_84537_();
        this.f_166860_ = GlStateManager.m_84537_();
        this.f_166862_ = GlStateManager.m_157089_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_231221_(BufferBuilder.RenderedBuffer bufferIn) {
        if (!this.m_231230_()) {
            RenderSystem.m_187554_();
            try {
                BufferBuilder.DrawState bufferbuilder$drawstate = bufferIn.m_231198_();
                this.f_85917_ = this.m_231218_(bufferbuilder$drawstate, bufferIn.m_231196_());
                this.f_166865_ = this.m_231223_(bufferbuilder$drawstate, bufferIn.m_231197_());
                this.f_166863_ = bufferbuilder$drawstate.f_166797_();
                this.f_166861_ = bufferbuilder$drawstate.f_166798_();
                this.f_166864_ = bufferbuilder$drawstate.f_85735_();
                BufferBuilder.DrawState drawState = bufferbuilder$drawstate;
                if (this.vboRegion != null) {
                    ByteBuffer data = bufferIn.m_231196_();
                    data.position(0);
                    data.limit(drawState.m_166812_());
                    this.vboRegion.bufferData(data, this.vboRange);
                    data.position(0);
                    data.limit(drawState.m_166813_());
                    return;
                }
                this.multiTextureData = bufferbuilder$drawstate.getMultiTextureData();
            }
            finally {
                bufferIn.m_231200_();
            }
        }
    }

    private VertexFormat m_231218_(BufferBuilder.DrawState drawStateIn, ByteBuffer bufferIn) {
        if (this.vboRegion != null) {
            return drawStateIn.f_85733_();
        }
        boolean flag = false;
        if (!drawStateIn.f_85733_().equals((Object)this.f_85917_)) {
            if (this.f_85917_ != null) {
                this.f_85917_.m_86024_();
            }
            GlStateManager.m_84480_((int)34962, (int)this.f_231217_);
            drawStateIn.f_85733_().m_166912_();
            if (Config.isShaders()) {
                ShadersRender.setupArrayPointersVbo();
            }
            flag = true;
        }
        if (!drawStateIn.f_166799_()) {
            if (!flag) {
                GlStateManager.m_84480_((int)34962, (int)this.f_231217_);
            }
            RenderSystem.m_69525_((int)34962, (ByteBuffer)bufferIn, (int)35044);
        }
        return drawStateIn.f_85733_();
    }

    @Nullable
    private RenderSystem.AutoStorageIndexBuffer m_231223_(BufferBuilder.DrawState drawStateIn, ByteBuffer bufferIn) {
        if (!drawStateIn.f_166800_()) {
            if (this.vboRegion != null) {
                return null;
            }
            GlStateManager.m_84480_((int)34963, (int)this.f_166860_);
            RenderSystem.m_69525_((int)34963, (ByteBuffer)bufferIn, (int)35044);
            return null;
        }
        RenderSystem.AutoStorageIndexBuffer rendersystem$autostorageindexbuffer = RenderSystem.m_221941_((VertexFormat.Mode)drawStateIn.f_85735_());
        int indexCount = drawStateIn.f_166797_();
        if (this.vboRegion != null && drawStateIn.f_85735_() == VertexFormat.Mode.QUADS) {
            indexCount = 65536;
        }
        if (rendersystem$autostorageindexbuffer != this.f_166865_ || !rendersystem$autostorageindexbuffer.m_221944_(indexCount)) {
            rendersystem$autostorageindexbuffer.m_221946_(indexCount);
        }
        return rendersystem$autostorageindexbuffer;
    }

    public void m_85921_() {
        BufferUploader.m_231208_();
        if (this.f_166862_ >= 0) {
            GlStateManager.m_157068_((int)this.f_166862_);
        }
    }

    public static void m_85931_() {
        BufferUploader.m_231208_();
        GlStateManager.m_157068_((int)0);
    }

    public void m_166882_() {
        if (this.vboRegion != null) {
            this.vboRegion.drawArrays(VertexFormat.Mode.QUADS, this.vboRange);
        } else if (this.multiTextureData != null) {
            MultiTextureRenderer.draw((VertexFormat.Mode)this.f_166864_, (int)this.m_231231_().f_166923_, (MultiTextureData)this.multiTextureData);
        } else {
            RenderSystem.m_157186_((int)this.f_166864_.f_166946_, (int)this.f_166863_, (int)this.m_231231_().f_166923_);
        }
    }

    private VertexFormat.IndexType m_231231_() {
        RenderSystem.AutoStorageIndexBuffer rendersystem$autostorageindexbuffer = this.f_166865_;
        return rendersystem$autostorageindexbuffer != null ? rendersystem$autostorageindexbuffer.m_157483_() : this.f_166861_;
    }

    public void m_166867_(Matrix4f matrixIn, Matrix4f projectionIn, ShaderInstance shaderIn) {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(() -> this.m_166876_(matrixIn.m_27658_(), projectionIn.m_27658_(), shaderIn));
        } else {
            this.m_166876_(matrixIn, projectionIn, shaderIn);
        }
    }

    private void m_166876_(Matrix4f matrixIn, Matrix4f projectionIn, ShaderInstance shaderIn) {
        boolean isShaderArrays;
        for (int i2 = 0; i2 < 12; ++i2) {
            int j2 = RenderSystem.m_157203_((int)i2);
            shaderIn.setSampler(i2, (Object)j2);
        }
        if (shaderIn.f_173308_ != null) {
            shaderIn.f_173308_.m_5679_(matrixIn);
        }
        if (shaderIn.f_173309_ != null) {
            shaderIn.f_173309_.m_5679_(projectionIn);
        }
        if (shaderIn.f_200956_ != null) {
            shaderIn.f_200956_.m_200759_(RenderSystem.m_200906_());
        }
        if (shaderIn.f_173312_ != null) {
            shaderIn.f_173312_.m_5941_(RenderSystem.m_157197_());
        }
        if (shaderIn.f_173315_ != null) {
            shaderIn.f_173315_.m_5985_(RenderSystem.m_157200_());
        }
        if (shaderIn.f_173316_ != null) {
            shaderIn.f_173316_.m_5985_(RenderSystem.m_157199_());
        }
        if (shaderIn.f_173317_ != null) {
            shaderIn.f_173317_.m_5941_(RenderSystem.m_157198_());
        }
        if (shaderIn.f_202432_ != null) {
            shaderIn.f_202432_.m_142617_(RenderSystem.m_202041_().m_202324_());
        }
        if (shaderIn.f_173310_ != null) {
            shaderIn.f_173310_.m_5679_(RenderSystem.m_157207_());
        }
        if (shaderIn.f_173319_ != null) {
            shaderIn.f_173319_.m_5985_(RenderSystem.m_157201_());
        }
        if (shaderIn.f_173311_ != null) {
            Window window = Minecraft.m_91087_().m_91268_();
            shaderIn.f_173311_.m_7971_((float)window.m_85441_(), (float)window.m_85442_());
        }
        if (shaderIn.f_173318_ != null && (this.f_166864_ == VertexFormat.Mode.LINES || this.f_166864_ == VertexFormat.Mode.LINE_STRIP)) {
            shaderIn.f_173318_.m_5985_(RenderSystem.m_157202_());
        }
        RenderSystem.m_157461_((ShaderInstance)shaderIn);
        shaderIn.m_173363_();
        boolean isShaders = Config.isShaders() && Shaders.isRenderingWorld;
        boolean bl = isShaderArrays = isShaders && SVertexBuilder.preDrawArrays((VertexFormat)this.f_85917_);
        if (isShaders) {
            Shaders.setModelViewMatrix((Matrix4f)matrixIn);
            Shaders.setProjectionMatrix((Matrix4f)projectionIn);
            Shaders.setTextureMatrix((Matrix4f)RenderSystem.m_157207_());
            Shaders.setColorModulator((float[])RenderSystem.m_157197_());
        }
        this.m_166882_();
        if (isShaderArrays) {
            SVertexBuilder.postDrawArrays();
        }
        shaderIn.m_173362_();
    }

    @Override
    public void close() {
        if (this.f_231217_ >= 0) {
            RenderSystem.m_69529_((int)this.f_231217_);
            this.f_231217_ = -1;
        }
        if (this.f_166860_ >= 0) {
            RenderSystem.m_69529_((int)this.f_166860_);
            this.f_166860_ = -1;
        }
        if (this.f_166862_ >= 0) {
            RenderSystem.m_157213_((int)this.f_166862_);
            this.f_166862_ = -1;
        }
    }

    public VertexFormat m_166892_() {
        return this.f_85917_;
    }

    public boolean m_231230_() {
        if (this.vboRegion != null) {
            return false;
        }
        return this.f_166862_ == -1;
    }

    public void setVboRegion(VboRegion vboRegion) {
        if (vboRegion == null) {
            return;
        }
        this.close();
        this.vboRegion = vboRegion;
        this.vboRange = new VboRange();
    }

    public VboRegion getVboRegion() {
        return this.vboRegion;
    }
}

