/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.util.JsonConfig;

public class PriorityStore<T> {
    private final Object2IntMap<ResourceLocation> priorities = new Object2IntLinkedOpenHashMap();
    private final Function<T, ResourceLocation> uidGetter;
    private final ToIntFunction<T> defaultGetter;
    private final String fileName;
    private ImmutableList<ResourceLocation> sortedList = ImmutableList.of();

    public PriorityStore(String filename, ToIntFunction<T> defaultGetter, Function<T, ResourceLocation> uidGetter) {
        this.fileName = filename;
        this.defaultGetter = defaultGetter;
        this.uidGetter = uidGetter;
    }

    public void put(T provider) {
        Objects.requireNonNull(provider);
        ResourceLocation uid = this.uidGetter.apply(provider);
        Objects.requireNonNull(uid);
        this.priorities.put((Object)uid, this.defaultGetter.applyAsInt(provider));
    }

    public void updateConfig(Set<ResourceLocation> allKeys) {
        Type type = new TypeToken<LinkedHashMap<ResourceLocation, Integer>>(){}.getType();
        JsonConfig<Map> config = new JsonConfig<Map>(this.fileName, type, null, LinkedHashMap::new);
        Map map = config.get();
        for (Map.Entry e : map.entrySet()) {
            if (e.getValue() == null) continue;
            this.priorities.put((Object)((ResourceLocation)e.getKey()), ((Integer)e.getValue()).intValue());
        }
        new Thread(() -> {
            for (ResourceLocation id : this.priorities.keySet()) {
                if (map.containsKey(id)) continue;
                map.put(id, null);
            }
            config.save();
        }).start();
        List keys = allKeys.stream().filter($ -> !$.m_135815_().contains(".")).sorted(Comparator.comparingInt(this::get)).collect(Collectors.toCollection(LinkedList::new));
        allKeys.stream().filter($ -> $.m_135815_().contains(".")).forEach($ -> {
            ResourceLocation parent = new ResourceLocation($.m_135827_(), $.m_135815_().substring(0, $.m_135815_().indexOf(46)));
            int index = keys.indexOf(parent);
            keys.add(index + 1, $);
        });
        this.sortedList = ImmutableList.copyOf((Collection)keys);
    }

    public int get(T value) {
        return this.get(this.uidGetter.apply(value));
    }

    public int get(ResourceLocation id) {
        return this.priorities.getInt((Object)id);
    }

    public ImmutableList<ResourceLocation> getSortedList() {
        return this.sortedList;
    }
}

