/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.config.value.CycleOptionValue;
import snownee.jade.gui.config.value.InputOptionValue;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.gui.config.value.SliderOptionValue;
import snownee.jade.util.ClientPlatformProxy;

public class WailaOptionsList
extends ContainerObjectSelectionList<Entry> {
    private BaseOptionsScreen owner;
    private final Runnable diskWriter;
    private double targetScroll;

    public WailaOptionsList(BaseOptionsScreen owner, Minecraft client, int width, int height, int y0, int y1, int entryHeight, Runnable diskWriter) {
        super(client, width, height, y0, y1, entryHeight);
        this.owner = owner;
        this.diskWriter = diskWriter;
    }

    public WailaOptionsList(BaseOptionsScreen owner, Minecraft client, int width, int height, int y0, int y1, int entryHeight) {
        this(owner, client, width, height, y0, y1, entryHeight, null);
    }

    public int m_5759_() {
        return Math.min(this.f_93388_, 300);
    }

    protected int m_5756_() {
        return this.f_93388_ - 6;
    }

    public void m_93410_(double d) {
        super.m_93410_(d);
        this.targetScroll = this.m_93517_();
    }

    public boolean m_6050_(double d, double e, double f) {
        double speed = !ClientPlatformProxy.hasFastScroll && Screen.m_96637_() ? 4.5 : 1.5;
        this.targetScroll = this.m_93517_() - f * (double)this.f_93387_ * speed;
        return true;
    }

    protected boolean m_5694_() {
        return this.owner.m_7222_() == this;
    }

    protected boolean m_7987_(int i) {
        return Objects.equals(this.m_93511_(), this.m_6702_().get(i));
    }

    protected void m_240140_(PoseStack poseStack, int i, int j, int k, int l, int m) {
        AbstractSelectionList.m_93172_((PoseStack)poseStack, (int)0, (int)(i - 2), (int)this.owner.f_96543_, (int)(i + k + 2), (int)0x33FFFFFF);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float delta) {
        super.m_93410_((this.targetScroll + super.m_93517_()) / 2.0);
        Entry entry = (Entry)this.m_93412_(mouseX, mouseY);
        this.m_6987_((AbstractSelectionList.Entry)entry);
        this.m_7733_(matrixStack);
        int scrollPosX = this.m_5756_();
        int j = scrollPosX + 6;
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93096_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_239227_(matrixStack, mouseX, mouseY, delta);
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93096_);
        RenderSystem.m_69482_();
        RenderSystem.m_69456_((int)519);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, -100.0).m_7421_(0.0f, (float)this.f_93390_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
        bufferBuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93390_, -100.0).m_7421_((float)this.f_93388_ / 32.0f, (float)this.f_93390_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
        bufferBuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), 0.0, -100.0).m_7421_((float)this.f_93388_ / 32.0f, 0.0f).m_6122_(64, 64, 64, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93393_, 0.0, -100.0).m_7421_(0.0f, 0.0f).m_6122_(64, 64, 64, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93393_, (double)this.f_93389_, -100.0).m_7421_(0.0f, (float)this.f_93389_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
        bufferBuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93389_, -100.0).m_7421_((float)this.f_93388_ / 32.0f, (float)this.f_93389_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
        bufferBuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93391_, -100.0).m_7421_((float)this.f_93388_ / 32.0f, (float)this.f_93391_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, -100.0).m_7421_(0.0f, (float)this.f_93391_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_((double)this.f_93393_, (double)(this.f_93390_ + 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93392_, (double)(this.f_93390_ + 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93392_, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93392_, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93392_, (double)(this.f_93391_ - 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93393_, (double)(this.f_93391_ - 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        tessellator.m_85914_();
        int int_8 = Math.max(0, this.m_5775_() - (this.f_93391_ - this.f_93390_ - 4));
        if (int_8 > 0) {
            RenderSystem.m_69472_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            int int_9 = (int)((float)((this.f_93391_ - this.f_93390_) * (this.f_93391_ - this.f_93390_)) / (float)this.m_5775_());
            int_9 = Mth.m_14045_((int)int_9, (int)32, (int)(this.f_93391_ - this.f_93390_ - 8));
            int int_10 = (int)this.m_93517_() * (this.f_93391_ - this.f_93390_ - int_9) / int_8 + this.f_93390_;
            if (int_10 < this.f_93390_) {
                int_10 = this.f_93390_;
            }
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            bufferBuilder.m_5483_((double)scrollPosX, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_((double)j, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_((double)j, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_7421_(1.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_((double)scrollPosX, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_7421_(0.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_((double)scrollPosX, (double)(int_10 + int_9), 0.0).m_6122_(128, 128, 128, 255).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_((double)j, (double)(int_10 + int_9), 0.0).m_6122_(128, 128, 128, 255).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_((double)j, (double)int_10, 0.0).m_6122_(128, 128, 128, 255).m_7421_(1.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_((double)scrollPosX, (double)int_10, 0.0).m_6122_(128, 128, 128, 255).m_7421_(0.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_((double)scrollPosX, (double)(int_10 + int_9 - 1), 0.0).m_6122_(192, 192, 192, 255).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_((double)(j - 1), (double)(int_10 + int_9 - 1), 0.0).m_6122_(192, 192, 192, 255).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_((double)(j - 1), (double)int_10, 0.0).m_6122_(192, 192, 192, 255).m_7421_(1.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_((double)scrollPosX, (double)int_10, 0.0).m_6122_(192, 192, 192, 255).m_7421_(0.0f, 0.0f).m_5752_();
            tessellator.m_85914_();
        }
        this.m_7415_(matrixStack, mouseX, mouseY);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    public void save() {
        this.m_6702_().stream().filter(e -> e instanceof OptionValue).map(e -> (OptionValue)((Object)e)).forEach(OptionValue::save);
        if (this.diskWriter != null) {
            this.diskWriter.run();
        }
    }

    public <T extends Entry> T add(T entry) {
        this.m_7085_((AbstractSelectionList.Entry)entry);
        return entry;
    }

    public MutableComponent title(String string) {
        return this.add(new Title(string)).getTitle();
    }

    public OptionValue<?> slider(String optionName, float value, Consumer<Float> setter) {
        return this.slider(optionName, value, setter, 0.0f, 1.0f, FloatUnaryOperator.identity());
    }

    public OptionValue<?> slider(String optionName, float value, Consumer<Float> setter, float min, float max, FloatUnaryOperator aligner) {
        return this.add(new SliderOptionValue(optionName, value, setter, min, max, aligner));
    }

    public <T> OptionValue<?> input(String optionName, T value, Consumer<T> setter, Predicate<String> validator) {
        return this.add(new InputOptionValue<T>(optionName, value, setter, validator));
    }

    public <T> OptionValue<?> input(String optionName, T value, Consumer<T> setter) {
        return this.input(optionName, value, setter, (Predicate<String>)Predicates.alwaysTrue());
    }

    public OptionValue<?> choices(String optionName, boolean value, BooleanConsumer setter) {
        return this.choices(optionName, value, setter, null);
    }

    public OptionValue<?> choices(String optionName, boolean value, BooleanConsumer setter, @Nullable Consumer<CycleButton.Builder<Boolean>> builderConsumer) {
        CycleButton.Builder builder = CycleButton.m_168919_();
        if (builderConsumer != null) {
            builderConsumer.accept((CycleButton.Builder<Boolean>)builder);
        }
        return this.add(new CycleOptionValue<Boolean>(optionName, (CycleButton.Builder<Boolean>)builder, value, (Consumer<Boolean>)setter));
    }

    public <T extends Enum<T>> OptionValue<?> choices(String optionName, T value, Consumer<T> setter) {
        return this.choices(optionName, value, setter, null);
    }

    public <T extends Enum<T>> OptionValue<?> choices(String optionName, T value, Consumer<T> setter, @Nullable Consumer<CycleButton.Builder<T>> builderConsumer) {
        List<Enum> values = Arrays.asList((Enum[])value.getClass().getEnumConstants());
        CycleButton.Builder builder = CycleButton.m_168894_(v -> Entry.makeTitle(optionName + "_" + v.name().toLowerCase(Locale.ENGLISH))).m_232502_(values);
        if (builderConsumer != null) {
            builderConsumer.accept(builder);
        }
        return this.add(new CycleOptionValue<T>(optionName, builder, value, setter));
    }

    public <T> OptionValue<?> choices(String optionName, T value, List<T> values, Consumer<T> setter) {
        return this.add(new CycleOptionValue<T>(optionName, CycleButton.m_168894_(v -> Component.m_237113_((String)v.toString())).m_232502_(values), value, setter));
    }

    public void onClose() {
        this.owner = null;
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        protected final Minecraft client = Minecraft.m_91087_();
        @Nullable
        protected String description;

        public static MutableComponent makeTitle(String key) {
            return Component.m_237115_((String)Entry.makeKey(key));
        }

        public static String makeKey(String key) {
            return Util.m_137492_((String)"config", (ResourceLocation)new ResourceLocation("jade", key));
        }

        public AbstractWidget getListener() {
            return null;
        }

        public abstract List<? extends AbstractWidget> m_6702_();

        public List<? extends NarratableEntry> m_142437_() {
            return this.m_6702_();
        }

        public abstract void m_6311_(PoseStack var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public void setDisabled(boolean b) {
            if (this.getListener() != null) {
                this.getListener().f_93623_ = !b;
            }
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        public int getTextX(int width) {
            return 0;
        }

        public int getTextWidth() {
            return 0;
        }
    }

    public static class Title
    extends Entry {
        private final MutableComponent title;
        private int x;

        public Title(String key) {
            this.title = Title.makeTitle(key);
            key = Title.makeKey(key + "_desc");
            if (I18n.m_118936_((String)key)) {
                this.description = I18n.m_118938_((String)key, (Object[])new Object[0]);
            }
        }

        public MutableComponent getTitle() {
            return this.title;
        }

        @Override
        public void m_6311_(PoseStack matrixStack, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            this.x = rowLeft;
            Font font = this.client.f_91062_;
            float f = this.getTextX(width);
            int n = rowTop + height / 4;
            Objects.requireNonNull(this.client.f_91062_);
            font.m_92763_(matrixStack, (Component)this.title, f, (float)(n + 9 / 2), 0xFFFFFF);
        }

        @Override
        public List<? extends AbstractWidget> m_6702_() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public int getTextX(int width) {
            return this.x + (width - this.client.f_91062_.m_92852_((FormattedText)this.title)) / 2;
        }

        @Override
        public int getTextWidth() {
            return this.client.f_91062_.m_92852_((FormattedText)this.title);
        }
    }
}

