/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.TooltipAccessor;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import snownee.jade.gui.config.WailaOptionsList;

public abstract class BaseOptionsScreen
extends Screen {
    private final Screen parent;
    private final Runnable saver;
    private final Runnable canceller;
    protected WailaOptionsList options;
    private final Set<GuiEventListener> entryWidgets = Sets.newIdentityHashSet();

    public BaseOptionsScreen(Screen parent, Component title, Runnable saver, Runnable canceller) {
        super(title);
        this.parent = parent;
        this.saver = saver;
        this.canceller = canceller;
    }

    public BaseOptionsScreen(Screen parent, String title, Runnable saver, Runnable canceller) {
        this(parent, (Component)WailaOptionsList.Entry.makeTitle(title), saver, canceller);
    }

    public BaseOptionsScreen(Screen parent, String title) {
        this(parent, title, null, null);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.entryWidgets.clear();
        this.options = this.createOptions();
        this.m_142416_((GuiEventListener)this.options);
        if (this.saver != null && this.canceller != null) {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 25, 100, 20, (Component)Component.m_237115_((String)"gui.done"), w -> {
                this.options.save();
                this.saver.run();
                this.f_96541_.m_91152_(this.parent);
            }));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ - 25, 100, 20, (Component)Component.m_237115_((String)"gui.cancel"), w -> {
                this.canceller.run();
                this.f_96541_.m_91152_(this.parent);
            }));
        } else {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 50, this.f_96544_ - 25, 100, 20, (Component)Component.m_237115_((String)"gui.done"), w -> {
                this.options.save();
                this.f_96541_.m_91152_(this.parent);
            }));
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.options.m_93511_() != null && mouseY >= 32 && mouseY <= this.f_96544_ - 32) {
            int valueX;
            WailaOptionsList.Entry entry = (WailaOptionsList.Entry)this.options.m_93511_();
            AbstractWidget widget = entry.getListener();
            if (widget instanceof TooltipAccessor && widget.f_93624_ && mouseX >= widget.f_93620_ && mouseY >= widget.f_93621_ && mouseX < widget.f_93620_ + widget.m_5711_() && mouseY < widget.f_93621_ + widget.m_93694_()) {
                this.m_96617_(matrixStack, ((TooltipAccessor)widget).m_141932_(), mouseX, mouseY);
            } else if (!Strings.isNullOrEmpty((String)entry.getDescription()) && mouseX >= (valueX = entry.getTextX(this.options.m_5759_())) && mouseX < valueX + entry.getTextWidth()) {
                List tooltip = this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)entry.getDescription()), 200);
                matrixStack.m_85836_();
                matrixStack.m_85837_(0.0, 0.0, 100.0);
                this.m_96617_(matrixStack, tooltip, mouseX, mouseY);
                RenderSystem.m_69482_();
                matrixStack.m_85849_();
            }
        }
    }

    public abstract WailaOptionsList createOptions();

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.options.m_6050_(mouseX, mouseY, delta);
    }

    public void m_7379_() {
        if (this.canceller != null) {
            this.canceller.run();
        }
        this.options.onClose();
        super.m_7379_();
    }

    public <T extends GuiEventListener & NarratableEntry> T addEntryWidget(T widget) {
        this.entryWidgets.add(widget);
        return (T)super.m_7787_(widget);
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_94697_) {
        boolean onList = this.options.m_5953_(mouseX, mouseY);
        for (GuiEventListener guieventlistener : this.m_6702_()) {
            if (!onList && this.entryWidgets.contains(guieventlistener) || !guieventlistener.m_6375_(mouseX, mouseY, p_94697_)) continue;
            this.m_7522_(guieventlistener);
            if (p_94697_ == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        return false;
    }

    public Optional<GuiEventListener> m_94729_(double mouseX, double mouseY) {
        boolean onList = this.options != null && this.options.m_5953_(mouseX, mouseY);
        for (GuiEventListener guieventlistener : this.m_6702_()) {
            if (!onList && this.entryWidgets.contains(guieventlistener) || !guieventlistener.m_5953_(mouseX, mouseY)) continue;
            return Optional.of(guieventlistener);
        }
        return Optional.empty();
    }
}

