/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.ComparatorBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.JadeClient;
import snownee.jade.addon.harvest.HarvestToolProvider;
import snownee.jade.addon.vanilla.AnimalOwnerProvider;
import snownee.jade.addon.vanilla.ArmorStandProvider;
import snownee.jade.addon.vanilla.BeehiveProvider;
import snownee.jade.addon.vanilla.BlockStatesProvider;
import snownee.jade.addon.vanilla.BrewingStandProvider;
import snownee.jade.addon.vanilla.ChickenEggProvider;
import snownee.jade.addon.vanilla.CommandBlockProvider;
import snownee.jade.addon.vanilla.CropProgressProvider;
import snownee.jade.addon.vanilla.EnchantmentPowerProvider;
import snownee.jade.addon.vanilla.EntityArmorProvider;
import snownee.jade.addon.vanilla.EntityHealthProvider;
import snownee.jade.addon.vanilla.FallingBlockProvider;
import snownee.jade.addon.vanilla.FurnaceProvider;
import snownee.jade.addon.vanilla.HorseStatsProvider;
import snownee.jade.addon.vanilla.ItemFrameProvider;
import snownee.jade.addon.vanilla.ItemTooltipProvider;
import snownee.jade.addon.vanilla.JukeboxProvider;
import snownee.jade.addon.vanilla.LecternProvider;
import snownee.jade.addon.vanilla.MobBreedingProvider;
import snownee.jade.addon.vanilla.MobGrowthProvider;
import snownee.jade.addon.vanilla.MobSpawnerProvider;
import snownee.jade.addon.vanilla.NoteBlockProvider;
import snownee.jade.addon.vanilla.PaintingProvider;
import snownee.jade.addon.vanilla.PlayerHeadProvider;
import snownee.jade.addon.vanilla.PotionEffectsProvider;
import snownee.jade.addon.vanilla.RedstoneProvider;
import snownee.jade.addon.vanilla.TNTStabilityProvider;
import snownee.jade.addon.vanilla.TotalEnchantmentPowerProvider;
import snownee.jade.addon.vanilla.VillagerProfessionProvider;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.Identifiers;
import snownee.jade.api.WailaPlugin;
import snownee.jade.util.ClientPlatformProxy;
import snownee.jade.util.PlatformProxy;

@WailaPlugin
public class VanillaPlugin
implements IWailaPlugin {
    public static IWailaClientRegistration CLIENT_REGISTRATION;
    private static final Cache<BlockState, BlockState> CHEST_CACHE;

    @Override
    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider(BrewingStandProvider.INSTANCE, BrewingStandBlockEntity.class);
        registration.registerBlockDataProvider(BeehiveProvider.INSTANCE, BeehiveBlockEntity.class);
        registration.registerBlockDataProvider(CommandBlockProvider.INSTANCE, CommandBlockEntity.class);
        registration.registerBlockDataProvider(JukeboxProvider.INSTANCE, JukeboxBlockEntity.class);
        registration.registerBlockDataProvider(LecternProvider.INSTANCE, LecternBlockEntity.class);
        registration.registerBlockDataProvider(RedstoneProvider.INSTANCE, ComparatorBlockEntity.class);
        registration.registerBlockDataProvider(RedstoneProvider.INSTANCE, HopperBlockEntity.class);
        registration.registerBlockDataProvider(FurnaceProvider.INSTANCE, AbstractFurnaceBlockEntity.class);
        registration.registerEntityDataProvider(AnimalOwnerProvider.INSTANCE, Entity.class);
        registration.registerEntityDataProvider(PotionEffectsProvider.INSTANCE, LivingEntity.class);
        registration.registerEntityDataProvider(MobGrowthProvider.INSTANCE, AgeableMob.class);
        registration.registerEntityDataProvider(MobGrowthProvider.INSTANCE, Tadpole.class);
        registration.registerEntityDataProvider(MobBreedingProvider.INSTANCE, Animal.class);
        registration.registerEntityDataProvider(MobBreedingProvider.INSTANCE, Allay.class);
        registration.registerEntityDataProvider(ChickenEggProvider.INSTANCE, Chicken.class);
    }

    @Override
    public void registerClient(IWailaClientRegistration registration) {
        CLIENT_REGISTRATION = registration;
        registration.addConfig(Identifiers.MC_EFFECTIVE_TOOL, true);
        registration.addConfig(Identifiers.MC_HARVEST_TOOL_NEW_LINE, false);
        registration.addConfig(Identifiers.MC_SHOW_UNBREAKABLE, true);
        registration.addConfig(Identifiers.MC_BREAKING_PROGRESS, true);
        registration.addConfig(Identifiers.MC_ENTITY_ARMOR_MAX_FOR_RENDER, 40, 10, 100, false);
        registration.addConfig(Identifiers.MC_ENTITY_HEALTH_MAX_FOR_RENDER, 40, 10, 100, false);
        registration.addConfig(Identifiers.MC_ENTITY_HEALTH_ICONS_PER_LINE, 10, 1, 30, false);
        registration.registerBlockComponent(BlockStatesProvider.INSTANCE, Block.class);
        registration.registerBlockComponent(BrewingStandProvider.INSTANCE, BrewingStandBlock.class);
        registration.registerEntityComponent(HorseStatsProvider.INSTANCE, AbstractHorse.class);
        registration.registerEntityComponent(ItemFrameProvider.INSTANCE, ItemFrame.class);
        registration.registerEntityComponent(PotionEffectsProvider.INSTANCE, LivingEntity.class);
        registration.registerEntityComponent(MobGrowthProvider.INSTANCE, AgeableMob.class);
        registration.registerEntityComponent(MobGrowthProvider.INSTANCE, Tadpole.class);
        registration.registerEntityComponent(MobBreedingProvider.INSTANCE, Animal.class);
        registration.registerEntityComponent(MobBreedingProvider.INSTANCE, Allay.class);
        registration.registerBlockComponent(TNTStabilityProvider.INSTANCE, TntBlock.class);
        registration.registerBlockComponent(BeehiveProvider.INSTANCE, BeehiveBlock.class);
        registration.registerBlockComponent(NoteBlockProvider.INSTANCE, NoteBlock.class);
        registration.registerEntityComponent(ArmorStandProvider.INSTANCE, ArmorStand.class);
        registration.registerEntityComponent(PaintingProvider.INSTANCE, Painting.class);
        registration.registerEntityComponent(ChickenEggProvider.INSTANCE, Chicken.class);
        registration.registerBlockComponent(HarvestToolProvider.INSTANCE, Block.class);
        registration.registerBlockComponent(CommandBlockProvider.INSTANCE, CommandBlock.class);
        registration.registerBlockComponent(EnchantmentPowerProvider.INSTANCE, Block.class);
        registration.registerBlockComponent(TotalEnchantmentPowerProvider.INSTANCE, EnchantmentTableBlock.class);
        registration.registerBlockIcon(PlayerHeadProvider.INSTANCE, AbstractSkullBlock.class);
        registration.registerBlockComponent(PlayerHeadProvider.INSTANCE, AbstractSkullBlock.class);
        registration.registerEntityComponent(VillagerProfessionProvider.INSTANCE, Villager.class);
        registration.registerEntityComponent(VillagerProfessionProvider.INSTANCE, ZombieVillager.class);
        registration.registerEntityComponent(ItemTooltipProvider.INSTANCE, ItemEntity.class);
        registration.registerBlockComponent(FurnaceProvider.INSTANCE, AbstractFurnaceBlock.class);
        registration.registerEntityComponent(AnimalOwnerProvider.INSTANCE, Entity.class);
        registration.registerEntityComponent(FallingBlockProvider.INSTANCE, FallingBlockEntity.class);
        registration.registerEntityIcon(FallingBlockProvider.INSTANCE, FallingBlockEntity.class);
        registration.registerEntityComponent(EntityHealthProvider.INSTANCE, LivingEntity.class);
        registration.registerEntityComponent(EntityArmorProvider.INSTANCE, LivingEntity.class);
        registration.registerBlockComponent(RedstoneProvider.INSTANCE, Block.class);
        registration.registerBlockComponent(CropProgressProvider.INSTANCE, Block.class);
        registration.registerBlockComponent(JukeboxProvider.INSTANCE, JukeboxBlock.class);
        registration.registerBlockComponent(LecternProvider.INSTANCE, LecternBlock.class);
        registration.registerBlockComponent(MobSpawnerProvider.INSTANCE, SpawnerBlock.class);
        ClientPlatformProxy.registerReloadListener(HarvestToolProvider.INSTANCE);
        registration.addRayTraceCallback(JadeClient::builtInOverrides);
        registration.addAfterRenderCallback(JadeClient::drawBreakingProgress);
        registration.hideTarget(EntityType.f_20476_);
        registration.hideTarget(EntityType.f_20451_);
        registration.hideTarget(Blocks.f_50375_);
        registration.usePickedResult(EntityType.f_20552_);
        registration.usePickedResult(EntityType.f_217016_);
    }

    public static BlockState getCorrespondingNormalChest(BlockState state) {
        try {
            return (BlockState)CHEST_CACHE.get((Object)state, () -> {
                ResourceLocation chestName;
                Block block;
                ResourceLocation trappedName = PlatformProxy.getId(state.m_60734_());
                if (trappedName.m_135815_().startsWith("trapped_") && (block = (Block)Registry.f_122824_.m_7745_(chestName = new ResourceLocation(trappedName.m_135827_(), trappedName.m_135815_().substring(8)))) != null) {
                    return VanillaPlugin.copyProperties(state, block.m_49966_());
                }
                return state;
            });
        }
        catch (Exception e) {
            return state;
        }
    }

    private static <T extends Comparable<T>> BlockState copyProperties(BlockState oldState, BlockState newState) {
        for (Map.Entry entry : oldState.m_61148_().entrySet()) {
            Property property = (Property)entry.getKey();
            if (!newState.m_61138_(property)) continue;
            newState = (BlockState)newState.m_61124_(property, (Comparable)property.m_61709_().cast(entry.getValue()));
        }
        return newState;
    }

    static {
        CHEST_CACHE = CacheBuilder.newBuilder().build();
    }
}

